/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.CloseableThreadLocal;

public abstract class Analyzer {
    private CloseableThreadLocal tokenStreams = new CloseableThreadLocal();

    public abstract TokenStream tokenStream(String var1, Reader var2);

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return this.tokenStream(fieldName, reader);
    }

    protected Object getPreviousTokenStream() {
        try {
            return this.tokenStreams.get();
        }
        catch (NullPointerException npe) {
            if (this.tokenStreams == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            throw npe;
        }
    }

    protected void setPreviousTokenStream(Object obj) {
        try {
            this.tokenStreams.set(obj);
        }
        catch (NullPointerException npe) {
            if (this.tokenStreams == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            throw npe;
        }
    }

    public int getPositionIncrementGap(String fieldName) {
        return 0;
    }

    public void close() {
        this.tokenStreams.close();
        this.tokenStreams = null;
    }
}

