/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;

public class FileStoreOutputStream
extends OutputStream {
    private FileStore store;
    private DataPage page;

    public FileStoreOutputStream(FileStore store, DataHandler handler) {
        this.store = store;
        this.page = DataPage.create(handler, 16);
    }

    public void write(byte[] buff, int off, int len) throws IOException {
        this.page.reset();
        this.page.writeInt(len);
        this.page.write(buff, off, len);
        this.page.fillAligned();
        try {
            this.store.write(this.page.getBytes(), 0, this.page.length());
        }
        catch (SQLException e) {
            throw Message.convertToIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.store != null) {
            this.page.reset();
            this.page.writeInt(-1);
            this.page.fillAligned();
            try {
                this.store.write(this.page.getBytes(), 0, this.page.length());
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
            try {
                this.store.close();
            }
            finally {
                this.store = null;
            }
        }
    }

    public void write(int b) throws IOException {
        throw new IOException("this method is not implemented");
    }
}

