/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.indexer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.h2.tools.indexer.Page;
import org.h2.tools.indexer.Weight;

public class Word {
    String name;
    HashMap pages = new HashMap();
    ArrayList weightList;

    Word(String name) {
        this.name = name;
    }

    void addPage(Page page, int weight) {
        Weight w = (Weight)this.pages.get(page);
        if (w == null) {
            w = new Weight();
            w.page = page;
            this.pages.put(page, w);
        }
        w.value += weight;
        ++page.relations;
    }

    ArrayList getSortedWeights() {
        if (this.weightList == null) {
            this.weightList = new ArrayList(this.pages.values());
            Collections.sort(this.weightList, new Comparator(){

                public int compare(Object o0, Object o1) {
                    Weight w0 = (Weight)o0;
                    Weight w1 = (Weight)o1;
                    return w0.value < w1.value ? 1 : (w0.value == w1.value ? 0 : -1);
                }
            });
        }
        return this.weightList;
    }
}

