/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.util.OraURI;
import oracle.xml.util.OraURIException;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class ResolveURI
extends OXMLFunction {
    private int numParams;

    ResolveURI(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "resolve-uri";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(2, 17);
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        if (n == 1) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            return oXMLSequence3;
        }
        OXMLItem oXMLItem2 = FNUtil.getSingleItem(oXMLSequence2);
        String string = oXMLItem.getString();
        String string2 = oXMLItem2.getString();
        String string3 = this.resolveURI(string, string2);
        OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
        oXMLItem3.setString(OXMLSequenceType.TANYURI, string3);
        oXMLSequence3.appendItem(oXMLItem3);
        return oXMLSequence3;
    }

    private String resolveURI(String string, String string2) throws XQException {
        try {
            OraURI oraURI = new OraURI(string);
            if (oraURI.isAbsolute()) {
                return string;
            }
            if (string2 == null) {
                throw new XQException("FONS0005");
            }
            OraURI oraURI2 = new OraURI(string2);
            if (!oraURI2.isAbsolute()) {
                throw new XQException("FORG0009");
            }
            OraURI oraURI3 = oraURI2.resolve(oraURI);
            return oraURI3.toString();
        }
        catch (OraURIException oraURIException) {
            throw new XQException("FORG0002");
        }
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            return oXMLSequence2;
        }
        String string = oXMLItem.getString();
        String string2 = oXMLFunctionContext.getBaseURI();
        String string3 = this.resolveURI(string, string2);
        OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
        oXMLItem2.setString(OXMLSequenceType.TANYURI, string3);
        oXMLSequence2.appendItem(oXMLItem2);
        return oXMLSequence2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = oXMLSequenceArray.length == 1 ? this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]) : this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        return oXMLSequence;
    }
}

