# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "amqp-utils"
  s.version = "0.2.3"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Doug Barth"]
  s.date = "2010-09-29"
  s.description = "Command line utilies for interacting with AMQP compliant queues.\n      The intention is provide simple management tools that can be used to complete ad hoc\n      housework on an AMQP queue. In addition, simple scripts can be layered over the tools\n      when needed."
  s.email = "dougbarth@gmail.com"
  s.executables = ["amqp-deleteq", "amqp-dequeue", "amqp-enqueue", "amqp-peek", "amqp-pop", "amqp-purge", "amqp-statq"]
  s.extra_rdoc_files = ["README.txt"]
  s.files = ["bin/amqp-deleteq", "bin/amqp-dequeue", "bin/amqp-enqueue", "bin/amqp-peek", "bin/amqp-pop", "bin/amqp-purge", "bin/amqp-statq", "README.txt"]
  s.homepage = "http://github.com/dougbarth/amqp-utils"
  s.rdoc_options = ["--charset=UTF-8"]
  s.require_paths = ["lib"]
  s.rubyforge_project = "amqp-utils"
  s.rubygems_version = "1.8.23"
  s.summary = "Command line utilities for interacting with AMQP compliant queues"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<amqp>, ["~> 0.6.7"])
      s.add_runtime_dependency(%q<trollop>, [">= 1.10.2"])
      s.add_runtime_dependency(%q<facets>, ["~> 2.7.0"])
      s.add_runtime_dependency(%q<clio>, ["~> 0.3.0"])
      s.add_runtime_dependency(%q<json>, [">= 1.1.6"])
    else
      s.add_dependency(%q<amqp>, ["~> 0.6.7"])
      s.add_dependency(%q<trollop>, [">= 1.10.2"])
      s.add_dependency(%q<facets>, ["~> 2.7.0"])
      s.add_dependency(%q<clio>, ["~> 0.3.0"])
      s.add_dependency(%q<json>, [">= 1.1.6"])
    end
  else
    s.add_dependency(%q<amqp>, ["~> 0.6.7"])
    s.add_dependency(%q<trollop>, [">= 1.10.2"])
    s.add_dependency(%q<facets>, ["~> 2.7.0"])
    s.add_dependency(%q<clio>, ["~> 0.3.0"])
    s.add_dependency(%q<json>, [">= 1.1.6"])
  end
end
