/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul.filter;

import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.filter.FilterMethodFactory;
import de.tu_darmstadt.sp.paul.filter.LZWInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LZWDecodeMethodFactory
implements FilterMethodFactory {
    public InputStream createInputFilter(InputStream in, PDFObject options) throws IOException {
        if (options != PDFObject.NULL) {
            PDFDictionary dict = (PDFDictionary)options;
            PDFObject val = dict.get("Predictor");
            if (val != null && ((PDFInteger)val).intValue() != 1) {
                throw new RuntimeException("LZWDecode option Predictor != 1 is not supported.");
            }
            val = dict.get("EarlyChange");
            if (val != null && ((PDFInteger)val).intValue() != 1) {
                throw new RuntimeException("LZWDecode option EarlyChange != 1 is not supported.");
            }
        }
        return new LZWInputStream(in);
    }

    public OutputStream createOutputFilter(OutputStream out, PDFObject options) throws IOException {
        throw new RuntimeException("Compression is not implemented filter for LZWDecode due to licensing reasons. Use FlateDecode instead.");
    }
}

