/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.jar.Action;
import gnu.classpath.tools.jar.Entry;
import gnu.classpath.tools.jar.Main;
import gnu.classpath.tools.jar.Messages;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;

public class Creator
extends Action {
    JarOutputStream outputStream;
    HashSet writtenItems;
    Manifest manifest;

    private /* synthetic */ void finit$() {
        this.writtenItems = new HashSet();
    }

    private long copyFile(CRC32 cRC32, InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            l += (long)n;
            outputStream.write(byArray, 0, n);
            cRC32.update(byArray, 0, n);
        }
        outputStream.close();
        return l;
    }

    protected void writeFile(boolean bl, InputStream inputStream, String string, boolean bl2) throws IOException {
        if (this.writtenItems.contains(string)) {
            if (bl2) {
                String string2 = MessageFormat.format(Messages.getString("Creator.Ignoring"), string);
                System.err.println(string2);
            }
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CRC32 cRC32 = new CRC32();
        long l = bl ? 0L : this.copyFile(cRC32, inputStream, byteArrayOutputStream);
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setCrc(cRC32.getValue());
        zipEntry.setSize(l);
        this.outputStream.putNextEntry(zipEntry);
        byteArrayOutputStream.writeTo(this.outputStream);
        this.outputStream.closeEntry();
        this.writtenItems.add(string);
        if (bl2) {
            long l2 = zipEntry.getCompressedSize();
            long l3 = l == 0L ? 0L : (long)100 - (long)100 * l2 / l;
            String string3 = MessageFormat.format(Messages.getString("Creator.Adding"), string, l, zipEntry.getSize(), l3);
            System.err.println(string3);
        }
    }

    protected void writeFile(File file, String string, boolean bl) throws IOException {
        boolean bl2 = file.isDirectory();
        FileInputStream fileInputStream = null;
        if (bl2) {
            if (string.charAt(string.length() - 1) != '/') {
                string = string + '/';
            }
        } else {
            fileInputStream = new FileInputStream(file);
        }
        this.writeFile(bl2, fileInputStream, string, bl);
    }

    private void addEntries(ArrayList arrayList, Entry entry) {
        if (entry.file.isDirectory()) {
            String string = entry.name;
            if (string.charAt(string.length() - 1) != '/') {
                string = string + '/';
                entry = new Entry(entry.file, string);
            }
            arrayList.add(entry);
            String[] stringArray = entry.file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addEntries(arrayList, new Entry(new File(entry.file, stringArray[i]), entry.name + stringArray[i]));
            }
        } else {
            arrayList.add(entry);
        }
    }

    private ArrayList getAllEntries(Main main) {
        Iterator iterator = main.entries.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            this.addEntries(arrayList, entry);
        }
        return arrayList;
    }

    private void writeCommandLineEntries(Main main) throws IOException {
        this.writtenItems.add("META-INF/");
        this.writtenItems.add("META-INF/MANIFEST.MF");
        ArrayList arrayList = this.getAllEntries(main);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            this.writeFile(entry.file, entry.name, main.verbose);
        }
    }

    protected Manifest createManifest(Main main) throws IOException {
        if (!main.wantManifest) {
            return null;
        }
        if (main.manifestFile != null) {
            FileInputStream fileInputStream = new FileInputStream(main.manifestFile);
            return new Manifest(fileInputStream);
        }
        return new Manifest();
    }

    protected void writeCommandLineEntries(Main main, OutputStream outputStream) throws IOException {
        this.manifest = this.createManifest(main);
        this.outputStream = new JarOutputStream(outputStream, this.manifest);
        this.outputStream.setMethod(main.storageMode);
        this.writeCommandLineEntries(main);
    }

    protected void close() throws IOException {
        this.outputStream.finish();
        this.outputStream.close();
    }

    public void run(Main main) throws IOException {
        if (main.archiveFile == null || main.archiveFile.equals("-")) {
            this.writeCommandLineEntries(main, System.out);
        } else {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(main.archiveFile));
            this.writeCommandLineEntries(main, bufferedOutputStream);
        }
        this.close();
    }

    public Creator() {
        this.finit$();
    }
}

