/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractSequentialList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class AWTUtilities {
    static WeakHashMap visibleChildrenCache = new WeakHashMap();

    public static List getVisibleChildren(Container container) {
        Component[] componentArray = container.getComponents();
        Object object = visibleChildrenCache.get(componentArray);
        VisibleComponentList visibleComponentList = null;
        if (object == null) {
            visibleComponentList = new VisibleComponentList(componentArray);
            visibleChildrenCache.put(componentArray, visibleComponentList);
        } else {
            visibleComponentList = (VisibleComponentList)object;
        }
        return visibleComponentList;
    }

    public static Rectangle calculateInsetArea(Rectangle rectangle, Insets insets, Rectangle rectangle2) {
        if (rectangle2 == null) {
            rectangle2 = new Rectangle();
        }
        rectangle2.setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        return rectangle2;
    }

    public static Rectangle getLocalBounds(Component component) {
        Rectangle rectangle = component.getBounds();
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static Container getAncestorNamed(String string, Component component) {
        while (component != null && component.getName() != string) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Container getAncestorOfClass(Class clazz, Component component) {
        while (component != null && !clazz.isInstance(component)) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Window windowForComponent(Component component) {
        return (Window)AWTUtilities.getAncestorOfClass(AWTUtilities.class$("java.awt.Window"), component);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Component getRoot(Component component) {
        Applet applet = null;
        Window window = null;
        while (component != null) {
            if (window == null && component instanceof Window) {
                window = (Window)component;
            } else if (component instanceof Applet) {
                applet = (Applet)component;
            }
            component = component.getParent();
        }
        if (window != null) {
            return window;
        }
        return applet;
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        while (component != null && component2 != null) {
            if (component == component2) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component component, int n, int n2) {
        if (component == null || !component.contains(n, n2)) {
            return null;
        }
        if (!(component instanceof Container)) {
            return component;
        }
        Container container = (Container)component;
        return container.findComponentAt(n, n2);
    }

    public static void convertPointToScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(point2.x, point2.y);
    }

    public static void convertPointFromScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
    }

    public static Point convertPoint(Component component, int n, int n2, Component component2) {
        Point point = new Point(n, n2);
        if (component == null && component2 == null) {
            return point;
        }
        if (component == null) {
            component = AWTUtilities.getRoot(component2);
        }
        if (component2 == null) {
            component2 = AWTUtilities.getRoot(component);
        }
        if (component.isShowing() && component2.isShowing()) {
            AWTUtilities.convertPointToScreen(point, component);
            AWTUtilities.convertPointFromScreen(point, component2);
        }
        return point;
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        Point point = AWTUtilities.convertPoint(component, rectangle.x, rectangle.y, component2);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    public static MouseEvent convertMouseEvent(Component component, MouseEvent mouseEvent, Component component2) {
        Point point = AWTUtilities.convertPoint(component, mouseEvent.getX(), mouseEvent.getY(), component2);
        return new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    static class VisibleComponentList
    extends AbstractSequentialList {
        Component[] components;

        VisibleComponentList(Component[] componentArray) {
            this.components = componentArray;
        }

        public ListIterator listIterator(int n) {
            return new VisibleComponentIterator(this, n);
        }

        public int size() {
            int n = 0;
            for (int i = 0; i < this.components.length; ++i) {
                if (!this.components[i].isVisible()) continue;
                ++n;
            }
            return n;
        }

        class VisibleComponentIterator
        implements ListIterator {
            private /* synthetic */ VisibleComponentList this$1;
            int index;
            int listIndex;

            VisibleComponentIterator(VisibleComponentList visibleComponentList, int n) {
                this.this$1 = visibleComponentList;
                this.listIndex = n;
                int n2 = 0;
                this.index = 0;
                while (n2 != n) {
                    if (visibleComponentList.components[this.index].isVisible()) {
                        ++n2;
                    }
                    ++this.index;
                }
            }

            public boolean hasNext() {
                boolean bl = false;
                for (int i = this.index; i < this.this$1.components.length; ++i) {
                    if (!this.this$1.components[i].isVisible()) continue;
                    bl = true;
                    break;
                }
                return bl;
            }

            public Object next() {
                Component component = null;
                while (this.index < this.this$1.components.length) {
                    if (this.this$1.components[this.index].isVisible()) {
                        component = this.this$1.components[this.index];
                        break;
                    }
                    ++this.index;
                }
                if (component != null) {
                    ++this.index;
                    ++this.listIndex;
                    return component;
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                boolean bl = false;
                for (int i = this.index - 1; i >= 0; --i) {
                    if (!this.this$1.components[i].isVisible()) continue;
                    bl = true;
                    break;
                }
                return bl;
            }

            public Object previous() {
                Component component = null;
                --this.index;
                while (this.index >= 0) {
                    if (this.this$1.components[this.index].isVisible()) {
                        component = this.this$1.components[this.index];
                        break;
                    }
                    --this.index;
                }
                if (component != null) {
                    --this.listIndex;
                    return component;
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.listIndex + 1;
            }

            public int previousIndex() {
                return this.listIndex - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }

            public void set(Object object) {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }

            public void add(Object object) {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }
        }
    }
}

