/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.ZonePathIterator;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

final class Zone {
    private final int[] pos;
    private final int[] origPos;
    private final byte[] flags;
    private int numPoints;
    private static final int FLAG_TOUCHED_X = 1;
    private static final int FLAG_TOUCHED_Y = 2;
    private static final int FLAG_ON_CURVE = 4;
    private static final int FLAG_CONTOUR_END = 8;

    public Zone(int n) {
        this.origPos = new int[n * 2];
        this.pos = new int[n * 2];
        this.flags = new byte[n];
    }

    public int getCapacity() {
        return this.flags.length;
    }

    public int getSize() {
        return this.numPoints;
    }

    public int getX(int n) {
        return this.pos[2 * n];
    }

    public void setX(int n, int n2, boolean bl) {
        this.pos[2 * n] = n2;
        if (bl) {
            int n3 = n;
            this.flags[n3] = this.flags[n3] | 1;
        }
    }

    public void setY(int n, int n2, boolean bl) {
        this.pos[2 * n + 1] = n2;
        if (bl) {
            int n3 = n;
            this.flags[n3] = this.flags[n3] | 2;
        }
    }

    public int getY(int n) {
        return this.pos[2 * n + 1];
    }

    public int getOriginalX(int n) {
        return this.origPos[2 * n];
    }

    public int getOriginalY(int n) {
        return this.origPos[2 * n + 1];
    }

    public void setOriginalX(int n, int n2) {
        this.origPos[2 * n] = n2;
    }

    public void setOriginalY(int n, int n2) {
        this.origPos[2 * n + 1] = n2;
    }

    public void setNumPoints(int n) {
        int n2;
        this.numPoints = n;
        for (n2 = 0; n2 < n; ++n2) {
            this.flags[n2] = 0;
        }
        for (n2 = 0; n2 < 2 * n; ++n2) {
            this.pos[n2] = 0;
            this.origPos[n2] = 0;
        }
    }

    public boolean isOnCurve(int n) {
        return (this.flags[n] & 4) != 0;
    }

    public void setOnCurve(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.flags[n2] = this.flags[n2] | 4;
        } else {
            int n3 = n;
            this.flags[n3] = this.flags[n3] & 0xFFFFFFFB;
        }
    }

    public boolean isContourEnd(int n) {
        return (this.flags[n] & 8) != 0;
    }

    public void setContourEnd(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.flags[n2] = this.flags[n2] | 8;
        } else {
            int n3 = n;
            this.flags[n3] = this.flags[n3] & 0xFFFFFFF7;
        }
    }

    void transform(double d, AffineTransform affineTransform, int n, int n2, int n3) {
        double d2 = d / (double)n;
        double d3 = affineTransform.getScaleX() * d2;
        double d4 = affineTransform.getScaleY() * d2;
        double d5 = affineTransform.getShearX() * d2;
        double d6 = affineTransform.getShearY() * d2;
        for (int i = 0; i < this.numPoints; ++i) {
            int n4 = this.origPos[2 * i] + n2;
            int n5 = this.origPos[2 * i + 1] + n3;
            int n6 = Fixed.valueOf(d3 * (double)n4 + d5 * (double)n5);
            this.pos[2 * i] = n6;
            this.origPos[2 * i] = n6;
            int n7 = Fixed.valueOf(d6 * (double)n4 + d4 * (double)n5);
            this.pos[2 * i + 1] = n7;
            this.origPos[2 * i + 1] = n7;
        }
    }

    void combineWithSubGlyph(Zone zone, int n) {
        int n2 = this.numPoints - n;
        int n3 = zone.numPoints;
        System.arraycopy(zone.origPos, 0, this.origPos, 2 * n2, n3 * 2);
        System.arraycopy(zone.pos, 0, this.pos, 2 * n2, n3 * 2);
        System.arraycopy(zone.flags, 0, this.flags, n2, n3);
        this.numPoints += n3 - n;
    }

    private void dump() {
        for (int i = 0; i < this.numPoints; ++i) {
            System.out.print(" " + i + ": ");
            System.out.print(Fixed.toString(this.pos[i * 2], this.pos[i * 2 + 1]));
            System.out.print(' ');
            System.out.print(Fixed.toString(this.origPos[i * 2], this.origPos[i * 2 + 1]));
            System.out.print(' ');
            if (this.isOnCurve(i)) {
                System.out.print('.');
            } else {
                System.out.print('c');
            }
            if (this.isContourEnd(i)) {
                System.out.print('E');
            }
            System.out.println();
            if (!this.isContourEnd(i)) continue;
            System.out.println();
        }
    }

    public PathIterator getPathIterator() {
        return new ZonePathIterator(this);
    }

    public GeneralPath getPath() {
        GeneralPath generalPath = new GeneralPath(1, this.numPoints);
        generalPath.append(this.getPathIterator(), false);
        return generalPath;
    }
}

