/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import java.util.Arrays;
import java.util.logging.Logger;

public class EMSA_PSS
implements Cloneable {
    private static final Logger log = Logger.getLogger(EMSA_PSS.class$("gnu.java.security.sig.rsa.EMSA_PSS").getName());
    private IMessageDigest hash;
    private int hLen;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private EMSA_PSS(IMessageDigest iMessageDigest) {
        this.hash = iMessageDigest;
        this.hLen = iMessageDigest.hashSize();
    }

    public static EMSA_PSS getInstance(String string) {
        IMessageDigest iMessageDigest = HashFactory.getInstance(string);
        return new EMSA_PSS(iMessageDigest);
    }

    public Object clone() {
        return EMSA_PSS.getInstance(this.hash.name());
    }

    public byte[] encode(byte[] byArray, int n, byte[] byArray2) {
        int n2 = byArray2.length;
        if (this.hLen != byArray.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (n < 8 * this.hLen + 8 * n2 + 9) {
            throw new IllegalArgumentException("encoding error");
        }
        int n3 = (n + 7) / 8;
        IMessageDigest iMessageDigest = this.hash;
        synchronized (iMessageDigest) {
            byte[] byArray3;
            byte[] byArray4;
            int n4;
            try {
                for (n4 = 0; n4 < 8; ++n4) {
                    this.hash.update((byte)0);
                }
                this.hash.update(byArray, 0, this.hLen);
                this.hash.update(byArray2, 0, n2);
                byArray4 = this.hash.digest();
            }
            finally {
                byArray3 = null;
            }
            byArray3 = new byte[n3 - n2 - this.hLen - 2 + 1 + n2];
            byArray3[n3 - n2 - this.hLen - 2] = 1;
            System.arraycopy(byArray2, 0, byArray3, n3 - n2 - this.hLen - 1, n2);
            byte[] byArray5 = this.MGF(byArray4, n3 - this.hLen - 1);
            for (n4 = 0; n4 < byArray3.length; ++n4) {
                byArray3[n4] = byArray3[n4] ^ byArray5[n4];
            }
            byArray3[0] = byArray3[0] & (byte)(255 >>> (8 * n3 - n & 0x1F));
            byte[] byArray6 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray6, 0, n3 - this.hLen - 1);
            System.arraycopy(byArray4, 0, byArray6, n3 - this.hLen - 1, this.hLen);
            byArray6[n3 - 1] = -68;
            byte[] byArray7 = byArray6;
            return byArray7;
        }
    }

    public boolean decode(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("sLen");
        }
        if (this.hLen != byArray.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (n < 8 * this.hLen + 8 * n2 + 9) {
            throw new IllegalArgumentException("decoding error");
        }
        int n4 = (n + 7) / 8;
        if ((byArray2[byArray2.length - 1] & 0xFF) != 188) {
            return false;
        }
        if ((byArray2[0] & 255 << (8 - (8 * n4 - n) & 0x1F)) != 0) {
            return false;
        }
        byte[] byArray3 = new byte[n4 - this.hLen - 1];
        byte[] byArray4 = new byte[this.hLen];
        System.arraycopy(byArray2, 0, byArray3, 0, n4 - this.hLen - 1);
        System.arraycopy(byArray2, n4 - this.hLen - 1, byArray4, 0, this.hLen);
        byte[] byArray5 = this.MGF(byArray4, n4 - this.hLen - 1);
        for (n3 = 0; n3 < byArray3.length; ++n3) {
            byArray3[n3] = byArray3[n3] ^ byArray5[n3];
        }
        byArray3[0] = byArray3[0] & (byte)(255 >>> (8 * n4 - n & 0x1F));
        for (n3 = 0; n3 < n4 - this.hLen - n2 - 2; ++n3) {
            if (byArray3[n3] == 0) continue;
            return false;
        }
        if (byArray3[n3] != 1) {
            return false;
        }
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray3, byArray3.length - n2, byArray6, 0, n2);
        IMessageDigest iMessageDigest = this.hash;
        synchronized (iMessageDigest) {
            byte[] byArray7;
            try {
                for (n3 = 0; n3 < 8; ++n3) {
                    this.hash.update((byte)0);
                }
                this.hash.update(byArray, 0, this.hLen);
                this.hash.update(byArray6, 0, n2);
                byArray7 = this.hash.digest();
            }
            finally {
                Object var13_13 = null;
            }
            boolean bl = Arrays.equals(byArray4, byArray7);
            return bl;
        }
    }

    private byte[] MGF(byte[] byArray, int n) {
        if (n < 1 || ((long)n & 0xFFFFFFFFL) > ((long)this.hLen & 0xFFFFFFFFL) << ((int)((long)32) & 0x3F)) {
            throw new IllegalArgumentException("mask too long");
        }
        byte[] byArray2 = new byte[n];
        int n2 = (n + this.hLen - 1) / this.hLen - 1;
        IMessageDigest iMessageDigest = null;
        iMessageDigest = (IMessageDigest)this.hash.clone();
        iMessageDigest.digest();
        iMessageDigest.update(byArray, 0, byArray.length);
        IMessageDigest iMessageDigest2 = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            iMessageDigest2 = (IMessageDigest)iMessageDigest.clone();
            iMessageDigest2.update((byte)(i >>> 24));
            iMessageDigest2.update((byte)(i >>> 16));
            iMessageDigest2.update((byte)(i >>> 8));
            iMessageDigest2.update((byte)i);
            byte[] byArray3 = iMessageDigest2.digest();
            int n4 = n - n3;
            n4 = n4 > this.hLen ? this.hLen : n4;
            System.arraycopy(byArray3, 0, byArray2, n3, n4);
            n3 += n4;
        }
        return byArray2;
    }
}

