/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.cipher;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.jce.cipher.CipherAdapter;
import gnu.javax.crypto.prng.PRNGFactory;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class PBES2
extends CipherAdapter {
    protected String macName;

    protected PBES2(String string, int n, String string2) {
        super(string, n);
        this.macName = string2;
    }

    protected PBES2(String string, String string2) {
        super(string);
        this.macName = string2;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("not a PBE key");
        }
        super.engineInit(n, this.genkey((PBEKey)key), secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("not a PBE key");
        }
        super.engineInit(n, (Key)this.genkey((PBEKey)key), algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("not a PBE key");
        }
        super.engineInit(n, (Key)this.genkey((PBEKey)key), algorithmParameters, secureRandom);
    }

    private SecretKeySpec genkey(PBEKey pBEKey) throws InvalidKeyException {
        IRandom iRandom = PRNGFactory.getInstance("PBKDF2-" + this.macName);
        if (iRandom == null) {
            throw new IllegalArgumentException("no such KDF: PBKDF2-" + this.macName);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.pbe.iteration.count", pBEKey.getIterationCount());
        hashMap.put("gnu.crypto.pbe.password", pBEKey.getPassword());
        hashMap.put("gnu.crypto.pbe.salt", pBEKey.getSalt());
        try {
            iRandom.init(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidKeyException(illegalArgumentException.toString());
        }
        byte[] byArray = new byte[this.mode.defaultKeySize()];
        try {
            iRandom.nextBytes(byArray, 0, byArray.length);
        }
        catch (LimitReachedException limitReachedException) {
            throw new Error(String.valueOf(limitReachedException));
        }
        return new SecretKeySpec(byArray, this.cipher.name());
    }

    public static class HMacWhirlpool
    extends PBES2 {
        public HMacWhirlpool(String string, int n) {
            super(string, n, "HMAC-WHIRLPOOL");
        }

        public HMacWhirlpool(String string) {
            super(string, "HMAC-WHIRLPOOL");
        }

        public static class Twofish
        extends HMacWhirlpool {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacWhirlpool {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacWhirlpool {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacWhirlpool {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacWhirlpool {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacWhirlpool {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacWhirlpool {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacWhirlpool {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacWhirlpool {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacWhirlpool {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacTiger
    extends PBES2 {
        public HMacTiger(String string, int n) {
            super(string, n, "HMAC-TIGER");
        }

        public HMacTiger(String string) {
            super(string, "HMAC-TIGER");
        }

        public static class Twofish
        extends HMacTiger {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacTiger {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacTiger {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacTiger {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacTiger {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacTiger {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacTiger {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacTiger {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacTiger {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacTiger {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacSHA512
    extends PBES2 {
        public HMacSHA512(String string, int n) {
            super(string, n, "HMAC-SHA-512");
        }

        public HMacSHA512(String string) {
            super(string, "HMAC-SHA-512");
        }

        public static class Twofish
        extends HMacSHA512 {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacSHA512 {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacSHA512 {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacSHA512 {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacSHA512 {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacSHA512 {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacSHA512 {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacSHA512 {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacSHA512 {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacSHA512 {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacSHA384
    extends PBES2 {
        public HMacSHA384(String string, int n) {
            super(string, n, "HMAC-SHA-384");
        }

        public HMacSHA384(String string) {
            super(string, "HMAC-SHA-384");
        }

        public static class Twofish
        extends HMacSHA384 {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacSHA384 {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacSHA384 {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacSHA384 {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacSHA384 {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacSHA384 {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacSHA384 {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacSHA384 {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacSHA384 {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacSHA384 {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacSHA256
    extends PBES2 {
        public HMacSHA256(String string, int n) {
            super(string, n, "HMAC-SHA-256");
        }

        public HMacSHA256(String string) {
            super(string, "HMAC-SHA-256");
        }

        public static class Twofish
        extends HMacSHA256 {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacSHA256 {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacSHA256 {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacSHA256 {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacSHA256 {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacSHA256 {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacSHA256 {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacSHA256 {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacSHA256 {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacSHA256 {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacRipeMD160
    extends PBES2 {
        public HMacRipeMD160(String string, int n) {
            super(string, n, "HMAC-RIPEMD160");
        }

        public HMacRipeMD160(String string) {
            super(string, "HMAC-RIPEMD160");
        }

        public static class Twofish
        extends HMacRipeMD160 {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacRipeMD160 {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacRipeMD160 {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacRipeMD160 {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacRipeMD160 {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacRipeMD160 {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacRipeMD160 {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacRipeMD160 {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacRipeMD160 {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacRipeMD160 {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacRipeMD128
    extends PBES2 {
        public HMacRipeMD128(String string, int n) {
            super(string, n, "HMAC-RIPEMD128");
        }

        public HMacRipeMD128(String string) {
            super(string, "HMAC-RIPEMD128");
        }

        public static class Twofish
        extends HMacRipeMD128 {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacRipeMD128 {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacRipeMD128 {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacRipeMD128 {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacRipeMD128 {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacRipeMD128 {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacRipeMD128 {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacRipeMD128 {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacRipeMD128 {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacRipeMD128 {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacHaval
    extends PBES2 {
        public HMacHaval(String string, int n) {
            super(string, n, "HMAC-HAVAL");
        }

        public HMacHaval(String string) {
            super(string, "HMAC-HAVAL");
        }

        public static class Twofish
        extends HMacHaval {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacHaval {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacHaval {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacHaval {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacHaval {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacHaval {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacHaval {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacHaval {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacHaval {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacHaval {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacMD4
    extends PBES2 {
        public HMacMD4(String string, int n) {
            super(string, n, "HMAC-MD4");
        }

        public HMacMD4(String string) {
            super(string, "HMAC-MD4");
        }

        public static class Twofish
        extends HMacMD4 {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacMD4 {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacMD4 {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacMD4 {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacMD4 {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacMD4 {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacMD4 {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacMD4 {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacMD4 {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacMD4 {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacMD2
    extends PBES2 {
        public HMacMD2(String string, int n) {
            super(string, n, "HMAC-MD2");
        }

        public HMacMD2(String string) {
            super(string, "HMAC-MD2");
        }

        public static class Twofish
        extends HMacMD2 {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacMD2 {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacMD2 {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacMD2 {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacMD2 {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacMD2 {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacMD2 {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacMD2 {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacMD2 {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacMD2 {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacMD5
    extends PBES2 {
        public HMacMD5(String string, int n) {
            super(string, n, "HMAC-MD5");
        }

        public HMacMD5(String string) {
            super(string, "HMAC-MD5");
        }

        public static class Twofish
        extends HMacMD5 {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacMD5 {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacMD5 {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacMD5 {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacMD5 {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacMD5 {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacMD5 {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacMD5 {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacMD5 {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacMD5 {
            public AES() {
                super("AES");
            }
        }
    }

    public static class HMacSHA1
    extends PBES2 {
        public HMacSHA1(String string, int n) {
            super(string, n, "HMAC-SHA1");
        }

        public HMacSHA1(String string) {
            super(string, "HMAC-SHA1");
        }

        public static class Twofish
        extends HMacSHA1 {
            public Twofish() {
                super("Twofish");
            }
        }

        public static class TripleDES
        extends HMacSHA1 {
            public TripleDES() {
                super("TripleDES");
            }
        }

        public static class Square
        extends HMacSHA1 {
            public Square() {
                super("Square");
            }
        }

        public static class Serpent
        extends HMacSHA1 {
            public Serpent() {
                super("Serpent");
            }
        }

        public static class Khazad
        extends HMacSHA1 {
            public Khazad() {
                super("Khazad");
            }
        }

        public static class DES
        extends HMacSHA1 {
            public DES() {
                super("DES");
            }
        }

        public static class Cast5
        extends HMacSHA1 {
            public Cast5() {
                super("Cast5");
            }
        }

        public static class Blowfish
        extends HMacSHA1 {
            public Blowfish() {
                super("Blowfish");
            }
        }

        public static class Anubis
        extends HMacSHA1 {
            public Anubis() {
                super("Anubis");
            }
        }

        public static class AES
        extends HMacSHA1 {
            public AES() {
                super("AES");
            }
        }
    }
}

