/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.classpath.debug.TeeInputStream;
import gnu.classpath.debug.TeeReader;
import gnu.java.net.CRLFInputStream;
import gnu.xml.stream.BufferedReader;
import gnu.xml.stream.CRLFReader;
import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XIncludeFilter;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLParser
implements XMLStreamReader,
NamespaceContext {
    private static final int INIT = 0;
    private static final int PROLOG = 1;
    private static final int CONTENT = 2;
    private static final int EMPTY_ELEMENT = 3;
    private static final int MISC = 4;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_NORMALIZE = 4;
    private static final int LIT_ATTRIBUTE = 8;
    private static final int LIT_DISABLE_PE = 16;
    private static final int LIT_DISABLE_CREF = 32;
    private static final int LIT_DISABLE_EREF = 64;
    private static final int LIT_PUBID = 256;
    static final int ATTRIBUTE_DEFAULT_UNDECLARED = 30;
    static final int ATTRIBUTE_DEFAULT_SPECIFIED = 31;
    static final int ATTRIBUTE_DEFAULT_IMPLIED = 32;
    static final int ATTRIBUTE_DEFAULT_REQUIRED = 33;
    static final int ATTRIBUTE_DEFAULT_FIXED = 34;
    static final int START_ENTITY = 50;
    static final int END_ENTITY = 51;
    private Input input;
    private LinkedList inputStack;
    private LinkedList startEntityStack;
    private LinkedList endEntityStack;
    private int state;
    private int event;
    private boolean lookahead;
    private LinkedList stack;
    private LinkedList namespaces;
    private LinkedList bases;
    private ArrayList attrs;
    private StringBuffer buf;
    private StringBuffer nmtokenBuf;
    private StringBuffer literalBuf;
    private int[] tmpBuf;
    private ContentModel currentContentModel;
    private LinkedList validationStack;
    private HashSet ids;
    private HashSet idrefs;
    private String piTarget;
    private String piData;
    private String xmlVersion;
    private String xmlEncoding;
    private Boolean xmlStandalone;
    Doctype doctype;
    private boolean expandPE;
    private boolean peIsError;
    private final boolean validating;
    private final boolean stringInterning;
    private final boolean coalescing;
    private final boolean replaceERefs;
    private final boolean externalEntities;
    private final boolean supportDTD;
    private final boolean namespaceAware;
    private final boolean baseAware;
    private final boolean extendedEventTypes;
    final XMLReporter reporter;
    final XMLResolver resolver;
    private static final String TEST_START_ELEMENT = "<";
    private static final String TEST_END_ELEMENT = "</";
    private static final String TEST_COMMENT = "<!--";
    private static final String TEST_PI = "<?";
    private static final String TEST_CDATA = "<![CDATA[";
    private static final String TEST_XML_DECL = "<?xml";
    private static final String TEST_DOCTYPE_DECL = "<!DOCTYPE";
    private static final String TEST_ELEMENT_DECL = "<!ELEMENT";
    private static final String TEST_ATTLIST_DECL = "<!ATTLIST";
    private static final String TEST_ENTITY_DECL = "<!ENTITY";
    private static final String TEST_NOTATION_DECL = "<!NOTATION";
    private static final String TEST_KET = ">";
    private static final String TEST_END_COMMENT = "--";
    private static final String TEST_END_PI = "?>";
    private static final String TEST_END_CDATA = "]]>";
    private static final LinkedHashMap PREDEFINED_ENTITIES;

    private /* synthetic */ void finit$() {
        this.inputStack = new LinkedList();
        this.startEntityStack = new LinkedList();
        this.endEntityStack = new LinkedList();
        this.state = 0;
        this.stack = new LinkedList();
        this.namespaces = new LinkedList();
        this.bases = new LinkedList();
        this.attrs = new ArrayList();
        this.buf = new StringBuffer();
        this.nmtokenBuf = new StringBuffer();
        this.literalBuf = new StringBuffer();
        this.tmpBuf = new int[1024];
    }

    static /* synthetic */ Input access$4(XMLParser xMLParser, Input input) {
        xMLParser.input = input;
        return xMLParser.input;
    }

    static /* synthetic */ LinkedList access$1(XMLParser xMLParser, LinkedList linkedList) {
        xMLParser.inputStack = linkedList;
        return xMLParser.inputStack;
    }

    public XMLParser(InputStream inputStream, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, XMLReporter xMLReporter, XMLResolver xMLResolver) {
        String string2;
        this.finit$();
        this.validating = bl;
        this.namespaceAware = bl2;
        this.coalescing = bl3;
        this.replaceERefs = bl4;
        this.externalEntities = bl5;
        this.supportDTD = bl6;
        this.baseAware = bl7;
        this.stringInterning = bl8;
        this.extendedEventTypes = bl9;
        this.reporter = xMLReporter;
        this.resolver = xMLResolver;
        if (bl) {
            this.validationStack = new LinkedList();
            this.ids = new HashSet();
            this.idrefs = new HashSet();
        }
        if ((string2 = System.getProperty("gnu.xml.debug.input")) != null) {
            try {
                File file = File.createTempFile(string2, ".xml");
                inputStream = new TeeInputStream(inputStream, new FileOutputStream(file));
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException();
                runtimeException.initCause(iOException);
                throw runtimeException;
            }
        }
        this.pushInput(new Input(inputStream, null, null, string, null, null, false, true));
    }

    public XMLParser(Reader reader, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, XMLReporter xMLReporter, XMLResolver xMLResolver) {
        String string2;
        this.finit$();
        this.validating = bl;
        this.namespaceAware = bl2;
        this.coalescing = bl3;
        this.replaceERefs = bl4;
        this.externalEntities = bl5;
        this.supportDTD = bl6;
        this.baseAware = bl7;
        this.stringInterning = bl8;
        this.extendedEventTypes = bl9;
        this.reporter = xMLReporter;
        this.resolver = xMLResolver;
        if (bl) {
            this.validationStack = new LinkedList();
            this.ids = new HashSet();
            this.idrefs = new HashSet();
        }
        if ((string2 = System.getProperty("gnu.xml.debug.input")) != null) {
            try {
                File file = File.createTempFile(string2, ".xml");
                reader = new TeeReader(reader, new FileWriter(file));
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException();
                runtimeException.initCause(iOException);
                throw runtimeException;
            }
        }
        this.pushInput(new Input(null, reader, null, string, null, null, false, true));
    }

    public String getNamespaceURI(String string) {
        if (XMLConstants.XML_NS_PREFIX.equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (XMLConstants.XMLNS_ATTRIBUTE.equals(string)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        Iterator iterator = this.namespaces.iterator();
        while (iterator.hasNext()) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)iterator.next();
            String string2 = (String)linkedHashMap.get(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public String getPrefix(String string) {
        if (XMLConstants.XML_NS_URI.equals(string)) {
            return "xml";
        }
        if (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(string)) {
            return "xmlns";
        }
        Iterator iterator = this.namespaces.iterator();
        while (iterator.hasNext()) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)iterator.next();
            if (!linkedHashMap.containsValue(string)) continue;
            Iterator iterator2 = linkedHashMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string2 = (String)entry.getValue();
                if (!string2.equals(string)) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        if (XMLConstants.XML_NS_URI.equals(string)) {
            return Collections.singleton("xml").iterator();
        }
        if (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(string)) {
            return Collections.singleton("xmlns").iterator();
        }
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.namespaces.iterator();
        while (iterator.hasNext()) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)iterator.next();
            if (!linkedHashMap.containsValue(string)) continue;
            Iterator iterator2 = linkedHashMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string2 = (String)entry.getValue();
                if (!string2.equals(string)) continue;
                linkedList.add(entry.getKey());
            }
        }
        return linkedList.iterator();
    }

    public void close() throws XMLStreamException {
        this.stack = null;
        this.namespaces = null;
        this.bases = null;
        this.buf = null;
        this.attrs = null;
        this.doctype = null;
        this.inputStack = null;
        this.validationStack = null;
        this.ids = null;
        this.idrefs = null;
    }

    public NamespaceContext getNamespaceContext() {
        return this;
    }

    public int getAttributeCount() {
        return this.attrs.size();
    }

    public String getAttributeLocalName(int n) {
        Attribute attribute = (Attribute)this.attrs.get(n);
        return attribute.localName;
    }

    public String getAttributeNamespace(int n) {
        String string = this.getAttributePrefix(n);
        return this.getNamespaceURI(string);
    }

    public String getAttributePrefix(int n) {
        Attribute attribute = (Attribute)this.attrs.get(n);
        return attribute.prefix;
    }

    public QName getAttributeName(int n) {
        Attribute attribute = (Attribute)this.attrs.get(n);
        String string = this.getNamespaceURI(attribute.prefix);
        return new QName(string, attribute.localName, attribute.prefix);
    }

    public String getAttributeType(int n) {
        Attribute attribute = (Attribute)this.attrs.get(n);
        return attribute.type;
    }

    private String getAttributeType(String string, String string2) {
        AttributeDecl attributeDecl;
        if (this.doctype != null && (attributeDecl = this.doctype.getAttributeDecl(string, string2)) != null) {
            return attributeDecl.type;
        }
        return "CDATA";
    }

    public String getAttributeValue(int n) {
        Attribute attribute = (Attribute)this.attrs.get(n);
        return attribute.value;
    }

    public String getAttributeValue(String string, String string2) {
        Iterator iterator = this.attrs.iterator();
        while (iterator.hasNext()) {
            String string3;
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.localName.equals(string2) || ((string3 = this.getNamespaceURI(attribute.prefix)) != null || string != null) && (string3 == null || !string3.equals(string))) continue;
            return attribute.value;
        }
        return null;
    }

    boolean isAttributeDeclared(int n) {
        if (this.doctype == null) {
            return false;
        }
        Attribute attribute = (Attribute)this.attrs.get(n);
        String string = "".equals(attribute.prefix) ? attribute.localName : attribute.prefix + ":" + attribute.localName;
        String string2 = this.buf.toString();
        return this.doctype.isAttributeDeclared(string2, string);
    }

    public String getCharacterEncodingScheme() {
        return this.xmlEncoding;
    }

    public String getElementText() throws XMLStreamException {
        if (this.event != 1) {
            throw new XMLStreamException("current event must be START_ELEMENT");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.stack.size();
        while (this.event != 2 || this.stack.size() > n) {
            switch (this.next()) {
                case 4: 
                case 6: {
                    stringBuffer.append(this.buf.toString());
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getEncoding() {
        if (this.input.inputEncoding == null) {
            return "UTF-8";
        }
        return this.input.inputEncoding;
    }

    public int getEventType() {
        return this.event;
    }

    public String getLocalName() {
        switch (this.event) {
            case 1: 
            case 2: {
                String string = this.buf.toString();
                int n = string.indexOf(58);
                if (n == -1) {
                    return string;
                }
                return string.substring(n + 1);
            }
        }
        return null;
    }

    public Location getLocation() {
        return this.input;
    }

    public QName getName() {
        switch (this.event) {
            case 1: 
            case 2: {
                String string;
                String string2 = this.buf.toString();
                int n = string2.indexOf(58);
                String string3 = string = n == -1 ? string2 : string2.substring(n + 1);
                String string4 = n == -1 ? (this.namespaceAware ? "" : null) : string2.substring(0, n);
                String string5 = this.getNamespaceURI(string4);
                return new QName(string5, string, string4);
            }
        }
        return null;
    }

    public int getNamespaceCount() {
        if (!this.namespaceAware || this.namespaces.isEmpty()) {
            return 0;
        }
        switch (this.event) {
            case 1: 
            case 2: {
                LinkedHashMap linkedHashMap = (LinkedHashMap)this.namespaces.getFirst();
                return linkedHashMap.size();
            }
        }
        return 0;
    }

    public String getNamespacePrefix(int n) {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.namespaces.getFirst();
        int n2 = 0;
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (n2++ != n) continue;
            return string;
        }
        return null;
    }

    public String getNamespaceURI() {
        switch (this.event) {
            case 1: 
            case 2: {
                String string = this.buf.toString();
                int n = string.indexOf(58);
                if (n == -1) {
                    return null;
                }
                String string2 = string.substring(0, n);
                return this.getNamespaceURI(string2);
            }
        }
        return null;
    }

    public String getNamespaceURI(int n) {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.namespaces.getFirst();
        int n2 = 0;
        Iterator iterator = linkedHashMap.values().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (n2++ != n) continue;
            return string;
        }
        return null;
    }

    public String getPIData() {
        return this.piData;
    }

    public String getPITarget() {
        return this.piTarget;
    }

    public String getPrefix() {
        switch (this.event) {
            case 1: 
            case 2: {
                String string = this.buf.toString();
                int n = string.indexOf(58);
                if (n == -1) {
                    if (this.namespaceAware) {
                        return "";
                    }
                    return null;
                }
                return string.substring(0, n);
            }
        }
        return null;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (XMLInputFactory.ALLOCATOR.equals(string)) {
            return null;
        }
        if (XMLInputFactory.IS_COALESCING.equals(string)) {
            return this.coalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if (XMLInputFactory.IS_NAMESPACE_AWARE.equals(string)) {
            return this.namespaceAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if (XMLInputFactory.IS_REPLACING_ENTITY_REFERENCES.equals(string)) {
            return this.replaceERefs ? Boolean.TRUE : Boolean.FALSE;
        }
        if (XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES.equals(string)) {
            return this.externalEntities ? Boolean.TRUE : Boolean.FALSE;
        }
        if (XMLInputFactory.IS_VALIDATING.equals(string)) {
            return Boolean.FALSE;
        }
        if (XMLInputFactory.REPORTER.equals(string)) {
            return this.reporter;
        }
        if (XMLInputFactory.RESOLVER.equals(string)) {
            return this.resolver;
        }
        if (XMLInputFactory.SUPPORT_DTD.equals(string)) {
            return this.supportDTD ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("gnu.xml.stream.stringInterning".equals(string)) {
            return this.stringInterning ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("gnu.xml.stream.xmlBase".equals(string)) {
            return this.baseAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("gnu.xml.stream.baseURI".equals(string)) {
            return this.getXMLBase();
        }
        return null;
    }

    public String getText() {
        return this.buf.toString();
    }

    public char[] getTextCharacters() {
        return this.buf.toString().toCharArray();
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        n3 = Math.min(n + this.buf.length(), n3);
        int n4 = n + n3;
        this.buf.getChars(n, n4, cArray, n2);
        return n3;
    }

    public int getTextLength() {
        return this.buf.length();
    }

    public int getTextStart() {
        return 0;
    }

    public String getVersion() {
        if (this.xmlVersion == null) {
            return "1.0";
        }
        return this.xmlVersion;
    }

    public boolean hasName() {
        switch (this.event) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean hasText() {
        switch (this.event) {
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isAttributeSpecified(int n) {
        Attribute attribute = (Attribute)this.attrs.get(n);
        return attribute.specified;
    }

    public boolean isCharacters() {
        return this.event == 4;
    }

    public boolean isEndElement() {
        return this.event == 2;
    }

    public boolean isStandalone() {
        return Boolean.TRUE.equals(this.xmlStandalone);
    }

    public boolean isStartElement() {
        return this.event == 1;
    }

    public boolean isWhiteSpace() {
        return this.event == 6;
    }

    public int nextTag() throws XMLStreamException {
        do {
            switch (this.next()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new XMLStreamException("Unexpected event type: " + this.event);
                }
            }
        } while (this.event != 1 && this.event != 2);
        return this.event;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.event != n) {
            throw new XMLStreamException("Current event type is " + this.event);
        }
        if (this.event == 1 || this.event == 2) {
            String string3 = this.getLocalName();
            if (!string3.equals(string2)) {
                throw new XMLStreamException("Current local-name is " + string3);
            }
            String string4 = this.getNamespaceURI();
            if (string4 == null && string != null || string4 != null && !string4.equals(string)) {
                throw new XMLStreamException("Current namespace URI is " + string4);
            }
        }
    }

    public boolean standaloneSet() {
        return this.xmlStandalone != null;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.event == 8) {
            return false;
        }
        if (!this.lookahead) {
            this.next();
            this.lookahead = true;
        }
        return this.event != -1;
    }

    public int next() throws XMLStreamException {
        if (this.lookahead) {
            this.lookahead = false;
            return this.event;
        }
        if (this.event == 2) {
            if (this.namespaceAware && !this.namespaces.isEmpty()) {
                this.namespaces.removeFirst();
            }
            if (this.baseAware && !this.bases.isEmpty()) {
                this.bases.removeFirst();
            }
        }
        if (!this.startEntityStack.isEmpty()) {
            String string = (String)this.startEntityStack.removeFirst();
            this.buf.setLength(0);
            this.buf.append(string);
            this.event = 50;
            if (this.extendedEventTypes) {
                return this.event;
            }
            return this.next();
        }
        if (!this.endEntityStack.isEmpty()) {
            String string = (String)this.endEntityStack.removeFirst();
            this.buf.setLength(0);
            this.buf.append(string);
            this.event = 51;
            if (this.extendedEventTypes) {
                return this.event;
            }
            return this.next();
        }
        try {
            if (!this.input.initialized) {
                this.input.init();
            }
            switch (this.state) {
                case 2: {
                    if (this.tryRead(TEST_END_ELEMENT)) {
                        this.readEndElement();
                        if (this.stack.isEmpty()) {
                            this.state = 4;
                        }
                        this.event = 2;
                        break;
                    }
                    if (this.tryRead(TEST_COMMENT)) {
                        this.readComment(false);
                        this.event = 5;
                        break;
                    }
                    if (this.tryRead(TEST_PI)) {
                        this.readPI(false);
                        this.event = 3;
                        break;
                    }
                    if (this.tryRead(TEST_CDATA)) {
                        this.readCDSect();
                        this.event = 12;
                        break;
                    }
                    if (this.tryRead(TEST_START_ELEMENT)) {
                        this.state = this.readStartElement();
                        this.event = 1;
                        break;
                    }
                    this.mark(8);
                    int n = this.readCh();
                    if (n == 38) {
                        n = this.readCh();
                        if (n == 35) {
                            this.reset();
                            this.event = this.readCharData(null);
                            break;
                        }
                        this.reset();
                        this.readCh();
                        this.readReference();
                        String string = this.buf.toString();
                        String string2 = (String)PREDEFINED_ENTITIES.get(string);
                        if (string2 != null) {
                            this.event = this.readCharData(string2);
                            break;
                        }
                        if (this.replaceERefs && !this.isUnparsedEntity(string)) {
                            Object object;
                            boolean bl = false;
                            if (this.doctype != null && (object = this.doctype.getEntity(string)) instanceof ExternalIds) {
                                bl = true;
                            }
                            this.expandEntity(string, false, bl);
                            this.event = this.next();
                            break;
                        }
                        this.event = 9;
                        break;
                    }
                    this.reset();
                    this.event = this.readCharData(null);
                    if (!this.validating || this.doctype == null) break;
                    this.validatePCData(this.buf.toString());
                    break;
                }
                case 3: {
                    String string = (String)this.stack.removeLast();
                    this.buf.setLength(0);
                    this.buf.append(string);
                    this.state = this.stack.isEmpty() ? 4 : 2;
                    this.event = 2;
                    if (!this.validating || this.doctype == null) break;
                    this.endElementValidationHook();
                    break;
                }
                case 0: {
                    if (this.tryRead(TEST_XML_DECL)) {
                        this.readXMLDecl();
                    }
                    this.input.finalizeEncoding();
                    this.event = 7;
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.skipWhitespace();
                    if (this.doctype == null && this.tryRead(TEST_DOCTYPE_DECL)) {
                        this.readDoctypeDecl();
                        this.event = 11;
                        break;
                    }
                    if (this.tryRead(TEST_COMMENT)) {
                        this.readComment(false);
                        this.event = 5;
                        break;
                    }
                    if (this.tryRead(TEST_PI)) {
                        this.readPI(false);
                        this.event = 3;
                        break;
                    }
                    if (this.tryRead(TEST_START_ELEMENT)) {
                        this.state = this.readStartElement();
                        this.event = 1;
                        break;
                    }
                    int n = this.readCh();
                    this.error("no root element: U+" + Integer.toHexString(n));
                    break;
                }
                case 4: {
                    this.skipWhitespace();
                    if (this.tryRead(TEST_COMMENT)) {
                        this.readComment(false);
                        this.event = 5;
                        break;
                    }
                    if (this.tryRead(TEST_PI)) {
                        this.readPI(false);
                        this.event = 3;
                        break;
                    }
                    if (this.event == 8) {
                        throw new NoSuchElementException();
                    }
                    int n = this.readCh();
                    if (n != -1) {
                        this.error("Only comments and PIs may appear after the root element");
                    }
                    this.event = 8;
                    break;
                }
                default: {
                    this.event = -1;
                }
            }
            return this.event;
        }
        catch (IOException iOException) {
            XMLStreamException xMLStreamException = new XMLStreamException();
            xMLStreamException.initCause(iOException);
            throw xMLStreamException;
        }
    }

    String getCurrentElement() {
        return (String)this.stack.getLast();
    }

    private void mark(int n) throws IOException {
        this.input.mark(n);
    }

    private void reset() throws IOException {
        this.input.reset();
    }

    private int read() throws IOException {
        return this.input.read();
    }

    private int read(int[] nArray, int n, int n2) throws IOException {
        return this.input.read(nArray, n, n2);
    }

    private int readCh() throws IOException, XMLStreamException {
        int n = this.read();
        if (this.expandPE && n == 37) {
            if (this.peIsError) {
                this.error("PE reference within decl in internal subset.");
            }
            this.expandPEReference();
            return this.readCh();
        }
        return n;
    }

    private void require(char c) throws IOException, XMLStreamException {
        this.mark(1);
        int n = this.readCh();
        if (c != n) {
            this.reset();
            this.error("required character (got U+" + Integer.toHexString(n) + ")", new Character(c));
        }
    }

    private void require(String string) throws IOException, XMLStreamException {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        this.mark(n2);
        int n3 = 0;
        do {
            if ((n = this.read(this.tmpBuf, n3, n2 - n3)) != -1) continue;
            this.reset();
            this.error("EOF before required string", string);
        } while ((n3 += n) < n2);
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] == this.tmpBuf[n]) continue;
            this.reset();
            this.error("required string", string);
        }
    }

    private boolean tryRead(char c) throws IOException, XMLStreamException {
        this.mark(1);
        int n = this.readCh();
        if (c != n) {
            this.reset();
            return false;
        }
        return true;
    }

    private boolean tryRead(String string) throws IOException {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        this.mark(n2);
        int n3 = 0;
        int n4 = this.read(this.tmpBuf, 0, n2);
        if (n4 == -1) {
            this.reset();
            return false;
        }
        n3 += n4;
        for (n = 0; n < n3; ++n) {
            if (cArray[n] == this.tmpBuf[n]) continue;
            this.reset();
            return false;
        }
        while (n3 < n2) {
            n = this.read();
            if (n == -1) {
                this.reset();
                return false;
            }
            this.tmpBuf[n3] = (char)n;
            if (cArray[n3] != this.tmpBuf[n3]) {
                this.reset();
                return false;
            }
            ++n3;
        }
        return true;
    }

    private void readUntil(String string) throws IOException, XMLStreamException {
        int n = this.input.line;
        try {
            while (!this.tryRead(string)) {
                int n2 = this.readCh();
                if (n2 == -1) {
                    throw new EOFException();
                }
                if (this.input.xml11) {
                    if (!XMLParser.isXML11Char(n2) || XMLParser.isXML11RestrictedChar(n2)) {
                        this.error("illegal XML 1.1 character", "U+" + Integer.toHexString(n2));
                    }
                } else if (!XMLParser.isChar(n2)) {
                    this.error("illegal XML character", "U+" + Integer.toHexString(n2));
                }
                this.buf.append(Character.toChars(n2));
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + n + ')', string);
        }
    }

    private boolean tryWhitespace() throws IOException, XMLStreamException {
        boolean bl;
        boolean bl2 = false;
        do {
            this.mark(1);
            int n = this.readCh();
            while (n == -1 && this.inputStack.size() > 1) {
                this.popInput();
                n = this.readCh();
            }
            boolean bl3 = bl = n == 32 || n == 9 || n == 10 || n == 13;
            if (!bl) continue;
            bl2 = true;
        } while (bl);
        this.reset();
        return bl2;
    }

    private void skipWhitespace() throws IOException, XMLStreamException {
        boolean bl;
        do {
            this.mark(1);
            int n = this.readCh();
            while (n == -1 && this.inputStack.size() > 1) {
                this.popInput();
                n = this.readCh();
            }
            boolean bl2 = bl = n == 32 || n == 9 || n == 10 || n == 13;
        } while (bl);
        this.reset();
    }

    private void requireWhitespace() throws IOException, XMLStreamException {
        if (!this.tryWhitespace()) {
            this.error("whitespace required");
        }
    }

    String getXMLBase() {
        if (this.baseAware) {
            Iterator iterator = this.bases.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string == null) continue;
                return string;
            }
        }
        return this.input.systemId;
    }

    private void pushInput(String string, String string2, boolean bl, boolean bl2) throws IOException, XMLStreamException {
        if (string != null && !"".equals(string)) {
            Iterator iterator = this.inputStack.iterator();
            while (iterator.hasNext()) {
                Input input = (Input)iterator.next();
                if (!string.equals(input.name)) continue;
                this.error("entities may not be self-recursive", string);
            }
        } else {
            bl = false;
        }
        this.pushInput(new Input(null, new StringReader(string2), this.input.publicId, this.input.systemId, string, this.input.inputEncoding, bl, bl2));
    }

    private void pushInput(String string, ExternalIds externalIds, boolean bl, boolean bl2) throws IOException, XMLStreamException {
        Object object;
        if (!this.externalEntities) {
            return;
        }
        String string2 = XMLParser.absolutize(this.input.systemId, externalIds.systemId);
        Object object2 = this.inputStack.iterator();
        while (object2.hasNext()) {
            object = (Input)object2.next();
            if (string2.equals(((Input)object).systemId)) {
                this.error("entities may not be self-recursive", string2);
            }
            if (string == null || "".equals(string) || !string.equals(((Input)object).name)) continue;
            this.error("entities may not be self-recursive", string);
        }
        if (string == null || "".equals(string)) {
            bl = false;
        }
        object2 = null;
        if (this.resolver != null && (object = this.resolver.resolveEntity(externalIds.publicId, string2, this.getXMLBase(), null)) instanceof InputStream) {
            object2 = (InputStream)object;
        }
        if (object2 == null) {
            object2 = XMLParser.resolve(string2);
        }
        if (object2 == null) {
            this.error("unable to resolve external entity", externalIds.systemId != null ? externalIds.systemId : externalIds.publicId);
        }
        this.pushInput(new Input((InputStream)object2, null, externalIds.publicId, string2, string, null, bl, bl2));
        this.input.init();
        if (this.tryRead(TEST_XML_DECL)) {
            this.readTextDecl();
        }
        this.input.finalizeEncoding();
    }

    private void pushInput(Input input) {
        if (input.report) {
            this.startEntityStack.addFirst(input.name);
        }
        this.inputStack.addLast(input);
        if (this.input != null) {
            input.xml11 = this.input.xml11;
        }
        this.input = input;
    }

    public static String absolutize(String string, String string2) throws MalformedURLException {
        int n;
        if (string2 == null) {
            return null;
        }
        int n2 = string2.indexOf(58);
        if (n2 > 1 && XMLParser.isURLScheme(string2.substring(0, n2))) {
            return string2;
        }
        if ("".equals(string = string == null ? "" : ((n = string.lastIndexOf(47)) != -1 ? string.substring(0, n + 1) : ""))) {
            string = System.getProperty("user.dir");
            if (string.charAt(0) == '/') {
                string = string.substring(1);
            }
            if (!(string = "file:///" + string.replace(File.separatorChar, '/')).endsWith("/")) {
                string = string + "/";
            }
        }
        return new URL(new URL(string), string2).toString();
    }

    private static boolean isURLScheme(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '+' || c == '.' || c == '-' || c >= 'A' && (c <= 'Z' || c >= 'a') && c <= 'z') continue;
            return false;
        }
        return true;
    }

    static InputStream resolve(String string) throws IOException {
        try {
            return new URL(string).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("error resolving " + string);
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    private void popInput() {
        Input input = (Input)this.inputStack.removeLast();
        if (input.report) {
            this.endEntityStack.addFirst(input.name);
        }
        this.input = (Input)this.inputStack.getLast();
    }

    private void readTextDecl() throws IOException, XMLStreamException {
        String string;
        int n = 112;
        this.requireWhitespace();
        if (this.tryRead("version")) {
            this.readEq();
            string = this.readLiteral(n, false);
            if ("1.0".equals(string)) {
                this.input.xml11 = false;
            } else if ("1.1".equals(string)) {
                Input input = (Input)this.inputStack.getFirst();
                if (!input.xml11) {
                    this.error("external entity specifies later version number");
                }
                this.input.xml11 = true;
            } else {
                throw new XMLStreamException("illegal XML version: " + string);
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.readEq();
        string = this.readLiteral(n, false);
        this.skipWhitespace();
        this.require(TEST_END_PI);
        this.input.setInputEncoding(string);
    }

    private void readXMLDecl() throws IOException, XMLStreamException {
        int n = 112;
        this.requireWhitespace();
        this.require("version");
        this.readEq();
        this.xmlVersion = this.readLiteral(n, false);
        if ("1.0".equals(this.xmlVersion)) {
            this.input.xml11 = false;
        } else if ("1.1".equals(this.xmlVersion)) {
            this.input.xml11 = true;
        } else {
            throw new XMLStreamException("illegal XML version: " + this.xmlVersion);
        }
        boolean bl = this.tryWhitespace();
        if (this.tryRead("encoding")) {
            if (!bl) {
                this.error("whitespace required before 'encoding='");
            }
            this.readEq();
            this.xmlEncoding = this.readLiteral(n, false);
            bl = this.tryWhitespace();
        }
        if (this.tryRead("standalone")) {
            if (!bl) {
                this.error("whitespace required before 'standalone='");
            }
            this.readEq();
            String string = this.readLiteral(n, false);
            if ("yes".equals(string)) {
                this.xmlStandalone = Boolean.TRUE;
            } else if ("no".equals(string)) {
                this.xmlStandalone = Boolean.FALSE;
            } else {
                this.error("standalone flag must be 'yes' or 'no'", string);
            }
        }
        this.skipWhitespace();
        this.require(TEST_END_PI);
        if (this.xmlEncoding != null) {
            this.input.setInputEncoding(this.xmlEncoding);
        }
    }

    private void readDoctypeDecl() throws IOException, XMLStreamException {
        if (!this.supportDTD) {
            this.error("parser was configured not to support DTDs");
        }
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        this.skipWhitespace();
        ExternalIds externalIds = this.readExternalIds(false, true);
        this.doctype = new Doctype(this, string, externalIds.publicId, externalIds.systemId);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                if (this.tryRead(']')) break;
                this.readMarkupdecl(false);
            }
        }
        this.skipWhitespace();
        this.require('>');
        if (externalIds.systemId != null && this.externalEntities) {
            this.pushInput("", TEST_KET, false, false);
            this.pushInput("[dtd]", externalIds, true, true);
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.mark(1);
                int n = this.readCh();
                if (n == 62) break;
                if (n == -1) {
                    this.popInput();
                    continue;
                }
                this.reset();
                this.expandPE = true;
                this.readMarkupdecl(true);
                this.expandPE = true;
            }
            if (this.inputStack.size() != 2) {
                this.error("external subset has unmatched '>'");
            }
            this.popInput();
        }
        this.checkDoctype();
        if (this.validating) {
            this.validateDoctype();
        }
        this.buf.setLength(0);
        this.buf.append(string);
    }

    private void checkDoctype() throws XMLStreamException {
    }

    private void readMarkupdecl(boolean bl) throws IOException, XMLStreamException {
        boolean bl2 = this.expandPE;
        this.mark(1);
        this.require('<');
        this.reset();
        this.expandPE = false;
        if (this.tryRead(TEST_ELEMENT_DECL)) {
            this.expandPE = bl2;
            this.readElementDecl();
        } else if (this.tryRead(TEST_ATTLIST_DECL)) {
            this.expandPE = bl2;
            this.readAttlistDecl();
        } else if (this.tryRead(TEST_ENTITY_DECL)) {
            this.expandPE = bl2;
            this.readEntityDecl(bl);
        } else if (this.tryRead(TEST_NOTATION_DECL)) {
            this.expandPE = bl2;
            this.readNotationDecl(bl);
        } else if (this.tryRead(TEST_PI)) {
            this.readPI(true);
            this.expandPE = bl2;
        } else if (this.tryRead(TEST_COMMENT)) {
            this.readComment(true);
            this.expandPE = bl2;
        } else if (this.tryRead("<![")) {
            this.expandPE = bl2;
            if (this.inputStack.size() < 2) {
                this.error("conditional sections illegal in internal subset");
            }
            this.skipWhitespace();
            if (this.tryRead("INCLUDE")) {
                this.skipWhitespace();
                this.require('[');
                this.skipWhitespace();
                while (!this.tryRead(TEST_END_CDATA)) {
                    this.readMarkupdecl(bl);
                    this.skipWhitespace();
                }
            } else if (this.tryRead("IGNORE")) {
                this.skipWhitespace();
                this.require('[');
                this.expandPE = false;
                int n = 1;
                block6: while (n > 0) {
                    int n2 = this.readCh();
                    switch (n2) {
                        case 60: {
                            if (!this.tryRead("![")) continue block6;
                            ++n;
                            break;
                        }
                        case 93: {
                            if (!this.tryRead("]>")) continue block6;
                            --n;
                            break;
                        }
                        case -1: {
                            throw new EOFException();
                        }
                    }
                }
                this.expandPE = bl2;
            } else {
                this.error("conditional section must begin with INCLUDE or IGNORE");
            }
        } else {
            this.error("expected markup declaration");
        }
    }

    private void readElementDecl() throws IOException, XMLStreamException {
        this.requireWhitespace();
        boolean bl = this.expandPE;
        this.expandPE = this.inputStack.size() > 1;
        String string = this.readNmtoken(true);
        this.expandPE = bl;
        this.requireWhitespace();
        this.readContentspec(string);
        this.skipWhitespace();
        this.require('>');
    }

    private void readContentspec(String string) throws IOException, XMLStreamException {
        if (this.tryRead("EMPTY")) {
            this.doctype.addElementDecl(string, "EMPTY", new EmptyContentModel(this));
        } else if (this.tryRead("ANY")) {
            this.doctype.addElementDecl(string, "ANY", new AnyContentModel(this));
        } else {
            ContentModel contentModel;
            StringBuffer stringBuffer = new StringBuffer();
            this.require('(');
            stringBuffer.append('(');
            this.skipWhitespace();
            if (this.tryRead("#PCDATA")) {
                stringBuffer.append("#PCDATA");
                MixedContentModel mixedContentModel = new MixedContentModel(this);
                contentModel = mixedContentModel;
                this.skipWhitespace();
                if (this.tryRead(')')) {
                    stringBuffer.append(")");
                    if (this.tryRead('*')) {
                        mixedContentModel.min = 0;
                        mixedContentModel.max = -1;
                    }
                } else {
                    while (!this.tryRead(")")) {
                        this.require('|');
                        stringBuffer.append('|');
                        this.skipWhitespace();
                        String string2 = this.readNmtoken(true);
                        stringBuffer.append(string2);
                        mixedContentModel.addName(string2);
                        this.skipWhitespace();
                    }
                    this.require('*');
                    stringBuffer.append(")*");
                    mixedContentModel.min = 0;
                    mixedContentModel.max = -1;
                }
            } else {
                contentModel = this.readElements(stringBuffer);
            }
            this.doctype.addElementDecl(string, stringBuffer.toString(), contentModel);
        }
    }

    private ElementContentModel readElements(StringBuffer stringBuffer) throws IOException, XMLStreamException {
        int n;
        ElementContentModel elementContentModel = new ElementContentModel(this);
        this.skipWhitespace();
        elementContentModel.addContentParticle(this.readContentParticle(stringBuffer));
        this.skipWhitespace();
        int n2 = this.readCh();
        switch (n2) {
            case 41: {
                stringBuffer.append(')');
                this.mark(1);
                n2 = this.readCh();
                switch (n2) {
                    case 63: {
                        stringBuffer.append('?');
                        elementContentModel.min = 0;
                        elementContentModel.max = 1;
                        break;
                    }
                    case 42: {
                        stringBuffer.append('*');
                        elementContentModel.min = 0;
                        elementContentModel.max = -1;
                        break;
                    }
                    case 43: {
                        stringBuffer.append('+');
                        elementContentModel.min = 1;
                        elementContentModel.max = -1;
                        break;
                    }
                    default: {
                        this.reset();
                    }
                }
                return elementContentModel;
            }
            case 124: {
                elementContentModel.or = true;
            }
            case 44: {
                n = n2;
                stringBuffer.append(Character.toChars(n2));
                break;
            }
            default: {
                this.error("bad separator in content model", "U+" + Integer.toHexString(n2));
                return elementContentModel;
            }
        }
        while (true) {
            this.skipWhitespace();
            elementContentModel.addContentParticle(this.readContentParticle(stringBuffer));
            this.skipWhitespace();
            n2 = this.readCh();
            if (n2 == 41) break;
            if (n2 != n) {
                this.error("bad separator in content model", "U+" + Integer.toHexString(n2));
                return elementContentModel;
            }
            stringBuffer.append(n2);
        }
        stringBuffer.append(')');
        this.mark(1);
        n2 = this.readCh();
        switch (n2) {
            case 63: {
                stringBuffer.append('?');
                elementContentModel.min = 0;
                elementContentModel.max = 1;
                break;
            }
            case 42: {
                stringBuffer.append('*');
                elementContentModel.min = 0;
                elementContentModel.max = -1;
                break;
            }
            case 43: {
                stringBuffer.append('+');
                elementContentModel.min = 1;
                elementContentModel.max = -1;
                break;
            }
            default: {
                this.reset();
            }
        }
        return elementContentModel;
    }

    private ContentParticle readContentParticle(StringBuffer stringBuffer) throws IOException, XMLStreamException {
        ContentParticle contentParticle = new ContentParticle(this);
        if (this.tryRead('(')) {
            stringBuffer.append('(');
            contentParticle.content = this.readElements(stringBuffer);
        } else {
            String string = this.readNmtoken(true);
            stringBuffer.append(string);
            contentParticle.content = string;
            this.mark(1);
            int n = this.readCh();
            switch (n) {
                case 63: {
                    stringBuffer.append('?');
                    contentParticle.min = 0;
                    contentParticle.max = 1;
                    break;
                }
                case 42: {
                    stringBuffer.append('*');
                    contentParticle.min = 0;
                    contentParticle.max = -1;
                    break;
                }
                case 43: {
                    stringBuffer.append('+');
                    contentParticle.min = 1;
                    contentParticle.max = -1;
                    break;
                }
                default: {
                    this.reset();
                }
            }
        }
        return contentParticle;
    }

    private void readAttlistDecl() throws IOException, XMLStreamException {
        this.requireWhitespace();
        boolean bl = this.expandPE;
        this.expandPE = this.inputStack.size() > 1;
        String string = this.readNmtoken(true);
        this.expandPE = bl;
        boolean bl2 = this.tryWhitespace();
        while (!this.tryRead('>')) {
            if (!bl2) {
                this.error("whitespace required before attribute definition");
            }
            this.readAttDef(string);
            bl2 = this.tryWhitespace();
        }
    }

    private void readAttDef(String string) throws IOException, XMLStreamException {
        Object object;
        String string2 = this.readNmtoken(true);
        this.requireWhitespace();
        StringBuffer stringBuffer = new StringBuffer();
        HashSet hashSet = new HashSet();
        String string3 = this.readAttType(stringBuffer, hashSet);
        if (this.validating) {
            if ("ID".equals(string3)) {
                object = this.doctype.attlistIterator(string);
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    AttributeDecl attributeDecl = (AttributeDecl)entry.getValue();
                    if (!"ID".equals(attributeDecl.type)) continue;
                    this.error("element types must not have more than one ID attribute");
                }
            } else if ("NOTATION".equals(string3)) {
                object = this.doctype.attlistIterator(string);
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    AttributeDecl attributeDecl = (AttributeDecl)entry.getValue();
                    if (!"NOTATION".equals(attributeDecl.type)) continue;
                    this.error("element types must not have more than one NOTATION attribute");
                }
                object = this.doctype.getElementModel(string);
                if (object != null && ((ContentModel)object).type == 0) {
                    this.error("attributes of type NOTATION must not be declared on an element declared EMPTY");
                }
            }
        }
        object = null;
        if ("ENUMERATION".equals(string3) || "NOTATION".equals(string3)) {
            object = stringBuffer.toString();
        } else {
            hashSet = null;
        }
        this.requireWhitespace();
        this.readDefault(string, string2, string3, (String)object, hashSet);
    }

    private String readAttType(StringBuffer stringBuffer, HashSet hashSet) throws IOException, XMLStreamException {
        if (this.tryRead('(')) {
            this.readEnumeration(false, stringBuffer, hashSet);
            return "ENUMERATION";
        }
        String string = this.readNmtoken(true);
        if ("NOTATION".equals(string)) {
            this.readNotationType(stringBuffer, hashSet);
            return string;
        }
        if ("CDATA".equals(string) || "ID".equals(string) || "IDREF".equals(string) || "IDREFS".equals(string) || "ENTITY".equals(string) || "ENTITIES".equals(string) || "NMTOKEN".equals(string) || "NMTOKENS".equals(string)) {
            return string;
        }
        this.error("illegal attribute type", string);
        return null;
    }

    private void readEnumeration(boolean bl, StringBuffer stringBuffer, HashSet hashSet) throws IOException, XMLStreamException {
        stringBuffer.append('(');
        this.skipWhitespace();
        String string = this.readNmtoken(bl);
        stringBuffer.append(string);
        hashSet.add(string);
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            stringBuffer.append('|');
            this.skipWhitespace();
            string = this.readNmtoken(bl);
            if (this.validating && hashSet.contains(string)) {
                this.error("duplicate token", string);
            }
            stringBuffer.append(string);
            hashSet.add(string);
            this.skipWhitespace();
        }
        stringBuffer.append(')');
    }

    private void readNotationType(StringBuffer stringBuffer, HashSet hashSet) throws IOException, XMLStreamException {
        this.requireWhitespace();
        this.require('(');
        this.readEnumeration(true, stringBuffer, hashSet);
    }

    private void readDefault(String string, String string2, String string3, String string4, HashSet hashSet) throws IOException, XMLStreamException {
        Object object;
        int n = 31;
        int n2 = 8;
        String string5 = null;
        String string6 = null;
        boolean bl = this.expandPE;
        if (!"CDATA".equals(string3)) {
            n2 |= 4;
        }
        this.expandPE = false;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                string6 = "#FIXED";
                n = 34;
                this.requireWhitespace();
                string5 = this.readLiteral(n2, false);
            } else if (this.tryRead("REQUIRED")) {
                string6 = "#REQUIRED";
                n = 33;
            } else if (this.tryRead("IMPLIED")) {
                string6 = "#IMPLIED";
                n = 32;
            } else {
                this.error("illegal keyword for attribute default value");
            }
        } else {
            string5 = this.readLiteral(n2, false);
        }
        this.expandPE = bl;
        if (this.validating) {
            if ("ID".equals(string3)) {
                if (string5 != null && !this.isNmtoken(string5, true)) {
                    this.error("default value must match Name production", string5);
                }
                if (n != 33 && n != 32) {
                    this.error("ID attributes must have a declared default of #IMPLIED or #REQUIRED");
                }
            } else if (string5 != null) {
                if ("IDREF".equals(string3) || "ENTITY".equals(string3)) {
                    if (!this.isNmtoken(string5, true)) {
                        this.error("default value must match Name production", string5);
                    }
                } else if ("IDREFS".equals(string3) || "ENTITIES".equals(string3)) {
                    object = new StringTokenizer(string5);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string7 = ((StringTokenizer)object).nextToken();
                        if (this.isNmtoken(string7, true)) continue;
                        this.error("default value must match Name production", string7);
                    }
                } else if ("NMTOKEN".equals(string3) || "ENUMERATION".equals(string3)) {
                    if (!this.isNmtoken(string5, false)) {
                        this.error("default value must match Nmtoken production", string5);
                    }
                } else if ("NMTOKENS".equals(string3)) {
                    object = new StringTokenizer(string5);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string8 = ((StringTokenizer)object).nextToken();
                        if (this.isNmtoken(string8, false)) continue;
                        this.error("default value must match Nmtoken production", string8);
                    }
                }
            }
        }
        object = new AttributeDecl(this, string3, string5, n, string4, hashSet, this.inputStack.size() != 1);
        this.doctype.addAttributeDecl(string, string2, (AttributeDecl)object);
    }

    private void readEntityDecl(boolean bl) throws IOException, XMLStreamException {
        int n = 0;
        boolean bl2 = false;
        this.expandPE = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            bl2 = true;
            this.requireWhitespace();
        }
        this.expandPE = true;
        String string = this.readNmtoken(true);
        if (string.indexOf(58) != -1) {
            this.error("illegal character ':' in entity name", string);
        }
        if (bl2) {
            string = "%" + string;
        }
        this.requireWhitespace();
        this.mark(1);
        int n2 = this.readCh();
        this.reset();
        if (n2 == 34 || n2 == 39) {
            String string2 = this.readLiteral(n | 0x40, true);
            int n3 = string2.indexOf(38);
            while (n3 != -1) {
                int n4;
                String string3;
                int[] nArray;
                int n5 = string2.indexOf(59, n3);
                if (n5 == -1) {
                    this.error("malformed reference in entity value", string2);
                }
                if ((nArray = UnicodeReader.toCodePointArray(string3 = string2.substring(n3 + 1, n5))).length == 0) {
                    this.error("malformed reference in entity value", string2);
                }
                if (nArray[0] == 35) {
                    int n6;
                    if (nArray.length == 1) {
                        this.error("malformed reference in entity value", string2);
                    }
                    if (nArray[1] == 120) {
                        if (nArray.length == 2) {
                            this.error("malformed reference in entity value", string2);
                        }
                        for (n4 = 2; n4 < nArray.length; ++n4) {
                            n6 = nArray[n4];
                            if (!(n6 < 48 || n6 > 57 && n6 < 65 || n6 > 70 && n6 < 97) && n6 <= 102) continue;
                            this.error("malformed character reference in entity value", string2);
                        }
                    } else {
                        for (n4 = 1; n4 < nArray.length; ++n4) {
                            n6 = nArray[n4];
                            if (n6 >= 48 && n6 <= 57) continue;
                            this.error("malformed character reference in entity value", string2);
                        }
                    }
                } else {
                    if (!XMLParser.isNameStartCharacter(nArray[0], this.input.xml11)) {
                        this.error("malformed reference in entity value", string2);
                    }
                    for (n4 = 1; n4 < nArray.length; ++n4) {
                        if (XMLParser.isNameCharacter(nArray[n4], this.input.xml11)) continue;
                        this.error("malformed reference in entity value", string2);
                    }
                }
                n3 = string2.indexOf(38, n5);
            }
            this.doctype.addEntityDecl(string, string2, bl);
        } else {
            ExternalIds externalIds = this.readExternalIds(false, false);
            boolean bl3 = this.tryWhitespace();
            if (!bl2 && this.tryRead("NDATA")) {
                if (!bl3) {
                    this.error("whitespace required before NDATA");
                }
                this.requireWhitespace();
                externalIds.notationName = this.readNmtoken(true);
            }
            this.doctype.addEntityDecl(string, externalIds, bl);
        }
        this.skipWhitespace();
        this.require('>');
    }

    private void readNotationDecl(boolean bl) throws IOException, XMLStreamException {
        ExternalIds externalIds;
        this.requireWhitespace();
        String string = this.readNmtoken(true);
        if (string.indexOf(58) != -1) {
            this.error("illegal character ':' in notation name", string);
        }
        if (this.validating && (externalIds = this.doctype.getNotation(string)) != null) {
            this.error("duplicate notation name", string);
        }
        this.requireWhitespace();
        externalIds = this.readExternalIds(true, false);
        externalIds.notationName = string;
        this.doctype.addNotationDecl(string, externalIds, bl);
        this.skipWhitespace();
        this.require('>');
    }

    private ExternalIds readExternalIds(boolean bl, boolean bl2) throws IOException, XMLStreamException {
        int n = 112;
        ExternalIds externalIds = new ExternalIds(this);
        if (this.tryRead("PUBLIC")) {
            String string;
            this.requireWhitespace();
            externalIds.publicId = this.readLiteral(0x104 | n, false);
            if (bl) {
                this.skipWhitespace();
                this.mark(1);
                int n2 = this.readCh();
                this.reset();
                if (n2 == 34 || n2 == 39) {
                    string = this.readLiteral(n, false);
                    externalIds.systemId = XMLParser.absolutize(this.input.systemId, string);
                }
            } else {
                this.requireWhitespace();
                string = this.readLiteral(n, false);
                externalIds.systemId = XMLParser.absolutize(this.input.systemId, string);
            }
            for (int i = 0; i < externalIds.publicId.length(); ++i) {
                char c = externalIds.publicId.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || " \r\n0123456789-' ()+,./:=?;!*#@$_%".indexOf(c) != -1) continue;
                this.error("illegal PUBLIC id character", "U+" + Integer.toHexString(c));
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            String string = this.readLiteral(n, false);
            externalIds.systemId = XMLParser.absolutize(this.input.systemId, string);
        } else if (!bl2) {
            this.error("missing SYSTEM or PUBLIC keyword");
        }
        if (externalIds.systemId != null && !bl && externalIds.systemId.indexOf(35) != -1) {
            this.error("SYSTEM id has a URI fragment", externalIds.systemId);
        }
        return externalIds;
    }

    private int readStartElement() throws IOException, XMLStreamException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = this.readNmtoken(true);
        this.attrs.clear();
        if (this.namespaceAware) {
            if (string.charAt(0) == ':' || string.charAt(string.length() - 1) == ':') {
                this.error("not a QName", string);
            }
            this.namespaces.addFirst(new LinkedHashMap());
        }
        boolean bl = this.tryWhitespace();
        this.mark(1);
        int n = this.readCh();
        while (n != 47 && n != 62) {
            this.reset();
            if (!bl) {
                this.error("need whitespace between attributes");
            }
            this.readAttribute(string);
            bl = this.tryWhitespace();
            this.mark(1);
            n = this.readCh();
        }
        if (this.doctype != null) {
            object4 = this.doctype.attlistIterator(string);
            while (object4.hasNext()) {
                Object object5;
                object3 = (Map.Entry)object4.next();
                object2 = (String)object3.getKey();
                object = (AttributeDecl)object3.getValue();
                if (this.validating) {
                    switch (((AttributeDecl)object).valueType) {
                        case 33: {
                            if (((AttributeDecl)object).value != null || this.attributeSpecified((String)object2)) break;
                            this.error("value for " + (String)object2 + " attribute is required");
                            break;
                        }
                        case 34: {
                            object5 = this.attrs.iterator();
                            while (object5.hasNext()) {
                                Attribute attribute = (Attribute)object5.next();
                                if (!((String)object2).equals(attribute.name) || ((AttributeDecl)object).value.equals(attribute.value)) continue;
                                this.error("value for " + (String)object2 + " attribute must be " + ((AttributeDecl)object).value);
                            }
                            break;
                        }
                    }
                }
                if ((!this.namespaceAware || !((String)object2).equals("xmlns") ? (!this.namespaceAware || !((String)object2).startsWith("xmlns:") ? this.attributeSpecified((String)object2) : ((HashMap)(object5 = (LinkedHashMap)this.namespaces.getFirst())).containsKey(((String)object2).substring(6))) : ((HashMap)(object5 = (LinkedHashMap)this.namespaces.getFirst())).containsKey("")) || ((AttributeDecl)object).value == null) continue;
                if (this.validating && ((AttributeDecl)object).external && this.xmlStandalone == Boolean.TRUE) {
                    this.error("standalone must be 'no' if attributes inherit values from externally declared markup declarations");
                }
                object5 = new Attribute(this, (String)object2, ((AttributeDecl)object).type, false, ((AttributeDecl)object).value);
                if (this.namespaceAware) {
                    if (this.addNamespace((Attribute)object5)) continue;
                    this.attrs.add(object5);
                    continue;
                }
                this.attrs.add(object5);
            }
        }
        if (this.baseAware) {
            object4 = this.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
            object3 = this.getXMLBase();
            this.bases.addFirst(XMLParser.absolutize((String)object3, (String)object4));
        }
        if (this.namespaceAware) {
            int n2 = string.indexOf(58);
            if (n2 != -1) {
                object3 = string.substring(0, n2);
                object2 = this.getNamespaceURI((String)object3);
                if (object2 == null) {
                    this.error("unbound element prefix", object3);
                } else if (this.input.xml11 && "".equals(object2)) {
                    this.error("XML 1.1 unbound element prefix", object3);
                }
            }
            object3 = this.attrs.iterator();
            while (object3.hasNext()) {
                object2 = (Attribute)object3.next();
                if (((Attribute)object2).prefix == null || XMLConstants.XMLNS_ATTRIBUTE.equals(((Attribute)object2).prefix)) continue;
                object = this.getNamespaceURI(((Attribute)object2).prefix);
                if (object == null) {
                    this.error("unbound attribute prefix", ((Attribute)object2).prefix);
                    continue;
                }
                if (!this.input.xml11 || !"".equals(object)) continue;
                this.error("XML 1.1 unbound attribute prefix", ((Attribute)object2).prefix);
            }
        }
        if (this.validating && this.doctype != null) {
            this.validateStartElement(string);
            this.currentContentModel = this.doctype.getElementModel(string);
            if (this.currentContentModel == null) {
                this.error("no element declaration", string);
            }
            this.validationStack.add(new LinkedList());
        }
        this.buf.setLength(0);
        this.buf.append(string);
        this.stack.addLast(string);
        switch (n) {
            case 62: {
                return 2;
            }
            case 47: {
                this.require('>');
                return 3;
            }
        }
        return -1;
    }

    private boolean attributeSpecified(String string) {
        Iterator iterator = this.attrs.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!string.equals(attribute.name)) continue;
            return true;
        }
        return false;
    }

    private void readAttribute(String string) throws IOException, XMLStreamException {
        Object object;
        String string2 = this.readNmtoken(true);
        String string3 = this.getAttributeType(string, string2);
        this.readEq();
        int n = 10;
        String string4 = string3 == null || "CDATA".equals(string3) ? this.readLiteral(n, false) : this.readLiteral(n | 4, false);
        Attribute attribute = new Attribute(this, string2, string3, true, string4);
        if (this.namespaceAware) {
            if (string2.charAt(0) == ':' || string2.charAt(string2.length() - 1) == ':') {
                this.error("not a QName", string2);
            } else if (string2.equals("xmlns")) {
                object = (LinkedHashMap)this.namespaces.getFirst();
                if (((HashMap)object).containsKey("")) {
                    this.error("duplicate default namespace");
                }
            } else if (string2.startsWith("xmlns:")) {
                object = (LinkedHashMap)this.namespaces.getFirst();
                if (((HashMap)object).containsKey(string2.substring(6))) {
                    this.error("duplicate namespace", string2.substring(6));
                }
            } else if (this.attrs.contains(attribute)) {
                this.error("duplicate attribute", string2);
            }
        } else if (this.attrs.contains(attribute)) {
            this.error("duplicate attribute", string2);
        }
        if (this.validating && this.doctype != null) {
            object = this.doctype.getAttributeDecl(string, string2);
            if (object == null) {
                this.error("attribute must be declared", string2);
            }
            if ("ENUMERATION".equals(((AttributeDecl)object).type)) {
                if (!((AttributeDecl)object).values.contains(string4)) {
                    this.error("value does not match enumeration " + ((AttributeDecl)object).enumeration, string4);
                }
            } else if ("ID".equals(((AttributeDecl)object).type)) {
                if (!this.isNmtoken(string4, true)) {
                    this.error("ID values must match the Name production");
                }
                if (this.ids.contains(string4)) {
                    this.error("Duplicate ID", string4);
                }
                this.ids.add(string4);
            } else if ("IDREF".equals(((AttributeDecl)object).type) || "IDREFS".equals(((AttributeDecl)object).type)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (!this.isNmtoken(string5, true)) {
                        this.error("IDREF values must match the Name production");
                    }
                    this.idrefs.add(string5);
                }
            } else if ("NMTOKEN".equals(((AttributeDecl)object).type) || "NMTOKENS".equals(((AttributeDecl)object).type)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (this.isNmtoken(string6, false)) continue;
                    this.error("NMTOKEN values must match the Nmtoken production");
                }
            } else if ("ENTITY".equals(((AttributeDecl)object).type)) {
                Object object2;
                if (!this.isNmtoken(string4, true)) {
                    this.error("ENTITY values must match the Name production");
                }
                if ((object2 = this.doctype.getEntity(string4)) == null || !(object2 instanceof ExternalIds) || ((ExternalIds)object2).notationName == null) {
                    this.error("ENTITY values must match the name of an unparsed entity declared in the DTD");
                }
            } else if ("NOTATION".equals(((AttributeDecl)object).type)) {
                ExternalIds externalIds;
                if (!((AttributeDecl)object).values.contains(string4)) {
                    this.error("NOTATION values must match a declared notation name", string4);
                }
                if ((externalIds = this.doctype.getNotation(string4)) == null) {
                    this.error("NOTATION values must match the name of a notation declared in the DTD", string4);
                }
            }
        }
        if (this.namespaceAware) {
            if (!this.addNamespace(attribute)) {
                this.attrs.add(attribute);
            }
        } else {
            this.attrs.add(attribute);
        }
    }

    private boolean addNamespace(Attribute attribute) throws XMLStreamException {
        if ("xmlns".equals(attribute.name)) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.namespaces.getFirst();
            if (linkedHashMap.get("") != null) {
                this.error("Duplicate default namespace declaration");
            }
            if (XMLConstants.XML_NS_URI.equals(attribute.value)) {
                this.error("can't bind XML namespace");
            }
            linkedHashMap.put("", attribute.value);
            return true;
        }
        if ("xmlns".equals(attribute.prefix)) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.namespaces.getFirst();
            if (linkedHashMap.get(attribute.localName) != null) {
                this.error("Duplicate namespace declaration for prefix", attribute.localName);
            }
            if (XMLConstants.XML_NS_PREFIX.equals(attribute.localName)) {
                if (!XMLConstants.XML_NS_URI.equals(attribute.value)) {
                    this.error("can't redeclare xml prefix");
                } else {
                    return false;
                }
            }
            if (XMLConstants.XML_NS_URI.equals(attribute.value)) {
                this.error("can't bind non-xml prefix to XML namespace");
            }
            if (XMLConstants.XMLNS_ATTRIBUTE.equals(attribute.localName)) {
                this.error("can't redeclare xmlns prefix");
            }
            if (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(attribute.value)) {
                this.error("can't bind non-xmlns prefix to XML Namespace namespace");
            }
            if ("".equals(attribute.value) && !this.input.xml11) {
                this.error("illegal use of 1.1-style prefix unbinding in 1.0 document");
            }
            linkedHashMap.put(attribute.localName, attribute.value);
            return true;
        }
        return false;
    }

    private void readEndElement() throws IOException, XMLStreamException {
        String string = (String)this.stack.removeLast();
        this.require(string);
        this.skipWhitespace();
        this.require('>');
        this.buf.setLength(0);
        this.buf.append(string);
        if (this.validating && this.doctype != null) {
            this.endElementValidationHook();
        }
    }

    private void endElementValidationHook() throws XMLStreamException {
        this.validateEndElement();
        this.validationStack.removeLast();
        if (this.stack.isEmpty()) {
            this.currentContentModel = null;
        } else {
            String string = (String)this.stack.getLast();
            this.currentContentModel = this.doctype.getElementModel(string);
        }
    }

    private void readComment(boolean bl) throws IOException, XMLStreamException {
        boolean bl2 = this.expandPE;
        this.expandPE = false;
        this.buf.setLength(0);
        this.readUntil(TEST_END_COMMENT);
        this.require('>');
        this.expandPE = bl2;
        if (bl) {
            this.doctype.addComment(this.buf.toString());
        }
    }

    private void readPI(boolean bl) throws IOException, XMLStreamException {
        boolean bl2 = this.expandPE;
        this.expandPE = false;
        this.piTarget = this.readNmtoken(true);
        if (this.piTarget.indexOf(58) != -1) {
            this.error("illegal character in PI target", new Character(':'));
        }
        if ("xml".equalsIgnoreCase(this.piTarget)) {
            this.error("illegal PI target", this.piTarget);
        }
        if (this.tryRead(TEST_END_PI)) {
            this.piData = null;
        } else {
            if (!this.tryWhitespace()) {
                this.error("whitespace required between PI target and data");
            }
            this.buf.setLength(0);
            this.readUntil(TEST_END_PI);
            this.piData = this.buf.toString();
        }
        this.expandPE = bl2;
        if (bl) {
            this.doctype.addPI(this.piTarget, this.piData);
        }
    }

    private void readReference() throws IOException, XMLStreamException {
        this.buf.setLength(0);
        String string = this.readNmtoken(true);
        this.require(';');
        this.buf.setLength(0);
        this.buf.append(string);
    }

    private void readCDSect() throws IOException, XMLStreamException {
        this.buf.setLength(0);
        this.readUntil(TEST_END_CDATA);
    }

    private int readCharData(String string) throws IOException, XMLStreamException {
        boolean bl = true;
        this.buf.setLength(0);
        if (string != null) {
            this.buf.append(string);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl2) {
            this.mark(this.tmpBuf.length);
            int n = this.read(this.tmpBuf, 0, this.tmpBuf.length);
            if (n == -1) {
                if (this.inputStack.size() > 1) {
                    this.popInput();
                    bl2 = true;
                } else {
                    throw new EOFException();
                }
            }
            block10: for (int i = 0; i < n && !bl2; ++i) {
                int n2 = this.tmpBuf[i];
                switch (n2) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.buf.append(Character.toChars(n2));
                        continue block10;
                    }
                    case 38: {
                        int n3;
                        Object object;
                        this.reset();
                        this.read(this.tmpBuf, 0, i);
                        this.mark(3);
                        n2 = this.readCh();
                        n2 = this.readCh();
                        if (n2 == 35) {
                            boolean bl4;
                            this.mark(1);
                            n2 = this.readCh();
                            boolean bl5 = bl4 = n2 == 120;
                            if (!bl4) {
                                this.reset();
                            }
                            object = this.readCharacterRef(bl4 ? 16 : 10);
                            this.buf.append((char[])object, 0, ((Object)object).length);
                            block11: for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                                switch (object[n3]) {
                                    case 9: 
                                    case 10: 
                                    case 13: 
                                    case 32: {
                                        continue block11;
                                    }
                                    default: {
                                        bl = false;
                                    }
                                }
                            }
                        } else {
                            this.reset();
                            n2 = this.readCh();
                            String string2 = this.readNmtoken(true);
                            this.require(';');
                            object = (String)PREDEFINED_ENTITIES.get(string2);
                            if (object != null) {
                                this.buf.append((String)object);
                            } else {
                                this.pushInput("", "&" + string2 + ";", false, false);
                                bl2 = true;
                                continue block10;
                            }
                        }
                        i = -1;
                        this.mark(this.tmpBuf.length);
                        n = this.read(this.tmpBuf, 0, this.tmpBuf.length);
                        if (n == -1) {
                            if (this.inputStack.size() > 1) {
                                this.popInput();
                                bl2 = true;
                            } else {
                                throw new EOFException();
                            }
                        }
                        bl3 = true;
                        continue block10;
                    }
                    case 62: {
                        int n4 = this.buf.length();
                        if (n4 > 1 && this.buf.charAt(n4 - 1) == ']' && this.buf.charAt(n4 - 2) == ']') {
                            this.error("Character data may not contain unescaped ']]>'");
                        }
                        this.buf.append(Character.toChars(n2));
                        continue block10;
                    }
                    case 60: {
                        int n5;
                        this.reset();
                        int n3 = 0;
                        int n6 = i;
                        do {
                            n5 = this.read(this.tmpBuf, 0, n6);
                            n6 -= n5;
                        } while ((n3 += n5) < i);
                        i = n;
                        if (this.coalescing && this.tryRead(TEST_CDATA)) {
                            this.readUntil(TEST_END_CDATA);
                            continue block10;
                        }
                        bl2 = true;
                        continue block10;
                    }
                    default: {
                        if (this.input.xml11) {
                            if (!XMLParser.isXML11Char(n2) || XMLParser.isXML11RestrictedChar(n2)) {
                                this.error("illegal XML 1.1 character", "U+" + Integer.toHexString(n2));
                            }
                        } else if (!XMLParser.isChar(n2)) {
                            this.error("illegal XML character", "U+" + Integer.toHexString(n2));
                        }
                        bl = false;
                        this.buf.append(Character.toChars(n2));
                    }
                }
            }
            if (this.buf.length() < 0x200000) continue;
            bl2 = true;
        }
        if (bl3) {
            this.normalizeCRLF(this.buf);
        }
        if (bl) {
            return 6;
        }
        return 4;
    }

    private void expandEntity(String string, boolean bl, boolean bl2) throws IOException, XMLStreamException {
        Object object;
        if (this.doctype != null && (object = this.doctype.getEntity(string)) != null) {
            Object object2;
            if (this.xmlStandalone == Boolean.TRUE) {
                if (this.doctype.isEntityExternal(string)) {
                    this.error("reference to external entity in standalone document");
                } else if (object instanceof ExternalIds) {
                    object2 = (ExternalIds)object;
                    if (((ExternalIds)object2).notationName != null && this.doctype.isNotationExternal(((ExternalIds)object2).notationName)) {
                        this.error("reference to external notation in standalone document");
                    }
                }
            }
            if (object instanceof String) {
                object2 = (String)object;
                if (bl && ((String)object2).indexOf(60) != -1) {
                    this.error("< in attribute value");
                }
                this.pushInput(string, (String)object2, bl ^ true, bl2);
            } else if (bl) {
                this.error("reference to external entity in attribute value", string);
            } else {
                this.pushInput(string, (ExternalIds)object, bl ^ true, bl2);
            }
            return;
        }
        this.error("reference to undeclared entity", string);
    }

    private boolean isUnparsedEntity(String string) {
        Object object;
        if (this.doctype != null && (object = this.doctype.getEntity(string)) != null && object instanceof ExternalIds) {
            return ((ExternalIds)object).notationName != null;
        }
        return false;
    }

    private void readEq() throws IOException, XMLStreamException {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    private int literalReadCh(boolean bl) throws IOException, XMLStreamException {
        int n;
        int n2 = n = bl ? this.readCh() : this.read();
        while (n == -1) {
            if (this.inputStack.size() > 1) {
                this.inputStack.removeLast();
                this.input = (Input)this.inputStack.getLast();
                n = bl ? this.readCh() : this.read();
                continue;
            }
            throw new EOFException();
        }
        return n;
    }

    private String readLiteral(int n, boolean bl) throws IOException, XMLStreamException {
        int n2;
        boolean bl2 = this.expandPE;
        int n3 = this.readCh();
        if (n3 != 39 && n3 != 34) {
            this.error("expected '\"' or \"'\"", "U+" + Integer.toHexString(n3));
        }
        this.literalBuf.setLength(0);
        if ((n & 0x10) != 0) {
            this.expandPE = false;
        }
        boolean bl3 = false;
        int n4 = this.inputStack.size();
        block7: while ((n2 = this.literalReadCh(bl)) != n3 || n4 != this.inputStack.size()) {
            switch (n2) {
                case 10: 
                case 13: {
                    if ((n & 0x108) == 0) break;
                    n2 = 32;
                    break;
                }
                case 9: {
                    if ((n & 8) == 0) break;
                    n2 = 32;
                    break;
                }
                case 38: {
                    Object object;
                    this.mark(2);
                    n2 = this.readCh();
                    if (n2 == 35) {
                        boolean bl4;
                        if ((n & 0x20) != 0) {
                            this.reset();
                            n2 = 38;
                            break;
                        }
                        this.mark(1);
                        n2 = this.readCh();
                        boolean bl5 = bl4 = n2 == 120;
                        if (!bl4) {
                            this.reset();
                        }
                        object = this.readCharacterRef(bl4 ? 16 : 10);
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            this.literalBuf.append((char)object[i]);
                        }
                        bl3 = true;
                        continue block7;
                    }
                    if ((n & 0x40) != 0) {
                        this.reset();
                        n2 = 38;
                        break;
                    }
                    this.reset();
                    String string = this.readNmtoken(true);
                    this.require(';');
                    object = (String)PREDEFINED_ENTITIES.get(string);
                    if (object != null) {
                        this.literalBuf.append((String)object);
                    } else {
                        this.expandEntity(string, (n & 8) != 0, true);
                    }
                    bl3 = true;
                    continue block7;
                }
                case 60: {
                    if ((n & 8) == 0) break;
                    this.error("attribute values may not contain '<'");
                    break;
                }
                case -1: {
                    if (this.inputStack.size() > 1) {
                        this.popInput();
                        continue block7;
                    }
                    throw new EOFException();
                }
                default: {
                    if (n2 >= 32 && n2 <= 65533 && (n2 < 55296 || n2 >= 56320) && (!this.input.xml11 || n2 < 127 || n2 > 159 || n2 == 133)) break;
                    this.error("illegal character", "U+" + Integer.toHexString(n2));
                }
            }
            this.literalBuf.append(Character.toChars(n2));
        }
        this.expandPE = bl2;
        if (bl3) {
            this.normalizeCRLF(this.literalBuf);
        }
        if ((n & 4) > 0) {
            this.literalBuf = this.normalize(this.literalBuf);
        }
        return this.literalBuf.toString();
    }

    private StringBuffer normalize(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = stringBuffer.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == ' ') {
                n2 = n2 == 0 ? 0 : 1;
                continue;
            }
            if (n2 == 1) {
                stringBuffer2.append(' ');
            }
            stringBuffer2.append(c);
            n2 = 2;
        }
        return stringBuffer2;
    }

    private void normalizeCRLF(StringBuffer stringBuffer) {
        int n = stringBuffer.length() - 1;
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c != '\r' || stringBuffer.charAt(i + 1) != '\n') continue;
            stringBuffer.deleteCharAt(i--);
            --n;
        }
    }

    private void expandPEReference() throws IOException, XMLStreamException {
        String string = this.readNmtoken(true, new StringBuffer());
        this.require(';');
        this.mark(1);
        if (this.doctype != null) {
            String string2 = "%" + string;
            Object object = this.doctype.getEntity(string2);
            if (object != null) {
                if (this.xmlStandalone == Boolean.TRUE && this.doctype.isEntityExternal(string2)) {
                    this.error("reference to external parameter entity in standalone document");
                }
                if (object instanceof String) {
                    this.pushInput(string, (String)object, false, this.input.normalize);
                } else {
                    this.pushInput(string, (ExternalIds)object, false, this.input.normalize);
                }
            } else {
                this.error("reference to undeclared parameter entity", string);
            }
        } else {
            this.error("reference to parameter entity without doctype", string);
        }
    }

    private char[] readCharacterRef(int n) throws IOException, XMLStreamException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.readCh();
        while (n2 != 59 && n2 != -1) {
            stringBuffer.append(Character.toChars(n2));
            n2 = this.readCh();
        }
        try {
            n2 = Integer.parseInt(stringBuffer.toString(), n);
            if (this.input.xml11) {
                if (!XMLParser.isXML11Char(n2)) {
                    this.error("illegal XML 1.1 character reference U+" + Integer.toHexString(n2));
                }
            } else if (n2 < 32 && n2 != 10 && n2 != 9 && n2 != 13 || n2 >= 55296 && n2 <= 57343 || n2 == 65534 || n2 == 65535 || n2 > 0x10FFFF) {
                this.error("illegal XML character reference U+" + Integer.toHexString(n2));
            }
            return Character.toChars(n2);
        }
        catch (NumberFormatException numberFormatException) {
            this.error("illegal characters in character reference", stringBuffer.toString());
            return null;
        }
    }

    private String readNmtoken(boolean bl) throws IOException, XMLStreamException {
        return this.readNmtoken(bl, this.nmtokenBuf);
    }

    private String readNmtoken(boolean bl, StringBuffer stringBuffer) throws IOException, XMLStreamException {
        stringBuffer.setLength(0);
        int n = this.readCh();
        if (bl) {
            if (!XMLParser.isNameStartCharacter(n, this.input.xml11)) {
                this.error("not a name start character", "U+" + Integer.toHexString(n));
            }
        } else if (!XMLParser.isNameCharacter(n, this.input.xml11)) {
            this.error("not a name character", "U+" + Integer.toHexString(n));
        }
        stringBuffer.append(Character.toChars(n));
        while (true) {
            this.mark(1);
            n = this.readCh();
            switch (n) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 47: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 91: 
                case 124: {
                    this.reset();
                    return this.intern(stringBuffer.toString());
                }
            }
            if (!XMLParser.isNameCharacter(n, this.input.xml11)) {
                this.error("not a name character", "U+" + Integer.toHexString(n));
                continue;
            }
            stringBuffer.append(Character.toChars(n));
        }
    }

    public static boolean isXML11Char(int n) {
        return n >= 1 && n <= 55295 || n >= 57344 && n < 65534 || n >= 65536 && n <= 0x10FFFF;
    }

    public static boolean isXML11RestrictedChar(int n) {
        return n >= 1 && n <= 8 || n >= 11 && n <= 12 || n >= 14 && n <= 31 || n >= 127 && n <= 132 || n >= 134 && n <= 159;
    }

    private boolean isNmtoken(String string, boolean bl) {
        try {
            int[] nArray = UnicodeReader.toCodePointArray(string);
            if (nArray.length == 0) {
                return false;
            }
            if (bl ? !XMLParser.isNameStartCharacter(nArray[0], this.input.xml11) : !XMLParser.isNameCharacter(nArray[0], this.input.xml11)) {
                return false;
            }
            for (int i = 1; i < nArray.length; ++i) {
                if (XMLParser.isNameCharacter(nArray[i], this.input.xml11)) continue;
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNameStartCharacter(int n, boolean bl) {
        if (bl) {
            if (n >= 65 && n <= 90 || n >= 97 && n <= 122) return true;
            if (n == 58 | n == 95 | (n >= 192 && n <= 214) || n >= 216 && n <= 246 || n >= 248 && n <= 767 || n >= 880 && n <= 893 || n >= 895 && n <= 8191 || n >= 8204 && n <= 8205 || n >= 8304 && n <= 8591 || n >= 11264 && n <= 12271 || n >= 12289 && n <= 55295 || n >= 63744 && n <= 64975 || n >= 65008 && n <= 65533) return true;
            if (n < 65536) return false;
            if (n > 983039) return false;
            return true;
        }
        if (n == 95 || n == 58) return true;
        if (!XMLParser.isLetter(n)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNameCharacter(int n, boolean bl) {
        if (bl) {
            if (n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57) return true;
            if (n == 58 | n == 95 | n == 45 | n == 46 | n == 183 | (n >= 192 && n <= 214) || n >= 216 && n <= 246 || n >= 248 && n <= 767 || n >= 768 && n <= 893 || n >= 895 && n <= 8191 || n >= 8204 && n <= 8205 || n >= 8255 && n <= 8256 || n >= 8304 && n <= 8591 || n >= 11264 && n <= 12271 || n >= 12289 && n <= 55295 || n >= 63744 && n <= 64975 || n >= 65008 && n <= 65533) return true;
            if (n < 65536) return false;
            if (n > 983039) return false;
            return true;
        }
        if (n == 46 || n == 45 || n == 95 || n == 58 || XMLParser.isLetter(n) || XMLParser.isDigit(n) || XMLParser.isCombiningChar(n)) return true;
        if (!XMLParser.isExtender(n)) return false;
        return true;
    }

    public static boolean isLetter(int n) {
        if (n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 192 && n <= 214 || n >= 216 && n <= 246 || n >= 248 && n <= 255 || n >= 256 && n <= 305 || n >= 308 && n <= 318 || n >= 321 && n <= 328 || n >= 330 && n <= 382 || n >= 384 && n <= 451 || n >= 461 && n <= 496 || n >= 500 && n <= 501 || n >= 506 && n <= 535 || n >= 592 && n <= 680 || n >= 699 && n <= 705 || n == 902 || n >= 904 && n <= 906 || n == 908 || n >= 910 && n <= 929 || n >= 931 && n <= 974 || n >= 976 && n <= 982 || n == 986 || n == 988 || n == 990 || n == 992 || n >= 994 && n <= 1011 || n >= 1025 && n <= 1036 || n >= 1038 && n <= 1103 || n >= 1105 && n <= 1116 || n >= 1118 && n <= 1153 || n >= 1168 && n <= 1220 || n >= 1223 && n <= 1224 || n >= 1227 && n <= 1228 || n >= 1232 && n <= 1259 || n >= 1262 && n <= 1269 || n >= 1272 && n <= 1273 || n >= 1329 && n <= 1366 || n == 1369 || n >= 1377 && n <= 1414 || n >= 1488 && n <= 1514 || n >= 1520 && n <= 1522 || n >= 1569 && n <= 1594 || n >= 1601 && n <= 1610 || n >= 1649 && n <= 1719 || n >= 1722 && n <= 1726 || n >= 1728 && n <= 1742 || n >= 1744 && n <= 1747 || n == 1749 || n >= 1765 && n <= 1766 || n >= 2309 && n <= 2361 || n == 2365 || n >= 2392 && n <= 2401 || n >= 2437 && n <= 2444 || n >= 2447 && n <= 2448 || n >= 2451 && n <= 2472 || n >= 2474 && n <= 2480 || n == 2482 || n >= 2486 && n <= 2489 || n >= 2524 && n <= 2525 || n >= 2527 && n <= 2529 || n >= 2544 && n <= 2545 || n >= 2565 && n <= 2570 || n >= 2575 && n <= 2576 || n >= 2579 && n <= 2600 || n >= 2602 && n <= 2608 || n >= 2610 && n <= 2611 || n >= 2613 && n <= 2614 || n >= 2616 && n <= 2617 || n >= 2649 && n <= 2652 || n == 2654 || n >= 2674 && n <= 2676 || n >= 2693 && n <= 2699 || n == 2701 || n >= 2703 && n <= 2705 || n >= 2707 && n <= 2728 || n >= 2730 && n <= 2736 || n >= 2738 && n <= 2739 || n >= 2741 && n <= 2745 || n == 2749 || n == 2784 || n >= 2821 && n <= 2828 || n >= 2831 && n <= 2832 || n >= 2835 && n <= 2856 || n >= 2858 && n <= 2864 || n >= 2866 && n <= 2867 || n >= 2870 && n <= 2873 || n == 2877 || n >= 2908 && n <= 2909 || n >= 2911 && n <= 2913 || n >= 2949 && n <= 2954 || n >= 2958 && n <= 2960 || n >= 2962 && n <= 2965 || n >= 2969 && n <= 2970 || n == 2972 || n >= 2974 && n <= 2975 || n >= 2979 && n <= 2980 || n >= 2984 && n <= 2986 || n >= 2990 && n <= 2997 || n >= 2999 && n <= 3001 || n >= 3077 && n <= 3084 || n >= 3086 && n <= 3088 || n >= 3090 && n <= 3112 || n >= 3114 && n <= 3123 || n >= 3125 && n <= 3129 || n >= 3168 && n <= 3169 || n >= 3205 && n <= 3212 || n >= 3214 && n <= 3216 || n >= 3218 && n <= 3240 || n >= 3242 && n <= 3251 || n >= 3253 && n <= 3257 || n == 3294 || n >= 3296 && n <= 3297 || n >= 3333 && n <= 3340 || n >= 3342 && n <= 3344 || n >= 3346 && n <= 3368 || n >= 3370 && n <= 3385 || n >= 3424 && n <= 3425 || n >= 3585 && n <= 3630 || n == 3632 || n >= 3634 && n <= 3635 || n >= 3648 && n <= 3653 || n >= 3713 && n <= 3714 || n == 3716 || n >= 3719 && n <= 3720 || n == 3722 || n == 3725 || n >= 3732 && n <= 3735 || n >= 3737 && n <= 3743 || n >= 3745 && n <= 3747 || n == 3749 || n == 3751 || n >= 3754 && n <= 3755 || n >= 3757 && n <= 3758 || n == 3760 || n >= 3762 && n <= 3763 || n == 3773 || n >= 3776 && n <= 3780 || n >= 3904 && n <= 3911 || n >= 3913 && n <= 3945 || n >= 4256 && n <= 4293 || n >= 4304 && n <= 4342 || n == 4352 || n >= 4354 && n <= 4355 || n >= 4357 && n <= 4359 || n == 4361 || n >= 4363 && n <= 4364 || n >= 4366 && n <= 4370 || n == 4412 || n == 4414 || n == 4416 || n == 4428 || n == 4430 || n == 4432 || n >= 4436 && n <= 4437 || n == 4441 || n >= 4447 && n <= 4449 || n == 4451 || n == 4453 || n == 4455 || n == 4457 || n >= 4461 && n <= 4462 || n >= 4466 && n <= 4467 || n == 4469 || n == 4510 || n == 4520 || n == 4523 || n >= 4526 && n <= 4527 || n >= 4535 && n <= 4536 || n == 4538 || n >= 4540 && n <= 4546 || n == 4587 || n == 4592 || n == 4601 || n >= 7680 && n <= 7835 || n >= 7840 && n <= 7929 || n >= 7936 && n <= 7957 || n >= 7960 && n <= 7965 || n >= 7968 && n <= 8005 || n >= 8008 && n <= 8013 || n >= 8016 && n <= 8023 || n == 8025 || n == 8027 || n == 8029 || n >= 8031 && n <= 8061 || n >= 8064 && n <= 8116 || n >= 8118 && n <= 8124 || n == 8126 || n >= 8130 && n <= 8132 || n >= 8134 && n <= 8140 || n >= 8144 && n <= 8147 || n >= 8150 && n <= 8155 || n >= 8160 && n <= 8172 || n >= 8178 && n <= 8180 || n >= 8182 && n <= 8188 || n == 8486 || n >= 8490 && n <= 8491 || n == 8494 || n >= 8576 && n <= 8578 || n >= 12353 && n <= 12436 || n >= 12449 && n <= 12538 || n >= 12549 && n <= 12588 || n >= 44032 && n <= 55203) {
            return true;
        }
        return n >= 19968 && n <= 40869 || n == 12295 || n >= 12321 && n <= 12329;
    }

    public static boolean isDigit(int n) {
        return n >= 48 && n <= 57 || n >= 1632 && n <= 1641 || n >= 1776 && n <= 1785 || n >= 2406 && n <= 2415 || n >= 2534 && n <= 2543 || n >= 2662 && n <= 2671 || n >= 2790 && n <= 2799 || n >= 2918 && n <= 2927 || n >= 3047 && n <= 3055 || n >= 3174 && n <= 3183 || n >= 3302 && n <= 3311 || n >= 3430 && n <= 3439 || n >= 3664 && n <= 3673 || n >= 3792 && n <= 3801 || n >= 3872 && n <= 3881;
    }

    public static boolean isCombiningChar(int n) {
        return n >= 768 && n <= 837 || n >= 864 && n <= 865 || n >= 1155 && n <= 1158 || n >= 1425 && n <= 1441 || n >= 1443 && n <= 1465 || n >= 1467 && n <= 1469 || n == 1471 || n >= 1473 && n <= 1474 || n == 1476 || n >= 1611 && n <= 1618 || n == 1648 || n >= 1750 && n <= 1756 || n >= 1757 && n <= 1759 || n >= 1760 && n <= 1764 || n >= 1767 && n <= 1768 || n >= 1770 && n <= 1773 || n >= 2305 && n <= 2307 || n == 2364 || n >= 2366 && n <= 2380 || n == 2381 || n >= 2385 && n <= 2388 || n >= 2402 && n <= 2403 || n >= 2433 && n <= 2435 || n == 2492 || n == 2494 || n == 2495 || n >= 2496 && n <= 2500 || n >= 2503 && n <= 2504 || n >= 2507 && n <= 2509 || n == 2519 || n >= 2530 && n <= 2531 || n == 2562 || n == 2620 || n == 2622 || n == 2623 || n >= 2624 && n <= 2626 || n >= 2631 && n <= 2632 || n >= 2635 && n <= 2637 || n >= 2672 && n <= 2673 || n >= 2689 && n <= 2691 || n == 2748 || n >= 2750 && n <= 2757 || n >= 2759 && n <= 2761 || n >= 2763 && n <= 2765 || n >= 2817 && n <= 2819 || n == 2876 || n >= 2878 && n <= 2883 || n >= 2887 && n <= 2888 || n >= 2891 && n <= 2893 || n >= 2902 && n <= 2903 || n >= 2946 && n <= 2947 || n >= 3006 && n <= 3010 || n >= 3014 && n <= 3016 || n >= 3018 && n <= 3021 || n == 3031 || n >= 3073 && n <= 3075 || n >= 3134 && n <= 3140 || n >= 3142 && n <= 3144 || n >= 3146 && n <= 3149 || n >= 3157 && n <= 3158 || n >= 3202 && n <= 3203 || n >= 3262 && n <= 3268 || n >= 3270 && n <= 3272 || n >= 3274 && n <= 3277 || n >= 3285 && n <= 3286 || n >= 3330 && n <= 3331 || n >= 3390 && n <= 3395 || n >= 3398 && n <= 3400 || n >= 3402 && n <= 3405 || n == 3415 || n == 3633 || n >= 3636 && n <= 3642 || n >= 3655 && n <= 3662 || n == 3761 || n >= 3764 && n <= 3769 || n >= 3771 && n <= 3772 || n >= 3784 && n <= 3789 || n >= 3864 && n <= 3865 || n == 3893 || n == 3895 || n == 3897 || n == 3902 || n == 3903 || n >= 3953 && n <= 3972 || n >= 3974 && n <= 3979 || n >= 3984 && n <= 3989 || n == 3991 || n >= 3993 && n <= 4013 || n >= 4017 && n <= 4023 || n == 4025 || n >= 8400 && n <= 8412 || n == 8417 || n >= 12330 && n <= 12335 || n == 12441 || n == 12442;
    }

    public static boolean isExtender(int n) {
        return n == 183 || n == 720 || n == 721 || n == 903 || n == 1600 || n == 3654 || n == 3782 || n == 12293 || n >= 12337 && n <= 12341 || n >= 12445 && n <= 12446 || n >= 12540 && n <= 12542;
    }

    public static boolean isChar(int n) {
        return n >= 32 && n < 55296 || n >= 3584 && n < 65534 || n >= 65536 && n < 0x110000 || n == 10 || n == 9 || n == 13;
    }

    private String intern(String string) {
        if (this.stringInterning) {
            return string.intern();
        }
        return string;
    }

    private void error(String string) throws XMLStreamException {
        this.error(string, null);
    }

    private void error(String string, Object object) throws XMLStreamException {
        if (object != null) {
            if (object instanceof String) {
                string = string + new StringBuffer(": \"").append((String)object).append("\"");
            } else if (object instanceof Character) {
                string = string + new StringBuffer(": '").append((Character)object).append("'");
            }
        }
        throw new XMLStreamException(string);
    }

    private void validateStartElement(String string) throws XMLStreamException {
        if (this.currentContentModel == null) {
            if (!string.equals(this.doctype.rootName)) {
                this.error("root element name must match name in DTD");
            }
            return;
        }
        switch (this.currentContentModel.type) {
            case 0: {
                this.error("child element found in empty element", string);
                break;
            }
            case 2: {
                LinkedList linkedList = (LinkedList)this.validationStack.getLast();
                linkedList.add(string);
                break;
            }
            case 3: {
                MixedContentModel mixedContentModel = (MixedContentModel)this.currentContentModel;
                if (mixedContentModel.containsName(string)) break;
                this.error("illegal element for content model", string);
            }
        }
    }

    private void validateEndElement() throws XMLStreamException {
        if (this.currentContentModel == null) {
            if (!this.idrefs.containsAll(this.ids)) {
                this.error("IDREF values must match the value of some ID attribute");
            }
            return;
        }
        if (this.currentContentModel.type == 2) {
            LinkedList linkedList = (LinkedList)this.validationStack.getLast();
            ElementContentModel elementContentModel = (ElementContentModel)this.currentContentModel;
            this.validateElementContent(elementContentModel, linkedList);
        }
    }

    private void validatePCData(String string) throws XMLStreamException {
        switch (this.currentContentModel.type) {
            case 0: {
                this.error("character data found in empty element", string);
                break;
            }
            case 2: {
                boolean bl = true;
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    this.error("character data found in element with element content", string);
                    break;
                }
                if (this.xmlStandalone != Boolean.TRUE || !this.currentContentModel.external) break;
                this.error("whitespace in element content of externally declared element in standalone document");
            }
        }
    }

    private void validateElementContent(ElementContentModel elementContentModel, LinkedList linkedList) throws XMLStreamException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        Object object = linkedList.iterator();
        while (object.hasNext()) {
            stringBuffer.append((String)object.next());
            stringBuffer.append(' ');
        }
        object = stringBuffer.toString();
        if (!((String)object).matches(string = this.createRegularExpression(elementContentModel))) {
            this.error("element content " + elementContentModel.text + " does not match expression " + string, object);
        }
    }

    private String createRegularExpression(ElementContentModel elementContentModel) {
        if (elementContentModel.regex == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            Iterator iterator = elementContentModel.contentParticles.iterator();
            while (iterator.hasNext()) {
                ContentParticle contentParticle = (ContentParticle)iterator.next();
                if (contentParticle.content instanceof String) {
                    stringBuffer.append('(');
                    stringBuffer.append((String)contentParticle.content);
                    stringBuffer.append(' ');
                    stringBuffer.append(')');
                    if (contentParticle.max == -1) {
                        if (contentParticle.min == 0) {
                            stringBuffer.append('*');
                        } else {
                            stringBuffer.append('+');
                        }
                    } else if (contentParticle.min == 0) {
                        stringBuffer.append('?');
                    }
                } else {
                    ElementContentModel elementContentModel2 = (ElementContentModel)contentParticle.content;
                    stringBuffer.append(this.createRegularExpression(elementContentModel2));
                }
                if (!elementContentModel.or || !iterator.hasNext()) continue;
                stringBuffer.append('|');
            }
            stringBuffer.append(')');
            if (elementContentModel.max == -1) {
                if (elementContentModel.min == 0) {
                    stringBuffer.append('*');
                } else {
                    stringBuffer.append('+');
                }
            } else if (elementContentModel.min == 0) {
                stringBuffer.append('?');
            }
            elementContentModel.regex = stringBuffer.toString();
        }
        return elementContentModel.regex;
    }

    void validateDoctype() throws XMLStreamException {
        Iterator iterator = this.doctype.entityIterator();
        while (iterator.hasNext()) {
            ExternalIds externalIds;
            Map.Entry entry = (Map.Entry)iterator.next();
            Object object = entry.getValue();
            if (!(object instanceof ExternalIds)) continue;
            ExternalIds externalIds2 = (ExternalIds)object;
            if (externalIds2.notationName == null || (externalIds = this.doctype.getNotation(externalIds2.notationName)) != null) continue;
            this.error("Notation name must match the declared name of a notation", externalIds2.notationName);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] var0) throws Exception {
        var1_1 = false;
        var2_2 = false;
        var3_3 = false;
        for (var4_4 = 0; var4_4 < var0.length && var0[var4_4].startsWith("-"); ++var4_4) {
            if ("-x".equals(var0[var4_4])) {
                var3_3 = true;
                continue;
            }
            if ("-v".equals(var0[var4_4])) {
                var1_1 = true;
                continue;
            }
            if (!"-n".equals(var0[var4_4])) continue;
            var2_2 = true;
        }
        if (var4_4 >= var0.length) {
            System.out.println("Syntax: XMLParser [-n] [-v] [-x] <file> [<file2> [...]]");
            System.out.println("\t-n: use namespace aware mode");
            System.out.println("\t-v: use validating parser");
            System.out.println("\t-x: use XInclude aware mode");
            System.exit(2);
        }
        while (true) {
            if (var4_4 >= var0.length) {
                return;
            }
            var5_5 = new XMLParser(new FileInputStream(var0[var4_4]), XMLParser.absolutize(null, var0[var4_4]), var1_1, var2_2, true, true, true, true, true, true, true, null, null);
            var6_6 = var5_5;
            if (var3_3) {
                var6_6 = new XIncludeFilter(var5_5, var0[var4_4], true, true, true);
            }
lbl27:
            // 15 sources

            try {
                block19: while (var6_6.hasNext()) {
                    var7_7 = var6_6.next();
                    var8_9 = var6_6.getLocation();
                    System.out.print(var8_9.getLineNumber() + ":" + var8_9.getColumnNumber() + " ");
                    switch (var7_7) {
                        case 7: {
                            System.out.println("START_DOCUMENT version=" + var6_6.getVersion() + " encoding=" + var6_6.getEncoding());
                            ** GOTO lbl27
                        }
                        case 8: {
                            System.out.println("END_DOCUMENT");
                            ** GOTO lbl27
                        }
                        case 1: {
                            System.out.println("START_ELEMENT " + var6_6.getName());
                            var9_10 = var6_6.getNamespaceCount();
                            for (var10_11 = 0; var10_11 < var9_10; ++var10_11) {
                                System.out.println("\tnamespace " + var6_6.getNamespacePrefix(var10_11) + "='" + var6_6.getNamespaceURI(var10_11) + "'");
                            }
                            var9_10 = var6_6.getAttributeCount();
                            for (var10_11 = 0; var10_11 < var9_10; ++var10_11) {
                                System.out.println("\tattribute " + var6_6.getAttributeName(var10_11) + "='" + var6_6.getAttributeValue(var10_11) + "'");
                            }
                            continue block19;
                        }
                        case 2: {
                            System.out.println("END_ELEMENT " + var6_6.getName());
                            ** GOTO lbl27
                        }
                        case 4: {
                            System.out.println("CHARACTERS '" + XMLParser.encodeText(var6_6.getText()) + "'");
                            ** GOTO lbl27
                        }
                        case 12: {
                            System.out.println("CDATA '" + XMLParser.encodeText(var6_6.getText()) + "'");
                            ** GOTO lbl27
                        }
                        case 6: {
                            System.out.println("SPACE '" + XMLParser.encodeText(var6_6.getText()) + "'");
                            ** GOTO lbl27
                        }
                        case 11: {
                            System.out.println("DTD " + var6_6.getText());
                            ** GOTO lbl27
                        }
                        case 9: {
                            System.out.println("ENTITY_REFERENCE " + var6_6.getText());
                            ** GOTO lbl27
                        }
                        case 5: {
                            System.out.println("COMMENT '" + XMLParser.encodeText(var6_6.getText()) + "'");
                            ** GOTO lbl27
                        }
                        case 3: {
                            System.out.println("PROCESSING_INSTRUCTION " + var6_6.getPITarget() + " " + var6_6.getPIData());
                            ** GOTO lbl27
                        }
                        case 50: {
                            System.out.println("START_ENTITY " + var6_6.getText());
                            ** GOTO lbl27
                        }
                        case 51: {
                            System.out.println("END_ENTITY " + var6_6.getText());
                            ** GOTO lbl27
                        }
                    }
                    System.out.println("Unknown event: " + var7_7);
                }
            }
            catch (XMLStreamException var7_8) {
                var8_9 = var6_6.getLocation();
                System.out.println("At line " + var8_9.getLineNumber() + ", column " + var8_9.getColumnNumber() + " of " + var8_9.getSystemId());
                throw var7_8;
            }
            ++var4_4;
        }
    }

    private static String encodeText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block5;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block5;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        TEST_START_ELEMENT = TEST_START_ELEMENT;
        TEST_END_ELEMENT = TEST_END_ELEMENT;
        TEST_COMMENT = TEST_COMMENT;
        TEST_PI = TEST_PI;
        TEST_CDATA = TEST_CDATA;
        TEST_XML_DECL = TEST_XML_DECL;
        TEST_DOCTYPE_DECL = TEST_DOCTYPE_DECL;
        TEST_ELEMENT_DECL = TEST_ELEMENT_DECL;
        TEST_ATTLIST_DECL = TEST_ATTLIST_DECL;
        TEST_ENTITY_DECL = TEST_ENTITY_DECL;
        TEST_NOTATION_DECL = TEST_NOTATION_DECL;
        TEST_KET = TEST_KET;
        TEST_END_COMMENT = TEST_END_COMMENT;
        TEST_END_PI = TEST_END_PI;
        TEST_END_CDATA = TEST_END_CDATA;
        PREDEFINED_ENTITIES = new LinkedHashMap();
        PREDEFINED_ENTITIES.put("amp", "&");
        PREDEFINED_ENTITIES.put("lt", TEST_START_ELEMENT);
        PREDEFINED_ENTITIES.put("gt", TEST_KET);
        PREDEFINED_ENTITIES.put("apos", "'");
        PREDEFINED_ENTITIES.put("quot", "\"");
    }

    static class Input
    implements Location {
        int line;
        int markLine;
        int column;
        int markColumn;
        int offset;
        int markOffset;
        final String publicId;
        final String systemId;
        final String name;
        final boolean report;
        final boolean normalize;
        InputStream in;
        Reader reader;
        UnicodeReader unicodeReader;
        boolean initialized;
        boolean encodingDetected;
        String inputEncoding;
        boolean xml11;
        private static final int[] SIGNATURE_UCS_4_1234 = new int[]{0, 0, 0, 60};
        private static final int[] SIGNATURE_UCS_4_4321 = new int[]{60, 0, 0, 0};
        private static final int[] SIGNATURE_UCS_4_2143 = new int[]{0, 0, 60, 0};
        private static final int[] SIGNATURE_UCS_4_3412 = new int[]{0, 60, 0, 0};
        private static final int[] SIGNATURE_UCS_2_12 = new int[]{254, 255};
        private static final int[] SIGNATURE_UCS_2_21 = new int[]{255, 254};
        private static final int[] SIGNATURE_UCS_2_12_NOBOM = new int[]{0, 60, 0, 63};
        private static final int[] SIGNATURE_UCS_2_21_NOBOM = new int[]{60, 0, 63, 0};
        private static final int[] SIGNATURE_UTF_8 = new int[]{60, 63, 120, 109};
        private static final int[] SIGNATURE_UTF_8_BOM = new int[]{239, 187, 191};

        private /* synthetic */ void finit$() {
            this.line = 1;
        }

        Input(InputStream inputStream, Reader reader, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
            this.finit$();
            if (string4 == null) {
                string4 = "UTF-8";
            }
            this.inputEncoding = string4;
            this.publicId = string;
            this.systemId = string2;
            this.name = string3;
            this.report = bl;
            this.normalize = bl2;
            if (inputStream != null) {
                if (reader != null) {
                    throw new IllegalStateException("both byte and char streams specified");
                }
                if (bl2) {
                    inputStream = new CRLFInputStream(inputStream);
                }
                this.in = inputStream = new BufferedInputStream(inputStream);
            } else {
                this.reader = bl2 ? new CRLFReader(reader) : reader;
                this.unicodeReader = new UnicodeReader(this.reader);
            }
            this.initialized = false;
        }

        public int getCharacterOffset() {
            return this.offset;
        }

        public int getColumnNumber() {
            return this.column;
        }

        public int getLineNumber() {
            return this.line;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        void init() throws IOException {
            if (this.initialized) {
                return;
            }
            if (this.in != null) {
                this.detectEncoding();
            }
            this.initialized = true;
        }

        void mark(int n) throws IOException {
            this.markOffset = this.offset;
            this.markLine = this.line;
            this.markColumn = this.column;
            if (this.unicodeReader != null) {
                this.unicodeReader.mark(n);
            } else {
                this.in.mark(n);
            }
        }

        int read() throws IOException {
            int n;
            ++this.offset;
            int n2 = n = this.unicodeReader != null ? this.unicodeReader.read() : this.in.read();
            if (this.normalize && (n == 13 || this.xml11 && (n == 133 || n == 8232))) {
                n = 10;
            }
            if (n == 10) {
                ++this.line;
                this.column = 0;
            } else {
                ++this.column;
            }
            return n;
        }

        int read(int[] nArray, int n, int n2) throws IOException {
            int n3;
            if (this.unicodeReader != null) {
                n3 = this.unicodeReader.read(nArray, n, n2);
            } else {
                byte[] byArray = new byte[n2];
                n3 = this.in.read(byArray, 0, n2);
                if (n3 != -1) {
                    String string = new String(byArray, 0, n3, this.inputEncoding);
                    int[] nArray2 = UnicodeReader.toCodePointArray(string);
                    n3 = nArray2.length;
                    System.arraycopy(nArray2, 0, nArray, n, n3);
                }
            }
            if (n3 != -1) {
                for (int i = 0; i < n3; ++i) {
                    int n4 = nArray[n + i];
                    if (this.normalize && (n4 == 13 || this.xml11 && (n4 == 133 || n4 == 8232))) {
                        nArray[n + i] = n4 = 10;
                    }
                    if (n4 == 10) {
                        ++this.line;
                        this.column = 0;
                        continue;
                    }
                    ++this.column;
                }
            }
            return n3;
        }

        void reset() throws IOException {
            if (this.unicodeReader != null) {
                this.unicodeReader.reset();
            } else {
                this.in.reset();
            }
            this.offset = this.markOffset;
            this.line = this.markLine;
            this.column = this.markColumn;
        }

        private void detectEncoding() throws IOException {
            int[] nArray = new int[4];
            this.in.mark(4);
            for (int i = 0; i < 4; ++i) {
                nArray[i] = this.in.read();
            }
            this.in.reset();
            if (Input.equals(SIGNATURE_UCS_4_1234, nArray)) {
                this.in.read();
                this.in.read();
                this.in.read();
                this.in.read();
                this.setInputEncoding("UTF-32BE");
                this.encodingDetected = true;
            } else if (Input.equals(SIGNATURE_UCS_4_4321, nArray)) {
                this.in.read();
                this.in.read();
                this.in.read();
                this.in.read();
                this.setInputEncoding("UTF-32LE");
                this.encodingDetected = true;
            } else {
                if (Input.equals(SIGNATURE_UCS_4_2143, nArray) || Input.equals(SIGNATURE_UCS_4_3412, nArray)) {
                    throw new UnsupportedEncodingException("unsupported UCS-4 byte ordering");
                }
                if (Input.equals(SIGNATURE_UCS_2_12, nArray)) {
                    this.in.read();
                    this.in.read();
                    this.setInputEncoding("UTF-16BE");
                    this.encodingDetected = true;
                } else if (Input.equals(SIGNATURE_UCS_2_21, nArray)) {
                    this.in.read();
                    this.in.read();
                    this.setInputEncoding("UTF-16LE");
                    this.encodingDetected = true;
                } else {
                    if (Input.equals(SIGNATURE_UCS_2_12_NOBOM, nArray)) {
                        throw new UnsupportedEncodingException("no byte-order mark for UCS-2 entity");
                    }
                    if (Input.equals(SIGNATURE_UCS_2_21_NOBOM, nArray)) {
                        throw new UnsupportedEncodingException("no byte-order mark for UCS-2 entity");
                    }
                    if (!Input.equals(SIGNATURE_UTF_8, nArray) && Input.equals(SIGNATURE_UTF_8_BOM, nArray)) {
                        this.in.read();
                        this.in.read();
                        this.in.read();
                        this.setInputEncoding("UTF-8");
                        this.encodingDetected = true;
                    }
                }
            }
        }

        private static boolean equals(int[] nArray, int[] nArray2) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                return false;
            }
            return true;
        }

        void setInputEncoding(String string) throws IOException {
            if (string.equals(this.inputEncoding)) {
                return;
            }
            if ("UTF-16".equalsIgnoreCase(string) && this.inputEncoding.startsWith("UTF-16")) {
                return;
            }
            if (this.encodingDetected) {
                throw new UnsupportedEncodingException("document is not in its declared encoding " + this.inputEncoding + ": " + string);
            }
            this.inputEncoding = string;
            this.finalizeEncoding();
        }

        void finalizeEncoding() throws IOException {
            if (this.reader != null) {
                return;
            }
            this.reader = new BufferedReader(new InputStreamReader(this.in, this.inputEncoding));
            this.unicodeReader = new UnicodeReader(this.reader);
            this.mark(1);
        }
    }

    class AttributeDecl {
        private /* synthetic */ XMLParser this$0;
        final String type;
        final String value;
        final int valueType;
        final String enumeration;
        final HashSet values;
        final boolean external;

        AttributeDecl(XMLParser xMLParser, String string, String string2, int n, String string3, HashSet hashSet, boolean bl) {
            this.this$0 = xMLParser;
            this.type = string;
            this.value = string2;
            this.valueType = n;
            this.enumeration = string3;
            this.values = hashSet;
            this.external = bl;
        }
    }

    class MixedContentModel
    extends ContentModel {
        private /* synthetic */ XMLParser this$0;
        private HashSet names;

        MixedContentModel(XMLParser xMLParser) {
            this.this$0 = xMLParser;
            super(xMLParser, 3);
            this.names = new HashSet();
        }

        void addName(String string) {
            this.names.add(string);
        }

        boolean containsName(String string) {
            return this.names.contains(string);
        }
    }

    class ContentParticle {
        private /* synthetic */ XMLParser this$0;
        int min;
        int max;
        Object content;

        private /* synthetic */ void finit$() {
            this.min = 1;
            this.max = 1;
        }

        ContentParticle(XMLParser xMLParser) {
            this.this$0 = xMLParser;
            this.finit$();
        }
    }

    class ElementContentModel
    extends ContentModel {
        private /* synthetic */ XMLParser this$0;
        LinkedList contentParticles;
        boolean or;
        String regex;

        ElementContentModel(XMLParser xMLParser) {
            this.this$0 = xMLParser;
            super(xMLParser, 2);
            this.contentParticles = new LinkedList();
        }

        void addContentParticle(ContentParticle contentParticle) {
            this.contentParticles.add(contentParticle);
        }
    }

    class AnyContentModel
    extends ContentModel {
        private /* synthetic */ XMLParser this$0;

        AnyContentModel(XMLParser xMLParser) {
            this.this$0 = xMLParser;
            super(xMLParser, 1);
            this.min = 0;
            this.max = -1;
        }
    }

    class EmptyContentModel
    extends ContentModel {
        private /* synthetic */ XMLParser this$0;

        EmptyContentModel(XMLParser xMLParser) {
            this.this$0 = xMLParser;
            super(xMLParser, 0);
            this.min = 0;
            this.max = 0;
        }
    }

    abstract class ContentModel {
        private /* synthetic */ XMLParser this$0;
        static final int EMPTY = 0;
        static final int ANY = 1;
        static final int ELEMENT = 2;
        static final int MIXED = 3;
        int min;
        int max;
        final int type;
        String text;
        boolean external;

        ContentModel(XMLParser xMLParser, int n) {
            this.this$0 = xMLParser;
            this.type = n;
            this.min = 1;
            this.max = 1;
        }
    }

    class ExternalIds {
        private /* synthetic */ XMLParser this$0;
        String publicId;
        String systemId;
        String notationName;

        ExternalIds(XMLParser xMLParser) {
            this.this$0 = xMLParser;
        }
    }

    class Doctype {
        private /* synthetic */ XMLParser this$0;
        final String rootName;
        final String publicId;
        final String systemId;
        private final LinkedHashMap elements;
        private final LinkedHashMap attlists;
        private final LinkedHashMap entities;
        private final LinkedHashMap notations;
        private final LinkedHashMap comments;
        private final LinkedHashMap pis;
        private final LinkedList entries;
        private final HashSet externalEntities;
        private final HashSet externalNotations;
        private int anon;

        private /* synthetic */ void finit$() {
            this.elements = new LinkedHashMap();
            this.attlists = new LinkedHashMap();
            this.entities = new LinkedHashMap();
            this.notations = new LinkedHashMap();
            this.comments = new LinkedHashMap();
            this.pis = new LinkedHashMap();
            this.entries = new LinkedList();
            this.externalEntities = new HashSet();
            this.externalNotations = new HashSet();
            this.anon = 1;
        }

        Doctype(XMLParser xMLParser, String string, String string2, String string3) {
            this.this$0 = xMLParser;
            this.finit$();
            this.rootName = string;
            this.publicId = string2;
            this.systemId = string3;
        }

        void addElementDecl(String string, String string2, ContentModel contentModel) {
            if (this.elements.containsKey(string)) {
                return;
            }
            contentModel.text = string2;
            contentModel.external = this.this$0.inputStack.size() != 1;
            this.elements.put(string, contentModel);
            this.entries.add("E" + string);
        }

        void addAttributeDecl(String string, String string2, AttributeDecl attributeDecl) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.attlists.get(string);
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap();
                this.attlists.put(string, linkedHashMap);
            } else if (linkedHashMap.containsKey(string2)) {
                return;
            }
            linkedHashMap.put(string2, attributeDecl);
            String string3 = "A" + string;
            if (!this.entries.contains(string3)) {
                this.entries.add(string3);
            }
        }

        void addEntityDecl(String string, String string2, boolean bl) {
            if (this.entities.containsKey(string)) {
                return;
            }
            this.entities.put(string, string2);
            this.entries.add("e" + string);
            if (bl) {
                this.externalEntities.add(string);
            }
        }

        void addEntityDecl(String string, ExternalIds externalIds, boolean bl) {
            if (this.entities.containsKey(string)) {
                return;
            }
            this.entities.put(string, externalIds);
            this.entries.add("e" + string);
            if (bl) {
                this.externalEntities.add(string);
            }
        }

        void addNotationDecl(String string, ExternalIds externalIds, boolean bl) {
            if (this.notations.containsKey(string)) {
                return;
            }
            this.notations.put(string, externalIds);
            this.entries.add("n" + string);
            if (bl) {
                this.externalNotations.add(string);
            }
        }

        void addComment(String string) {
            String string2 = Integer.toString(this.anon++);
            this.comments.put(string2, string);
            this.entries.add("c" + string2);
        }

        void addPI(String string, String string2) {
            String string3 = Integer.toString(this.anon++);
            this.pis.put(string3, new String[]{string, string2});
            this.entries.add("p" + string3);
        }

        ContentModel getElementModel(String string) {
            return (ContentModel)this.elements.get(string);
        }

        AttributeDecl getAttributeDecl(String string, String string2) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.attlists.get(string);
            if (linkedHashMap == null) {
                return null;
            }
            return (AttributeDecl)linkedHashMap.get(string2);
        }

        boolean isAttributeDeclared(String string, String string2) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.attlists.get(string);
            if (linkedHashMap != null) {
                return linkedHashMap.containsKey(string2);
            }
            return false;
        }

        Iterator attlistIterator(String string) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.attlists.get(string);
            if (linkedHashMap == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            return linkedHashMap.entrySet().iterator();
        }

        Object getEntity(String string) {
            return this.entities.get(string);
        }

        boolean isEntityExternal(String string) {
            return this.externalEntities.contains(string);
        }

        Iterator entityIterator() {
            return this.entities.entrySet().iterator();
        }

        ExternalIds getNotation(String string) {
            return (ExternalIds)this.notations.get(string);
        }

        boolean isNotationExternal(String string) {
            return this.externalNotations.contains(string);
        }

        String getComment(String string) {
            return (String)this.comments.get(string);
        }

        String[] getPI(String string) {
            return (String[])this.pis.get(string);
        }

        Iterator entryIterator() {
            return this.entries.iterator();
        }
    }

    class Attribute {
        private /* synthetic */ XMLParser this$0;
        final String name;
        final String type;
        final boolean specified;
        final String value;
        final String prefix;
        final String localName;

        Attribute(XMLParser xMLParser, String string, String string2, boolean bl, String string3) {
            this.this$0 = xMLParser;
            this.name = string;
            this.type = string2;
            this.specified = bl;
            this.value = string3;
            int n = string.indexOf(58);
            if (n == -1) {
                this.prefix = null;
                this.localName = xMLParser.intern(string);
            } else {
                this.prefix = xMLParser.intern(string.substring(0, n));
                this.localName = xMLParser.intern(string.substring(n + 1));
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Attribute) {
                Attribute attribute = (Attribute)object;
                if (this.this$0.namespaceAware) {
                    if (!attribute.localName.equals(this.localName)) {
                        return false;
                    }
                    String string = this.this$0.getNamespaceURI(attribute.prefix);
                    String string2 = this.this$0.getNamespaceURI(this.prefix);
                    if (string2 == null && (string == null || ((XMLParser)this.this$0).input.xml11 && "".equals(string))) {
                        return true;
                    }
                    if (string2 != null) {
                        if ("".equals(string2) && ((XMLParser)this.this$0).input.xml11 && "".equals(string)) {
                            return true;
                        }
                        return string2.equals(string);
                    }
                    return false;
                }
                return attribute.name.equals(this.name);
            }
            return false;
        }
    }
}

