/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.peer.MenuBarPeer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class MenuBar
extends MenuComponent
implements MenuContainer,
Serializable,
Accessible {
    private static final long serialVersionUID = -4930327919388951260L;
    private static transient long next_menubar_number;
    private Menu helpMenu;
    private Vector menus;

    private /* synthetic */ void finit$() {
        this.menus = new Vector();
    }

    public MenuBar() {
        this.finit$();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public synchronized void setHelpMenu(Menu menu) {
        MenuBarPeer menuBarPeer = (MenuBarPeer)this.getPeer();
        if (this.helpMenu != null) {
            if (menuBarPeer != null) {
                this.helpMenu.removeNotify();
            }
            this.helpMenu.setParent(null);
        }
        this.helpMenu = menu;
        MenuContainer menuContainer = menu.getParent();
        if (menuContainer != null) {
            menuContainer.remove(menu);
        }
        menu.setParent(this);
        if (menuBarPeer != null) {
            menu.addNotify();
            menuBarPeer.addHelpMenu(menu);
        }
    }

    public synchronized Menu add(Menu menu) {
        MenuBarPeer menuBarPeer = (MenuBarPeer)this.getPeer();
        MenuContainer menuContainer = menu.getParent();
        if (menuContainer != null) {
            menuContainer.remove(menu);
        }
        this.menus.addElement(menu);
        menu.setParent(this);
        if (menuBarPeer != null) {
            menu.addNotify();
            menuBarPeer.addMenu(menu);
        }
        return menu;
    }

    public synchronized void remove(int n) {
        Menu menu = (Menu)this.menus.remove(n);
        MenuBarPeer menuBarPeer = (MenuBarPeer)this.getPeer();
        if (menuBarPeer != null) {
            menu.removeNotify();
        }
        menu.setParent(null);
        if (menuBarPeer != null) {
            menuBarPeer.delMenu(n);
        }
    }

    public void remove(MenuComponent menuComponent) {
        int n = this.menus.indexOf(menuComponent);
        if (n == -1) {
            return;
        }
        this.remove(n);
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    public int countMenus() {
        return this.menus.size() + (this.getHelpMenu() == null ? 0 : 1);
    }

    public Menu getMenu(int n) {
        return (Menu)this.menus.elementAt(n);
    }

    public void addNotify() {
        MenuBarPeer menuBarPeer = (MenuBarPeer)this.getPeer();
        if (menuBarPeer == null) {
            menuBarPeer = this.getToolkit().createMenuBar(this);
            this.setPeer(menuBarPeer);
        }
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            menu.addNotify();
            menuBarPeer.addMenu(menu);
        }
        if (this.helpMenu != null) {
            this.helpMenu.addNotify();
            menuBarPeer.addHelpMenu(this.helpMenu);
        }
    }

    public void removeNotify() {
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            menu.removeNotify();
        }
        super.removeNotify();
    }

    public synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            if (menu.getShortcut() == null) continue;
            vector.addElement(menu.getShortcut());
        }
        return vector.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            MenuShortcut menuShortcut2 = menu.getShortcut();
            if (menuShortcut2 == null || !menuShortcut2.equals(menuShortcut)) continue;
            return menu;
        }
        return null;
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        MenuItem menuItem;
        while ((menuItem = this.getShortcutMenuItem(menuShortcut)) != null) {
            menuItem.deleteShortcut();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar(this);
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "menubar" + MenuBar.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_menubar_number++;
    }

    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        private /* synthetic */ MenuBar this$0;
        private static final long serialVersionUID = -8577604491830083815L;

        protected AccessibleAWTMenuBar(MenuBar menuBar) {
            this.this$0 = menuBar;
            super(menuBar);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }
    }
}

