/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.UID;

public class ActivationID
implements Serializable {
    static final long serialVersionUID = -4608673054848209235L;
    transient Activator activator;
    transient UID uid;
    transient ActivationGroup group;

    public ActivationID(Activator activator) {
        this.activator = activator;
        this.uid = new UID();
    }

    public Remote activate(boolean bl) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            return (Remote)this.activator.activate(this, bl).get();
        }
        catch (IOException iOException) {
            ActivationException activationException = new ActivationException("id " + this.uid, iOException);
            throw activationException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ActivationException activationException = new ActivationException("id " + this.uid, classNotFoundException);
            throw activationException;
        }
    }

    public int hashCode() {
        if (this.uid == null) {
            return 0;
        }
        return this.uid.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ActivationID) {
            ActivationID activationID = (ActivationID)object;
            return ActivationID.eq(this.uid, activationID.uid);
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.uid = (UID)objectInputStream.readObject();
        this.activator = (Activator)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        objectOutputStream.writeObject(this.uid);
        objectOutputStream.writeObject(this.activator);
    }

    static final boolean eq(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        return object.equals(object2);
    }

    public String toString() {
        return this.uid.toString();
    }
}

