/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.filechooser.UnixFileSystemView;

public abstract class FileSystemView {
    private static FileSystemView defaultFileSystemView;

    public File createFileObject(File file, String string) {
        return new File(file, string);
    }

    public File createFileObject(String string) {
        File file = new File(string);
        if (this.isFileSystemRoot(file)) {
            file = this.createFileSystemRoot(file);
        }
        return file;
    }

    protected File createFileSystemRoot(File file) {
        File[] fileArray = File.listRoots();
        if (fileArray == null) {
            return null;
        }
        return fileArray[0];
    }

    public abstract File createNewFolder(File var1) throws IOException;

    public File getChild(File file, String string) {
        return new File(file, string);
    }

    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    public File[] getFiles(File file, boolean bl) {
        if (file == null || file.listFiles() == null) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (!bl) {
            return fileArray;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isHidden()) continue;
            arrayList.add(fileArray[i]);
        }
        File[] fileArray2 = (File[])arrayList.toArray(new File[arrayList.size()]);
        return fileArray2;
    }

    public static FileSystemView getFileSystemView() {
        if (defaultFileSystemView == null && File.separator.equals("/")) {
            defaultFileSystemView = new UnixFileSystemView();
        }
        return defaultFileSystemView;
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getParentDirectory(File file) {
        if (file == null) {
            return null;
        }
        return file.getParentFile();
    }

    public File[] getRoots() {
        return null;
    }

    public String getSystemDisplayName(File file) {
        String string = null;
        if (file != null) {
            string = file.getName();
        }
        return string;
    }

    public Icon getSystemIcon(File file) {
        return null;
    }

    public String getSystemTypeDescription(File file) {
        return null;
    }

    public boolean isComputerNode(File file) {
        return false;
    }

    public boolean isDrive(File file) {
        return false;
    }

    public boolean isFileSystem(File file) {
        return file.isFile() || file.isDirectory();
    }

    public boolean isFileSystemRoot(File file) {
        File[] fileArray = File.listRoots();
        if (fileArray == null || file == null) {
            return false;
        }
        String string = file.getAbsolutePath();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getAbsolutePath().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isFloppyDrive(File file) {
        return false;
    }

    public boolean isHiddenFile(File file) {
        return file.isHidden();
    }

    public boolean isParent(File file, File file2) {
        File file3 = file2.getParentFile();
        if (file3 == null) {
            return false;
        }
        return file.equals(file3);
    }

    public boolean isRoot(File file) {
        return false;
    }

    public Boolean isTraversable(File file) {
        return file.isDirectory();
    }
}

