/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreeCellRenderer;

public class DefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public DefaultTreeCellRenderer() {
        this.setLeafIcon(this.getDefaultLeafIcon());
        this.setOpenIcon(this.getDefaultOpenIcon());
        this.setClosedIcon(this.getDefaultClosedIcon());
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        if (font != null && font instanceof UIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public void setBackground(Color color) {
        if (color != null && color instanceof UIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (bl3) {
            this.setIcon(this.getLeafIcon());
        } else if (bl2) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.setText(object.toString());
        this.selected = bl;
        this.hasFocus = bl4;
        this.setHorizontalAlignment(2);
        this.setOpaque(false);
        this.setVerticalAlignment(0);
        this.setEnabled(true);
        super.setFont(UIManager.getFont("Tree.font"));
        if (bl) {
            super.setBackground(this.getBackgroundSelectionColor());
            this.setForeground(this.getTextSelectionColor());
            if (bl4) {
                this.setBorderSelectionColor(UIManager.getLookAndFeelDefaults().getColor("Tree.selectionBorderColor"));
            } else {
                this.setBorderSelectionColor(null);
            }
        } else {
            super.setBackground(this.getBackgroundNonSelectionColor());
            this.setForeground(this.getTextNonSelectionColor());
            this.setBorderSelectionColor(null);
        }
        return this;
    }

    public Font getFont() {
        return super.getFont();
    }

    public void paint(Graphics graphics) {
        Color color;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Insets insets = new Insets(0, 0, 0, 0);
        Border border = UIManager.getBorder("Tree.selectionBorder");
        if (border != null) {
            insets = border.getBorderInsets(this);
        }
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
        SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, this.getIconTextGap());
        Rectangle rectangle4 = this.getBounds(rectangle2);
        rectangle4.x = rectangle3.x - insets.left;
        rectangle4.width = rectangle3.width + insets.left + insets.right;
        graphics.setColor(super.getBackground());
        graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
        super.paint(graphics);
        if (this.hasFocus && (color = this.getBorderSelectionColor()) != null) {
            graphics.setColor(color);
            graphics.drawRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height - 1);
        }
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
        SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, this.getIconTextGap());
        Rectangle rectangle4 = rectangle2.union(rectangle3);
        return new Dimension(rectangle4.width, rectangle4.height);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

