/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class DiffieHellmanImpl
extends KeyAgreementSpi {
    private DHPrivateKey key = null;
    private byte[] result = null;
    private boolean last_phase_done = false;

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException {
        if (this.key == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.last_phase_done) {
            throw new IllegalStateException("Last phase already done");
        }
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("Key MUST be a DHPublicKey");
        }
        DHPublicKey dHPublicKey = (DHPublicKey)key;
        DHParameterSpec dHParameterSpec = this.key.getParams();
        DHParameterSpec dHParameterSpec2 = dHPublicKey.getParams();
        if (!dHParameterSpec.getG().equals(dHParameterSpec2.getG()) || !dHParameterSpec.getP().equals(dHParameterSpec2.getP()) || dHParameterSpec.getL() != dHParameterSpec2.getL()) {
            throw new InvalidKeyException("Incompatible key");
        }
        if (!bl) {
            throw new IllegalArgumentException("This key-agreement MUST be concluded in one step only");
        }
        BigInteger bigInteger = dHPublicKey.getY().modPow(this.key.getX(), dHParameterSpec.getP());
        this.result = bigInteger.toByteArray();
        if (this.result[0] == 0) {
            byte[] byArray = new byte[this.result.length - 1];
            System.arraycopy(this.result, 1, byArray, 0, byArray.length);
            this.result = byArray;
        }
        this.last_phase_done = true;
        return null;
    }

    protected byte[] engineGenerateSecret() {
        this.checkState();
        byte[] byArray = (byte[])this.result.clone();
        this.reset();
        return byArray;
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws ShortBufferException {
        this.checkState();
        if (this.result.length > byArray.length - n) {
            throw new ShortBufferException();
        }
        System.arraycopy(this.result, 0, byArray, n, this.result.length);
        int n2 = this.result.length;
        this.reset();
        return n2;
    }

    protected SecretKey engineGenerateSecret(String string) throws InvalidKeyException {
        this.checkState();
        byte[] byArray = (byte[])this.result.clone();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
        this.reset();
        return secretKeySpec;
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Key MUST be a DHPrivateKey");
        }
        this.key = (DHPrivateKey)key;
        this.reset();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(key, secureRandom);
    }

    private void reset() {
        this.result = null;
        this.last_phase_done = false;
    }

    private void checkState() {
        if (this.result == null || !this.last_phase_done) {
            throw new IllegalStateException("Not finished");
        }
    }
}

