/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.params;

import java.math.BigInteger;

class DERWriter {
    static final int UNIVERSAL = 1;
    static final int APPLICATION = 2;
    static final int CONTEXT_SPECIFIC = 3;
    static final int PRIVATE = 4;

    public byte[] writeBigInteger(BigInteger bigInteger) {
        return this.writePrimitive(2, 1, (int)Math.ceil((double)bigInteger.bitLength() / 8.0), bigInteger.toByteArray());
    }

    private byte[] writePrimitive(int n, int n2, int n3, byte[] byArray) {
        return this.joinarrays(this.generateIdentifier(n, n2), this.generateLength(n3), byArray);
    }

    public byte[] joinarrays(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public byte[] joinarrays(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        return byArray4;
    }

    private byte[] generateIdentifier(int n, int n2) {
        if (n > 31) {
            int n3 = (int)(Math.log(n) / Math.log(256.0));
            byte[] byArray = new byte[n3 + 1];
            byArray[0] = this.translateLeadIdentifierByte(n2) | 0x1F;
            int n4 = 1;
            while (n4 < n3 + 1) {
                byArray[n4] = (byte)(n >> (7 * (n3 - n4) & 0x1F)) & 0x7F;
                int n5 = n4++;
                byArray[n5] = byArray[n5] | 0xFFFFFF80;
            }
            int n6 = n4 - 1;
            byArray[n6] = byArray[n6] ^ 0xFFFFFF80;
            return byArray;
        }
        byte[] byArray = new byte[]{(this.translateLeadIdentifierByte(n2) | (byte)n & 0x1F) & 0xFFFFFFDF};
        return byArray;
    }

    private byte translateLeadIdentifierByte(int n) {
        if (n == 1) {
            return 63;
        }
        if (n == 2) {
            return 127;
        }
        if (n == 3) {
            return -65;
        }
        return -64;
    }

    private byte[] generateLength(int n) {
        if (n > 127) {
            int n2 = (int)Math.ceil(Math.log(n) / Math.log(256.0));
            byte[] byArray = new byte[n2 + 1];
            byArray[0] = (byte)n2 | 0xFFFFFF80;
            for (int i = 1; i < n2 + 1; ++i) {
                byArray[i] = (byte)(n >>> (8 * (n2 - i) & 0x1F));
            }
            return byArray;
        }
        byte[] byArray = new byte[]{(byte)n & 0x7F};
        return byArray;
    }
}

