/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGenerator {
    private static final String SERVICE = "KeyGenerator";
    private KeyGeneratorSpi kgSpi;
    private Provider provider;
    private String algorithm;

    protected KeyGenerator(KeyGeneratorSpi keyGeneratorSpi, Provider provider, String string) {
        this.kgSpi = keyGeneratorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static final KeyGenerator getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        String string2 = string;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return KeyGenerator.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                string2 = noSuchAlgorithmException.getMessage();
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string2);
    }

    public static final KeyGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return KeyGenerator.getInstance(string, provider);
    }

    public static final KeyGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        try {
            KeyGenerator keyGenerator = new KeyGenerator((KeyGeneratorSpi)Engine.getInstance(SERVICE, string, provider), provider, string);
            keyGenerator.init(new SecureRandom());
            return keyGenerator;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() == null) {
                throw new NoSuchAlgorithmException(string);
            }
            if (invocationTargetException.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)invocationTargetException.getCause();
            }
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final SecretKey generateKey() {
        return this.kgSpi.engineGenerateKey();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.init(algorithmParameterSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.kgSpi.engineInit(algorithmParameterSpec, secureRandom);
    }

    public final void init(int n) {
        this.init(n, new SecureRandom());
    }

    public final void init(int n, SecureRandom secureRandom) {
        this.kgSpi.engineInit(n, secureRandom);
    }

    public final void init(SecureRandom secureRandom) {
        this.kgSpi.engineInit(secureRandom);
    }
}

