/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class RETokenPOSIX
extends REToken {
    int type;
    boolean insens;
    boolean negated;
    static final int ALNUM = 0;
    static final int ALPHA = 1;
    static final int BLANK = 2;
    static final int CNTRL = 3;
    static final int DIGIT = 4;
    static final int GRAPH = 5;
    static final int LOWER = 6;
    static final int PRINT = 7;
    static final int PUNCT = 8;
    static final int SPACE = 9;
    static final int UPPER = 10;
    static final int XDIGIT = 11;
    static final String[] s_nameTable = new String[]{"alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit"};

    static int intValue(String key) {
        int i = 0;
        while (i < s_nameTable.length) {
            if (s_nameTable[i].equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    RETokenPOSIX(int subIndex, int type, boolean insens, boolean negated) {
        super(subIndex);
        this.type = type;
        this.insens = insens;
        this.negated = negated;
    }

    int getMinimumLength() {
        return 1;
    }

    int getMaximumLength() {
        return 1;
    }

    REMatch matchThis(CharIndexed input, REMatch mymatch) {
        char ch = input.charAt(mymatch.index);
        boolean retval = this.matchOneChar(ch);
        if (retval) {
            ++mymatch.index;
            return mymatch;
        }
        return null;
    }

    boolean matchOneChar(char ch) {
        if (ch == '\uffff') {
            return false;
        }
        boolean retval = false;
        switch (this.type) {
            case 0: {
                retval = Character.isLetterOrDigit(ch) || ch == '_';
                break;
            }
            case 1: {
                retval = Character.isLetter(ch);
                break;
            }
            case 2: {
                retval = ch == ' ' || ch == '\t';
                break;
            }
            case 3: {
                retval = Character.isISOControl(ch);
                break;
            }
            case 4: {
                retval = Character.isDigit(ch);
                break;
            }
            case 5: {
                retval = !Character.isWhitespace(ch) && !Character.isISOControl(ch);
                break;
            }
            case 6: {
                retval = this.insens && Character.isLetter(ch) || Character.isLowerCase(ch);
                break;
            }
            case 7: {
                retval = !Character.isWhitespace(ch) && !Character.isISOControl(ch) || ch == ' ';
                break;
            }
            case 8: {
                retval = "`~!@#$%^&*()-_=+[]{}\\|;:'\"/?,.<>".indexOf(ch) != -1;
                break;
            }
            case 9: {
                retval = Character.isWhitespace(ch);
                break;
            }
            case 10: {
                retval = this.insens && Character.isLetter(ch) || Character.isUpperCase(ch);
                break;
            }
            case 11: {
                boolean bl = retval = Character.isDigit(ch) || "abcdefABCDEF".indexOf(ch) != -1;
            }
        }
        if (this.negated) {
            retval = !retval;
        }
        return retval;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        char ch;
        int numRepeats;
        int index = mymatch.index;
        for (numRepeats = 0; numRepeats < max && this.matchOneChar(ch = input.charAt(index++)); ++numRepeats) {
        }
        return numRepeats;
    }

    void dump(CPStringBuilder os) {
        if (this.negated) {
            os.append('^');
        }
        os.append("[:" + s_nameTable[this.type] + ":]");
    }
}

