/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Event;
import java.awt.MenuComponent;
import java.util.EventObject;

public abstract class AWTEvent
extends EventObject {
    private static final long serialVersionUID = -1825314779160409405L;
    protected int id;
    protected boolean consumed;
    transient AWTEvent queueNext;
    byte[] bdata;
    boolean isFocusManagerEvent = false;
    public static final long COMPONENT_EVENT_MASK = 1L;
    public static final long CONTAINER_EVENT_MASK = 2L;
    public static final long FOCUS_EVENT_MASK = 4L;
    public static final long KEY_EVENT_MASK = 8L;
    public static final long MOUSE_EVENT_MASK = 16L;
    public static final long MOUSE_MOTION_EVENT_MASK = 32L;
    public static final long WINDOW_EVENT_MASK = 64L;
    public static final long ACTION_EVENT_MASK = 128L;
    public static final long ADJUSTMENT_EVENT_MASK = 256L;
    public static final long ITEM_EVENT_MASK = 512L;
    public static final long TEXT_EVENT_MASK = 1024L;
    public static final long INPUT_METHOD_EVENT_MASK = 2048L;
    static final long INPUT_ENABLED_EVENT_MASK = 4096L;
    public static final long PAINT_EVENT_MASK = 8192L;
    public static final long INVOCATION_EVENT_MASK = 16384L;
    public static final long HIERARCHY_EVENT_MASK = 32768L;
    public static final long HIERARCHY_BOUNDS_EVENT_MASK = 65536L;
    public static final long MOUSE_WHEEL_EVENT_MASK = 131072L;
    public static final long WINDOW_STATE_EVENT_MASK = 262144L;
    public static final long WINDOW_FOCUS_EVENT_MASK = 524288L;
    public static final int RESERVED_ID_MAX = 1999;

    public AWTEvent(Event event) {
        this(event.target, event.id);
        this.consumed = event.consumed;
    }

    public AWTEvent(Object source, int id) {
        super(source);
        this.id = id;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public int getID() {
        return this.id;
    }

    public String toString() {
        String src = this.source instanceof Component ? ((Component)this.source).getName() : (this.source instanceof MenuComponent ? ((MenuComponent)this.source).getName() : (this.source != null ? this.source.toString() : "null"));
        String string = String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "] on " + src;
        return string;
    }

    public String paramString() {
        return "";
    }

    protected void consume() {
        this.consumed = true;
    }

    protected boolean isConsumed() {
        return this.consumed;
    }

    static long eventIdToMask(int id) {
        long mask = 0L;
        switch (id) {
            case 1001: {
                mask = 128L;
                break;
            }
            case 601: {
                mask = 256L;
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                mask = 1L;
                break;
            }
            case 300: 
            case 301: {
                mask = 2L;
                break;
            }
            case 1004: 
            case 1005: {
                mask = 4L;
                break;
            }
            case 1100: 
            case 1101: {
                mask = 2048L;
                break;
            }
            case 1200: {
                mask = 16384L;
                break;
            }
            case 701: {
                mask = 512L;
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                mask = 8L;
                break;
            }
            case 500: 
            case 501: 
            case 502: {
                mask = 16L;
                break;
            }
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                mask = 32L;
                break;
            }
            case 507: {
                mask = 131072L;
                break;
            }
            case 800: 
            case 801: {
                mask = 8192L;
                break;
            }
            case 900: {
                mask = 1024L;
                break;
            }
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                mask = 64L;
                break;
            }
            case 207: 
            case 208: {
                mask = 524288L;
                break;
            }
            case 209: {
                mask = 262144L;
                break;
            }
            default: {
                mask = 0L;
            }
        }
        return mask;
    }
}

