/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    private RenderingHints hints;
    private ICC_Profile[] profiles = null;
    private ColorSpace[] spaces;

    public ColorConvertOp(ColorSpace cspace, RenderingHints hints) {
        if (cspace == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{cspace};
        this.hints = hints;
    }

    public ColorConvertOp(ColorSpace srcCspace, ColorSpace dstCspace, RenderingHints hints) {
        if (srcCspace == null || dstCspace == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{srcCspace, dstCspace};
        this.hints = hints;
    }

    public ColorConvertOp(ICC_Profile[] profiles, RenderingHints hints) {
        if (profiles == null) {
            throw new NullPointerException();
        }
        this.hints = hints;
        this.profiles = profiles;
        this.spaces = new ColorSpace[profiles.length];
        int i = 0;
        while (i < profiles.length) {
            this.spaces[i] = new ICC_ColorSpace(profiles[i]);
            ++i;
        }
    }

    public ColorConvertOp(RenderingHints hints) {
        this.hints = hints;
        this.spaces = new ColorSpace[0];
    }

    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        BufferedImage tmp;
        if (dst == null && this.spaces.length == 0) {
            throw new IllegalArgumentException("Not enough color space information to complete conversion.");
        }
        if (dst != null && (src.getHeight() != dst.getHeight() || src.getWidth() != dst.getWidth())) {
            throw new IllegalArgumentException("Source and destination images have different dimensions");
        }
        if (src.isAlphaPremultiplied()) {
            tmp = this.createCompatibleDestImage(src, src.getColorModel());
            this.copyimage(src, tmp);
            tmp.coerceData(false);
            src = tmp;
        }
        int i = 0;
        while (i < this.spaces.length) {
            if (src.getColorModel().getColorSpace().getType() != this.spaces[i].getType()) {
                tmp = this.createCompatibleDestImage(src, this.createCompatibleColorModel(src, this.spaces[i]));
                this.copyimage(src, tmp);
                src = tmp;
            }
            ++i;
        }
        if (dst == null) {
            dst = src;
        } else {
            this.copyimage(src, dst);
        }
        return dst;
    }

    public final WritableRaster filter(Raster src, WritableRaster dest) {
        if (this.spaces.length < 2) {
            throw new IllegalArgumentException("Not enough information about source and destination colorspaces.");
        }
        if (this.spaces[0].getNumComponents() != src.getNumBands() || dest != null && this.spaces[this.spaces.length - 1].getNumComponents() != dest.getNumBands()) {
            throw new IllegalArgumentException("Source or destination raster contains the wrong number of bands.");
        }
        if (dest != null && (src.getHeight() != dest.getHeight() || src.getWidth() != dest.getWidth())) {
            throw new IllegalArgumentException("Source and destination rasters have different dimensions");
        }
        int i = 0;
        while (i < this.spaces.length - 2) {
            WritableRaster tmp = this.createCompatibleDestRaster(src, this.spaces[i + 1], false, src.getTransferType());
            this.copyraster(src, this.spaces[i], tmp, this.spaces[i + 1]);
            src = tmp;
            ++i;
        }
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src, this.spaces[this.spaces.length - 1], false, 0);
        }
        this.copyraster(src, this.spaces[this.spaces.length - 2], dest, this.spaces[this.spaces.length - 1]);
        return dest;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM == null && this.spaces.length == 0) {
            throw new IllegalArgumentException("Don't know the destination colormodel");
        }
        if (dstCM == null) {
            dstCM = this.createCompatibleColorModel(src, this.spaces[this.spaces.length - 1]);
        }
        return new BufferedImage(dstCM, this.createCompatibleDestRaster(src.getRaster(), dstCM.getColorSpace(), src.getColorModel().hasAlpha, dstCM.getTransferType()), src.isPremultiplied, null);
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        if (this.spaces.length < 2) {
            throw new IllegalArgumentException("Not enough destination colorspace information");
        }
        return this.createCompatibleDestRaster(src, this.spaces[this.spaces.length - 1], false, 0);
    }

    public final ICC_Profile[] getICC_Profiles() {
        return this.profiles;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            return (Point2D)src.clone();
        }
        dst.setLocation(src);
        return dst;
    }

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    private void copyimage(BufferedImage src, BufferedImage dst) {
        Graphics2D gg = dst.createGraphics();
        if (this.hints != null) {
            gg.setRenderingHints(this.hints);
        }
        gg.drawImage((Image)src, 0, 0, null);
        gg.dispose();
    }

    private void copyraster(Raster src, ColorSpace scs, WritableRaster dst, ColorSpace dcs) {
        float[] sbuf = new float[src.getNumBands()];
        if (this.hints != null && this.hints.get(RenderingHints.KEY_COLOR_RENDERING) == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
            int y = src.getMinY();
            while (y < src.getHeight() + src.getMinY()) {
                int x = src.getMinX();
                while (x < src.getWidth() + src.getMinX()) {
                    dst.setPixel(x, y, dcs.fromCIEXYZ(scs.toCIEXYZ(src.getPixel(x, y, sbuf))));
                    ++x;
                }
                ++y;
            }
        } else {
            int y = src.getMinY();
            while (y < src.getHeight() + src.getMinY()) {
                int x = src.getMinX();
                while (x < src.getWidth() + src.getMinX()) {
                    dst.setPixel(x, y, dcs.fromRGB(scs.toRGB(src.getPixel(x, y, sbuf))));
                    ++x;
                }
                ++y;
            }
        }
    }

    private ColorModel createCompatibleColorModel(BufferedImage img, ColorSpace cs) {
        return new ComponentColorModel(cs, img.getColorModel().hasAlpha(), img.isAlphaPremultiplied(), img.getColorModel().getTransparency(), 0);
    }

    private WritableRaster createCompatibleDestRaster(Raster src, ColorSpace cs, boolean hasAlpha, int transferType) {
        int numComponents = cs.getNumComponents();
        if (hasAlpha) {
            ++numComponents;
        }
        int[] offsets = new int[numComponents];
        int i = 0;
        while (i < offsets.length) {
            offsets[i] = i;
            ++i;
        }
        DataBuffer db = Buffers.createBuffer(transferType, src.getWidth() * src.getHeight() * numComponents, 1);
        return new WritableRaster(new PixelInterleavedSampleModel(transferType, src.getWidth(), src.getHeight(), numComponents, numComponents * src.getWidth(), offsets), db, new Point(src.getMinX(), src.getMinY()));
    }
}

