/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.lang.CPStringBuilder;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    byte[] buf = new byte[8];

    public DataInputStream(InputStream in) {
        super(in);
    }

    public final int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public final boolean readBoolean() throws IOException {
        return DataInputStream.convertToBoolean(this.in.read());
    }

    public final byte readByte() throws IOException {
        return DataInputStream.convertToByte(this.in.read());
    }

    public final char readChar() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToChar(this.buf);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    /*
     * Unable to fully structure code
     */
    public final void readFully(byte[] buf, int offset, int len) throws IOException {
        if (len >= 0) ** GOTO lbl8
        throw new IndexOutOfBoundsException("Negative length: " + len);
lbl-1000:
        // 1 sources

        {
            numread = this.in.read(buf, offset, len);
            if (numread < 0) {
                throw new EOFException();
            }
            len -= numread;
            offset += numread;
lbl8:
            // 2 sources

            ** while (len > 0)
        }
lbl9:
        // 1 sources

    }

    public final int readInt() throws IOException {
        this.readFully(this.buf, 0, 4);
        return DataInputStream.convertToInt(this.buf);
    }

    public final String readLine() throws IOException {
        CPStringBuilder strb = new CPStringBuilder();
        while (true) {
            int c;
            if ((c = this.in.read()) == -1) {
                return strb.length() > 0 ? strb.toString() : null;
            }
            if (c == 13) {
                int next_c = this.in.read();
                if (next_c == 10 || next_c == -1) break;
                if (!(this.in instanceof PushbackInputStream)) {
                    this.in = new PushbackInputStream(this.in);
                }
                ((PushbackInputStream)this.in).unread(next_c);
                break;
            }
            if (c == 10) break;
            strb.append((char)c);
        }
        return strb.length() > 0 ? strb.toString() : "";
    }

    public final long readLong() throws IOException {
        this.readFully(this.buf, 0, 8);
        return DataInputStream.convertToLong(this.buf);
    }

    public final short readShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToShort(this.buf);
    }

    public final int readUnsignedByte() throws IOException {
        return DataInputStream.convertToUnsignedByte(this.in.read());
    }

    public final int readUnsignedShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToUnsignedShort(this.buf);
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput in) throws IOException {
        int UTFlen = in.readUnsignedShort();
        return DataInputStream.readUTF(in, UTFlen);
    }

    final String readUTFLong() throws IOException {
        long l = this.readLong();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("The string length > Integer.MAX_VALUE");
        }
        int UTFlen = (int)l;
        return DataInputStream.readUTF(this, UTFlen);
    }

    private static final String readUTF(DataInput in, int len) throws IOException {
        byte[] buf = new byte[len];
        in.readFully(buf, 0, len);
        return DataInputStream.convertFromUTF(buf);
    }

    public final int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        try {
            return (int)this.in.skip(n);
        }
        catch (EOFException eOFException) {
            return n;
        }
    }

    static boolean convertToBoolean(int b) throws EOFException {
        if (b < 0) {
            throw new EOFException();
        }
        return b != 0;
    }

    static byte convertToByte(int i) throws EOFException {
        if (i < 0) {
            throw new EOFException();
        }
        return (byte)i;
    }

    static int convertToUnsignedByte(int i) throws EOFException {
        if (i < 0) {
            throw new EOFException();
        }
        return i & 0xFF;
    }

    static char convertToChar(byte[] buf) {
        return (char)(buf[0] << 8 | buf[1] & 0xFF);
    }

    static short convertToShort(byte[] buf) {
        return (short)(buf[0] << 8 | buf[1] & 0xFF);
    }

    static int convertToUnsignedShort(byte[] buf) {
        return (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
    }

    static int convertToInt(byte[] buf) {
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    static long convertToLong(byte[] buf) {
        return (long)(buf[0] & 0xFF) << 56 | (long)(buf[1] & 0xFF) << 48 | (long)(buf[2] & 0xFF) << 40 | (long)(buf[3] & 0xFF) << 32 | (long)(buf[4] & 0xFF) << 24 | (long)(buf[5] & 0xFF) << 16 | (long)(buf[6] & 0xFF) << 8 | (long)(buf[7] & 0xFF);
    }

    static String convertFromUTF(byte[] buf) throws EOFException, UTFDataFormatException {
        CPStringBuilder strbuf = new CPStringBuilder(buf.length / 2 + 2);
        int i = 0;
        while (i < buf.length) {
            if ((buf[i] & 0x80) == 0) {
                strbuf.append((char)(buf[i++] & 0xFF));
                continue;
            }
            if ((buf[i] & 0xE0) == 192) {
                if (i + 1 >= buf.length || (buf[i + 1] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                strbuf.append((char)((buf[i++] & 0x1F) << 6 | buf[i++] & 0x3F));
                continue;
            }
            if ((buf[i] & 0xF0) == 224) {
                if (i + 2 >= buf.length || (buf[i + 1] & 0xC0) != 128 || (buf[i + 2] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                strbuf.append((char)((buf[i++] & 0xF) << 12 | (buf[i++] & 0x3F) << 6 | buf[i++] & 0x3F));
                continue;
            }
            throw new UTFDataFormatException();
        }
        return strbuf.toString();
    }
}

