/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.UnknownHostException;
import java.net.VMInetAddress;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

class ResolverCache {
    private static final int POSITIVE_TTL = ResolverCache.getTTL("networkaddress.cache.ttl", -1);
    private static final int NEGATIVE_TTL = ResolverCache.getTTL("networkaddress.cache.negative.ttl", 10);
    private static HashMap<Object, Entry> cache = new HashMap();
    private static LinkedList<Entry> killqueue = new LinkedList();

    ResolverCache() {
    }

    private static int getTTL(String propName, int defaultValue) {
        String propValue = Security.getProperty(propName);
        if (propValue == null) {
            return defaultValue;
        }
        return Integer.parseInt(propValue);
    }

    public static String getHostByAddr(byte[] addr) throws UnknownHostException {
        Object key = ResolverCache.makeHashableAddress(addr);
        Entry entry = ResolverCache.get(key);
        if (entry != null) {
            if (entry.value == null) {
                throw new UnknownHostException();
            }
            return (String)entry.value;
        }
        try {
            String hostname = VMInetAddress.getHostByAddr(addr);
            ResolverCache.put(new Entry(key, hostname));
            return hostname;
        }
        catch (UnknownHostException e) {
            ResolverCache.put(new Entry(key, null));
            throw e;
        }
    }

    public static byte[][] getHostByName(String hostname) throws UnknownHostException {
        Entry entry = ResolverCache.get(hostname);
        if (entry != null) {
            if (entry.value == null) {
                throw new UnknownHostException();
            }
            return (byte[][])entry.value;
        }
        try {
            byte[][] addrs = VMInetAddress.getHostByName(hostname);
            ResolverCache.put(new Entry(hostname, addrs));
            return addrs;
        }
        catch (UnknownHostException e) {
            ResolverCache.put(new Entry(hostname, null));
            throw e;
        }
    }

    private static Object makeHashableAddress(byte[] addr) {
        char[] chars = new char[addr.length];
        int i = 0;
        while (i < addr.length) {
            chars[i] = (char)addr[i];
            ++i;
        }
        return new String(chars);
    }

    private static synchronized Entry get(Object key) {
        ResolverCache.reap();
        return cache.get(key);
    }

    private static synchronized void put(Entry entry) {
        ResolverCache.reap();
        if (entry.expires != 0L) {
            if (entry.expires != -1L) {
                killqueue.add(entry);
            }
            cache.put(entry.key, entry);
        }
    }

    private static void reap() {
        if (!killqueue.isEmpty()) {
            long now = System.currentTimeMillis();
            Iterator iter = killqueue.iterator();
            while (iter.hasNext()) {
                Entry entry = (Entry)iter.next();
                if (entry.expires > now) break;
                cache.remove(entry.key);
                iter.remove();
            }
        }
    }

    private static class Entry {
        public final Object key;
        public final Object value;
        public final long expires;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
            int ttl = value != null ? POSITIVE_TTL : NEGATIVE_TTL;
            this.expires = ttl < 1 ? (long)ttl : System.currentTimeMillis() + (long)(ttl * 1000);
        }
    }
}

