/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.beans.Beans;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.activation.CommandObject;
import javax.activation.DataHandler;

public class CommandInfo {
    private final String verb;
    private final String className;

    public CommandInfo(String verb, String className) {
        this.verb = verb;
        this.className = className;
    }

    public String getCommandName() {
        return this.verb;
    }

    public String getCommandClass() {
        return this.className;
    }

    public Object getCommandObject(DataHandler dh, ClassLoader loader) throws IOException, ClassNotFoundException {
        Object object = Beans.instantiate(loader, this.className);
        if (object != null) {
            InputStream in;
            if (object instanceof CommandObject) {
                CommandObject command = (CommandObject)object;
                command.setCommandContext(this.verb, dh);
            } else if (dh != null && object instanceof Externalizable && (in = dh.getInputStream()) != null) {
                Externalizable externalizable = (Externalizable)object;
                externalizable.readExternal(new ObjectInputStream(in));
            }
        }
        return object;
    }
}

