/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import gnu.java.lang.CPStringBuilder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private final List<String> parameterNames = new ArrayList<String>();
    private final Map<String, String> parameterValues = new HashMap<String, String>();

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String parameterList) throws MimeTypeParseException {
        this();
        this.parse(parameterList);
    }

    protected void parse(String parameterList) throws MimeTypeParseException {
        if (parameterList == null) {
            return;
        }
        char[] chars = parameterList.toCharArray();
        int len = chars.length;
        boolean inQuotedString = false;
        CPStringBuilder buffer = new CPStringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        int i = 0;
        while (i < len) {
            char c = chars[i];
            if (c == ';' && !inQuotedString) {
                String param = buffer.toString().trim();
                if (param.length() > 0) {
                    params.add(param);
                }
                buffer.setLength(0);
            } else {
                if (c == '\"') {
                    inQuotedString = !inQuotedString;
                }
                buffer.append(c);
            }
            ++i;
        }
        String param2 = buffer.toString().trim();
        if (param2.length() > 0) {
            params.add(param2);
        }
        for (String param2 : params) {
            int ei = param2.indexOf(61);
            if (ei == -1) {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            String name = param2.substring(0, ei).trim();
            MimeType.checkValidity(name, "Parameter name is invalid");
            String value = param2.substring(ei + 1).trim();
            len = value.length();
            if (len > 1 && value.charAt(0) == '\"' && value.charAt(len - 1) == '\"') {
                value = MimeTypeParameterList.unquote(value);
            } else {
                MimeType.checkValidity(name, "Parameter value is invalid");
            }
            this.parameterNames.add(name);
            this.parameterValues.put(name.toLowerCase(), value);
        }
    }

    public synchronized int size() {
        return this.parameterNames.size();
    }

    public synchronized boolean isEmpty() {
        return this.parameterNames.isEmpty();
    }

    public synchronized String get(String name) {
        name = name.trim();
        return this.parameterValues.get(name.toLowerCase());
    }

    public synchronized void set(String name, String value) {
        name = name.trim();
        boolean exists = false;
        for (String pname : this.parameterNames) {
            if (!name.equalsIgnoreCase(pname)) continue;
            exists = true;
        }
        if (!exists) {
            this.parameterNames.add(name);
        }
        this.parameterValues.put(name.toLowerCase(), value);
    }

    public synchronized void remove(String name) {
        name = name.trim();
        Iterator<String> i = this.parameterNames.iterator();
        while (i.hasNext()) {
            String pname = i.next();
            if (!name.equalsIgnoreCase(pname)) continue;
            i.remove();
        }
        this.parameterValues.remove(name.toLowerCase());
    }

    public synchronized Enumeration getNames() {
        return new IteratorEnumeration(this.parameterNames.iterator());
    }

    public synchronized String toString() {
        CPStringBuilder buffer = new CPStringBuilder();
        for (String name : this.parameterNames) {
            String value = this.parameterValues.get(name.toLowerCase());
            buffer.append(';');
            buffer.append(' ');
            buffer.append(name);
            buffer.append('=');
            buffer.append(MimeTypeParameterList.quote(value));
        }
        return buffer.toString();
    }

    private static String quote(String value) {
        boolean needsQuoting = false;
        int len = value.length();
        int i = 0;
        while (i < len) {
            if (!MimeType.isValidChar(value.charAt(i))) {
                needsQuoting = true;
                break;
            }
            ++i;
        }
        if (needsQuoting) {
            CPStringBuilder buffer = new CPStringBuilder();
            buffer.append('\"');
            int i2 = 0;
            while (i2 < len) {
                char c = value.charAt(i2);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
                ++i2;
            }
            buffer.append('\"');
            return buffer.toString();
        }
        return value;
    }

    private static String unquote(String value) {
        int len = value.length();
        CPStringBuilder buffer = new CPStringBuilder();
        int i = 1;
        while (i < len - 1) {
            char c = value.charAt(i);
            if (c == '\\' && ++i < len - 1 && (c = value.charAt(i)) != '\\' && c != '\"') {
                buffer.append('\\');
            }
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IteratorEnumeration
    implements Enumeration<String> {
        final Iterator<String> iterator;

        IteratorEnumeration(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }
}

