/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private static final int RC2_IV_LENGTH = 8;
    private int effectiveKeyBits;
    private byte[] iv;

    public RC2ParameterSpec(int effectiveKeyBits) {
        this.effectiveKeyBits = effectiveKeyBits;
    }

    public RC2ParameterSpec(int effectiveKeyBits, byte[] iv) {
        this(effectiveKeyBits, iv, 0);
    }

    public RC2ParameterSpec(int effectiveKeyBits, byte[] iv, int offset) {
        if (iv.length - offset < 8) {
            throw new IllegalArgumentException("IV too short");
        }
        this.effectiveKeyBits = effectiveKeyBits;
        this.iv = new byte[8];
        System.arraycopy(iv, offset, this.iv, 0, 8);
    }

    public int getEffectiveKeyBits() {
        return this.effectiveKeyBits;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        byte[] oiv = ((RC2ParameterSpec)o).getIV();
        if (this.iv != oiv) {
            if (this.iv == null || oiv == null) {
                return false;
            }
            if (this.iv.length != oiv.length) {
                return false;
            }
            int i = 0;
            while (i < this.iv.length) {
                if (this.iv[i] != oiv[i]) {
                    return false;
                }
                ++i;
            }
        }
        return this.effectiveKeyBits == ((RC2ParameterSpec)o).getEffectiveKeyBits();
    }

    public int hashCode() {
        int code = this.effectiveKeyBits;
        if (this.iv != null) {
            int i = 0;
            while (i < 8) {
                code += this.iv[i];
                ++i;
            }
        }
        return code;
    }
}

