/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.util.EventObject;
import javax.swing.tree.TreePath;

public class TreeSelectionEvent
extends EventObject {
    protected TreePath[] paths;
    protected boolean[] areNew;
    protected TreePath oldLeadSelectionPath;
    protected TreePath newLeadSelectionPath;

    public TreeSelectionEvent(Object source, TreePath[] paths, boolean[] areNew, TreePath oldLeadSelectionPath, TreePath newLeadSelectionPath) {
        super(source);
        this.paths = paths;
        this.areNew = areNew;
        this.oldLeadSelectionPath = oldLeadSelectionPath;
        this.newLeadSelectionPath = newLeadSelectionPath;
    }

    public TreeSelectionEvent(Object source, TreePath path, boolean isNew, TreePath oldLeadSelectionPath, TreePath newLeadSelectionPath) {
        super(source);
        this.paths = new TreePath[]{path};
        this.areNew = new boolean[]{isNew};
        this.oldLeadSelectionPath = oldLeadSelectionPath;
        this.newLeadSelectionPath = newLeadSelectionPath;
    }

    public TreePath getPath() {
        return this.paths[0];
    }

    public TreePath[] getPaths() {
        return (TreePath[])this.paths.clone();
    }

    public boolean isAddedPath() {
        return this.areNew[0];
    }

    public boolean isAddedPath(TreePath path) {
        int i = this.paths.length - 1;
        while (i >= 0) {
            if (this.paths[i].equals(path)) {
                return this.areNew[i];
            }
            --i;
        }
        throw new IllegalArgumentException("Unknown 'path' argument.");
    }

    public boolean isAddedPath(int index) {
        return this.areNew[index];
    }

    public TreePath getOldLeadSelectionPath() {
        return this.oldLeadSelectionPath;
    }

    public TreePath getNewLeadSelectionPath() {
        return this.newLeadSelectionPath;
    }

    public Object cloneWithSource(Object source) {
        return new TreeSelectionEvent(source, this.paths, this.areNew, this.oldLeadSelectionPath, this.newLeadSelectionPath);
    }
}

