/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalComboBoxEditor
extends BasicComboBoxEditor {
    protected static Insets editorBorderInsets = new Insets(2, 2, 2, 0);

    public MetalComboBoxEditor() {
        this.editor = new EditorTextField("", 9);
        this.editor.setBorder(new MetalComboBoxEditorBorder());
    }

    private class EditorTextField
    extends JTextField {
        EditorTextField(String s, int columns) {
            super(s, columns);
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height += 4;
            return size;
        }

        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.height += 4;
            return size;
        }
    }

    static class MetalComboBoxEditorBorder
    extends AbstractBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, 0, 0, h - 1);
                g.drawLine(0, h - 1, w - 1, h - 1);
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawLine(1, 1, w - 2, 1);
                g.drawLine(1, 1, 1, h - 2);
                g.drawLine(1, h - 2, w - 1, h - 2);
                g.drawLine(w - 1, 1, w - 1, h - 2);
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, 0, 0, h - 2);
                g.drawLine(0, h - 2, w - 1, h - 2);
                g.setColor(MetalLookAndFeel.getControlHighlight());
                g.drawLine(1, 1, w - 1, 1);
                g.drawLine(1, 1, 1, h - 1);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.setColor(MetalLookAndFeel.getControl());
                g.drawLine(1, h - 2, 1, h - 2);
            }
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return editorBorderInsets;
        }
    }

    public static class UIResource
    extends MetalComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }
}

