/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeUtility;

public class InternetAddress
extends Address
implements Cloneable {
    protected String address;
    protected String personal;
    protected String encodedPersonal;
    private static final long serialVersionUID = -7507595530758302903L;
    private static final String rfc822phrase = "()<>@,;:\\\"\t .[]".replace(' ', '\u0000').replace('\t', '\u0000');
    private static final String specialsNoDotNoAt = "()<>,;:\\\"[]";
    private static final String specialsNoDot = "()<>,;:\\\"[]@";

    public InternetAddress() {
    }

    public InternetAddress(String string) throws AddressException {
        InternetAddress[] internetAddressArray = InternetAddress.parse(string, true);
        if (internetAddressArray.length != 1) {
            throw new AddressException("Illegal address", string);
        }
        this.address = internetAddressArray[0].address;
        this.personal = internetAddressArray[0].personal;
        this.encodedPersonal = internetAddressArray[0].encodedPersonal;
    }

    public InternetAddress(String string, boolean bl) throws AddressException {
        this(string);
        if (bl) {
            InternetAddress.checkAddress(this.address, true, true);
        }
    }

    public InternetAddress(String string, String string2) throws UnsupportedEncodingException {
        this(string, string2, null);
    }

    public InternetAddress(String string, String string2, String string3) throws UnsupportedEncodingException {
        this.address = string;
        this.setPersonal(string2, string3);
    }

    public Object clone() {
        InternetAddress internetAddress = null;
        try {
            internetAddress = (InternetAddress)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return internetAddress;
    }

    public String getType() {
        return "rfc822";
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setPersonal(String string, String string2) throws UnsupportedEncodingException {
        this.personal = string;
        if (string != null) {
            this.encodedPersonal = MimeUtility.encodeWord(string, string2, null);
            return;
        }
        this.encodedPersonal = null;
    }

    public void setPersonal(String string) throws UnsupportedEncodingException {
        this.personal = string;
        if (string != null) {
            this.encodedPersonal = MimeUtility.encodeWord(string);
            return;
        }
        this.encodedPersonal = null;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        if (this.personal != null) {
            return this.personal;
        }
        if (this.encodedPersonal != null) {
            try {
                this.personal = MimeUtility.decodeText(this.encodedPersonal);
                return this.personal;
            }
            catch (Exception exception) {
                return this.encodedPersonal;
            }
        }
        return null;
    }

    public String toString() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord(this.personal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (this.encodedPersonal != null) {
            return String.valueOf(InternetAddress.quotePhrase(this.encodedPersonal)) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    public String toUnicodeString() {
        String string = this.getPersonal();
        if (string != null) {
            return String.valueOf(InternetAddress.quotePhrase(string)) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    private static String quotePhrase(String string) {
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"' || c == '\\') {
                StringBuffer stringBuffer = new StringBuffer(n + 3);
                stringBuffer.append('\"');
                int n3 = 0;
                while (n3 < n) {
                    char c2 = string.charAt(n3);
                    if (c2 == '\"' || c2 == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                    ++n3;
                }
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            if (c < ' ' && c != '\r' && c != '\n' && c != '\t' || c >= '\u007f' || rfc822phrase.indexOf(c) >= 0) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(n + 2);
            stringBuffer.append('\"').append(string).append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    private static String unquote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && (string = string.substring(1, string.length() - 1)).indexOf(92) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\\' && n < string.length() - 1) {
                    c = string.charAt(++n);
                }
                stringBuffer.append(c);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InternetAddress)) {
            return false;
        }
        String string = ((InternetAddress)object).getAddress();
        if (string == this.address) {
            return true;
        }
        return this.address != null && this.address.equalsIgnoreCase(string);
    }

    public int hashCode() {
        if (this.address == null) {
            return 0;
        }
        return this.address.toLowerCase().hashCode();
    }

    public static String toString(Address[] addressArray) {
        return InternetAddress.toString(addressArray, 0);
    }

    public static String toString(Address[] addressArray, int n) {
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < addressArray.length) {
            String string;
            int n3;
            if (n2 != 0) {
                stringBuffer.append(", ");
                n += 2;
            }
            if (n + (n3 = InternetAddress.lengthOfFirstSegment(string = addressArray[n2].toString())) > 76) {
                stringBuffer.append("\r\n\t");
                n = 8;
            }
            stringBuffer.append(string);
            n = InternetAddress.lengthOfLastSegment(string, n);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static int lengthOfFirstSegment(String string) {
        int n = string.indexOf("\r\n");
        if (n != -1) {
            return n;
        }
        return string.length();
    }

    private static int lengthOfLastSegment(String string, int n) {
        int n2 = string.lastIndexOf("\r\n");
        if (n2 != -1) {
            return string.length() - n2 - 2;
        }
        return string.length() + n;
    }

    public static InternetAddress getLocalAddress(Session session) {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (session == null) {
                string = System.getProperty("user.name");
                string2 = InetAddress.getLocalHost().getHostName();
            } else {
                string3 = session.getProperty("mail.from");
                if (string3 == null) {
                    InetAddress inetAddress;
                    string = session.getProperty("mail.user");
                    if (string == null || string.length() == 0) {
                        string = session.getProperty("user.name");
                    }
                    if (string == null || string.length() == 0) {
                        string = System.getProperty("user.name");
                    }
                    if (((string2 = session.getProperty("mail.host")) == null || string2.length() == 0) && (inetAddress = InetAddress.getLocalHost()) != null) {
                        string2 = inetAddress.getHostName();
                    }
                }
            }
            if (string3 == null && string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
                string3 = String.valueOf(string) + "@" + string2;
            }
            if (string3 != null) {
                return new InternetAddress(string3);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (AddressException addressException) {
        }
        catch (UnknownHostException unknownHostException) {}
        return null;
    }

    public static InternetAddress[] parse(String string) throws AddressException {
        return InternetAddress.parse(string, true);
    }

    public static InternetAddress[] parse(String string, boolean bl) throws AddressException {
        return InternetAddress.parse(string, bl, false);
    }

    public static InternetAddress[] parseHeader(String string, boolean bl) throws AddressException {
        return InternetAddress.parse(string, bl, true);
    }

    /*
     * Unable to fully structure code
     */
    private static InternetAddress[] parse(String var0, boolean var1_1, boolean var2_2) throws AddressException {
        var7_3 = -1;
        var8_4 = -1;
        var9_5 = var0.length();
        var10_6 = false;
        var11_7 = false;
        var12_8 = false;
        var14_9 = new Vector<InternetAddress>();
        var4_10 = -1;
        var3_11 = -1;
        var5_12 = 0;
        while (var5_12 < var9_5) {
            var13_14 = var0.charAt(var5_12);
            switch (var13_14) {
                case '(': {
                    var12_8 = true;
                    if (var3_11 >= 0 && var4_10 == -1) {
                        var4_10 = var5_12;
                    }
                    if (var7_3 == -1) {
                        var7_3 = var5_12 + 1;
                    }
                    ++var5_12;
                    var6_13 = 1;
                    while (var5_12 < var9_5 && var6_13 > 0) {
                        var13_14 = var0.charAt(var5_12);
                        switch (var13_14) {
                            case '\\': {
                                ++var5_12;
                                break;
                            }
                            case '(': {
                                ++var6_13;
                                break;
                            }
                            case ')': {
                                --var6_13;
                                break;
                            }
                        }
                        ++var5_12;
                    }
                    if (var6_13 > 0) {
                        throw new AddressException("Missing ')'", var0, var5_12);
                    }
                    --var5_12;
                    if (var8_4 != -1) break;
                    var8_4 = var5_12;
                    break;
                }
                case ')': {
                    throw new AddressException("Missing '('", var0, var5_12);
                }
                case '<': {
                    var12_8 = true;
                    if (var11_7) {
                        throw new AddressException("Extra route-addr", var0, var5_12);
                    }
                    if (!var10_6) {
                        var7_3 = var3_11;
                        if (var7_3 >= 0) {
                            var8_4 = var5_12;
                        }
                        var3_11 = var5_12 + 1;
                    }
                    var16_16 = false;
                    ++var5_12;
                    block32: while (var5_12 < var9_5) {
                        var13_14 = var0.charAt(var5_12);
                        switch (var13_14) {
                            case '\\': {
                                ++var5_12;
                                ** GOTO lbl66
                            }
                            case '\"': {
                                var16_16 = var16_16 == false;
                                ** GOTO lbl66
                            }
                            case '>': {
                                if (!var16_16) break block32;
                            }
lbl66:
                            // 4 sources

                            default: {
                                ++var5_12;
                            }
                        }
                    }
                    if (var5_12 >= var9_5) {
                        if (var16_16) {
                            throw new AddressException("Missing '\"'", var0, var5_12);
                        }
                        throw new AddressException("Missing '>'", var0, var5_12);
                    }
                    var11_7 = true;
                    var4_10 = var5_12;
                    break;
                }
                case '>': {
                    throw new AddressException("Missing '<'", var0, var5_12);
                }
                case '\"': {
                    var12_8 = true;
                    if (var3_11 == -1) {
                        var3_11 = var5_12;
                    }
                    ++var5_12;
                    block33: while (var5_12 < var9_5) {
                        var13_14 = var0.charAt(var5_12);
                        switch (var13_14) {
                            case '\\': {
                                ++var5_12;
                            }
                            default: {
                                ++var5_12;
                                continue block33;
                            }
                            case '\"': {
                                break block33;
                            }
                        }
                    }
                    if (var5_12 < var9_5) break;
                    throw new AddressException("Missing '\"'", var0, var5_12);
                }
                case '[': {
                    var12_8 = true;
                    ++var5_12;
                    block34: while (var5_12 < var9_5) {
                        var13_14 = var0.charAt(var5_12);
                        switch (var13_14) {
                            case '\\': {
                                ++var5_12;
                            }
                            default: {
                                ++var5_12;
                                continue block34;
                            }
                            case ']': {
                                break block34;
                            }
                        }
                    }
                    if (var5_12 < var9_5) break;
                    throw new AddressException("Missing ']'", var0, var5_12);
                }
                case ',': {
                    if (var3_11 == -1) {
                        var11_7 = false;
                        var12_8 = false;
                        var4_10 = -1;
                        var3_11 = -1;
                        break;
                    }
                    if (var10_6) {
                        var11_7 = false;
                        break;
                    }
                    if (var4_10 == -1) {
                        var4_10 = var5_12;
                    }
                    var17_20 = var0.substring(var3_11, var4_10).trim();
                    if (var12_8 || var1_1 || var2_2) {
                        if (var1_1 || !var2_2) {
                            InternetAddress.checkAddress((String)var17_20, var11_7, false);
                        }
                        var15_15 = new InternetAddress();
                        var15_15.setAddress((String)var17_20);
                        if (var7_3 >= 0) {
                            var15_15.encodedPersonal = InternetAddress.unquote(var0.substring(var7_3, var8_4).trim());
                            var8_4 = -1;
                            var7_3 = -1;
                        }
                        var14_9.addElement(var15_15);
                    } else {
                        var18_21 = new StringTokenizer((String)var17_20);
                        while (var18_21.hasMoreTokens()) {
                            var19_22 = var18_21.nextToken();
                            InternetAddress.checkAddress(var19_22, false, false);
                            var15_15 = new InternetAddress();
                            var15_15.setAddress(var19_22);
                            var14_9.addElement(var15_15);
                        }
                    }
                    var11_7 = false;
                    var12_8 = false;
                    var4_10 = -1;
                    var3_11 = -1;
                    break;
                }
                case ':': {
                    var12_8 = true;
                    if (var10_6) {
                        throw new AddressException("Nested group", var0, var5_12);
                    }
                    var10_6 = true;
                    if (var3_11 != -1) break;
                    var3_11 = var5_12;
                    break;
                }
                case ';': {
                    if (var3_11 == -1) {
                        var3_11 = var5_12;
                    }
                    if (!var10_6) {
                        throw new AddressException("Illegal semicolon, not in group", var0, var5_12);
                    }
                    var10_6 = false;
                    if (var3_11 == -1) {
                        var3_11 = var5_12;
                    }
                    var15_15 = new InternetAddress();
                    var4_10 = var5_12 + 1;
                    var15_15.setAddress(var0.substring(var3_11, var4_10).trim());
                    var14_9.addElement(var15_15);
                    var11_7 = false;
                    var4_10 = -1;
                    var3_11 = -1;
                    break;
                }
                default: {
                    if (var3_11 != -1) break;
                    var3_11 = var5_12;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
            }
            ++var5_12;
        }
        if (var3_11 >= 0) {
            if (var4_10 == -1) {
                var4_10 = var5_12;
            }
            var16_17 = var0.substring(var3_11, var4_10).trim();
            if (var12_8 || var1_1 || var2_2) {
                if (var1_1 || !var2_2) {
                    InternetAddress.checkAddress(var16_17, var11_7, false);
                }
                var15_15 = new InternetAddress();
                var15_15.setAddress(var16_17);
                if (var7_3 >= 0) {
                    var15_15.encodedPersonal = InternetAddress.unquote(var0.substring(var7_3, var8_4).trim());
                }
                var14_9.addElement(var15_15);
            } else {
                var17_20 = new StringTokenizer(var16_17);
                while (var17_20.hasMoreTokens()) {
                    var18_21 = var17_20.nextToken();
                    InternetAddress.checkAddress((String)var18_21, false, false);
                    var15_15 = new InternetAddress();
                    var15_15.setAddress((String)var18_21);
                    var14_9.addElement(var15_15);
                }
            }
        }
        var16_19 = new InternetAddress[var14_9.size()];
        var14_9.copyInto(var16_19);
        return var16_19;
    }

    public void validate() throws AddressException {
        InternetAddress.checkAddress(this.getAddress(), true, true);
    }

    private static void checkAddress(String string, boolean bl, boolean bl2) throws AddressException {
        String string2;
        String string3;
        int n;
        int n2 = 0;
        if (string.indexOf(34) >= 0) {
            return;
        }
        if (bl) {
            n2 = 0;
            while ((n = InternetAddress.indexOfAny(string, ",:", n2)) >= 0) {
                if (string.charAt(n2) != '@') {
                    throw new AddressException("Illegal route-addr", string);
                }
                if (string.charAt(n) == ':') {
                    n2 = n + 1;
                    break;
                }
                n2 = n + 1;
            }
        }
        if ((n = string.indexOf(64, n2)) >= 0) {
            if (n == n2) {
                throw new AddressException("Missing local name", string);
            }
            if (n == string.length() - 1) {
                throw new AddressException("Missing domain", string);
            }
            string3 = string.substring(n2, n);
            string2 = string.substring(n + 1);
        } else {
            if (bl2) {
                throw new AddressException("Missing final '@domain'", string);
            }
            string3 = string;
            string2 = null;
        }
        if (InternetAddress.indexOfAny(string, " \t\n\r") >= 0) {
            throw new AddressException("Illegal whitespace in address", string);
        }
        if (InternetAddress.indexOfAny(string3, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in local name", string);
        }
        if (string2 != null && string2.indexOf(91) < 0 && InternetAddress.indexOfAny(string2, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in domain", string);
        }
    }

    private boolean isSimple() {
        return this.address == null || InternetAddress.indexOfAny(this.address, specialsNoDotNoAt) < 0;
    }

    public boolean isGroup() {
        return this.address != null && this.address.endsWith(";") && this.address.indexOf(58) > 0;
    }

    public InternetAddress[] getGroup(boolean bl) throws AddressException {
        String string = this.getAddress();
        if (!string.endsWith(";")) {
            return null;
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n + 1, string.length() - 1);
        return InternetAddress.parseHeader(string2, bl);
    }

    private static int indexOfAny(String string, String string2) {
        return InternetAddress.indexOfAny(string, string2, 0);
    }

    private static int indexOfAny(String string, String string2, int n) {
        try {
            int n2 = string.length();
            int n3 = n;
            while (n3 < n2) {
                if (string2.indexOf(string.charAt(n3)) >= 0) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }
}

