/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.code;

import java.io.File;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class CodeSwitch {
    private boolean recurse;
    private ArrayList list = new ArrayList();
    private ArrayList switchOn = new ArrayList();
    private ArrayList switchOff = new ArrayList();
    private ArrayList switches = new ArrayList();
    private byte[] file;
    private String endOfLine;
    private ArrayList lines;
    private boolean changed;

    public static void main(String[] argv) {
        new CodeSwitch().run(argv);
    }

    private void run(String[] a) {
        if (a.length == 0) {
            this.showUsage();
            return;
        }
        boolean path = false;
        this.recurse = true;
        for (int i = 0; i < a.length; ++i) {
            String p = a[i];
            if (p.startsWith("+")) {
                this.switchOn.add(p.substring(1));
                continue;
            }
            if (p.startsWith("-r+")) {
                this.recurse = true;
                continue;
            }
            if (p.startsWith("-r-")) {
                this.recurse = false;
                continue;
            }
            if (p.startsWith("-")) {
                this.switchOff.add(p.substring(1));
                continue;
            }
            this.addDir(p, true);
            path = true;
        }
        if (!path) {
            CodeSwitch.printError("no path specified");
            this.showUsage();
        }
        this.process();
        if (this.switchOff.size() == 0 && this.switchOn.size() == 0) {
            this.printSwitches();
        }
    }

    private void showUsage() {
        String className = this.getClass().getName();
        System.out.println("Usage: java " + className + " [-r+] [-r-] paths [+|-][labels]");
        System.out.println("If no labels are specified then all used");
        System.out.println("labels in the source code are shown.");
        System.out.println("-r+ recurse subdirectories (default)");
        System.out.println("-r- do not recurse subdirectories");
        System.out.println("Use +MODE to switch on the things labeld MODE");
        System.out.println("Use -MODE to switch off the things labeld MODE");
        System.out.println("Path: Any number of path or files may be specified.");
        System.out.println(" Use . for the current directory (including sub-directories).");
        System.out.println("Example: java " + className + " +JAVA2 .");
        System.out.println("This example switches on code labeled JAVA2 in all *.java files");
        System.out.println("in the current directory and all subdirectories.");
    }

    private void process() {
        int len = this.list.size();
        for (int i = 0; i < len; ++i) {
            String fileName = (String)this.list.get(i);
            if (this.processFile(fileName)) continue;
            System.out.println("in file " + this.file + " - this file is skipped");
        }
    }

    private void printSwitches() {
        System.out.println("Used labels:");
        for (int i = 0; i < this.switches.size(); ++i) {
            System.out.println((String)this.switches.get(i));
        }
    }

    private void addDir(String path, boolean recurseMore) {
        File f = new File(path);
        if (f.isFile() && path.endsWith(".java")) {
            this.list.add(path);
        } else if (f.isDirectory() && (this.recurse || recurseMore)) {
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                this.addDir(path + File.separatorChar + files[i], false);
            }
        }
    }

    private void breakIntoLines() {
        this.lines = new ArrayList();
        int len = this.file.length;
        int last = 0;
        int cr = 0;
        int lf = 0;
        int crlf = 0;
        for (int i = 0; i < len; ++i) {
            byte c = this.file[i];
            if (c != 13 && c != 10) continue;
            if (c == 13) {
                if (i < len - 1 && this.file[i + 1] == 10) {
                    ++i;
                    ++crlf;
                } else {
                    ++cr;
                }
            } else {
                ++lf;
            }
            if (i >= len) continue;
            this.lines.add(new String(this.file, last, i - last + 1));
            last = i + 1;
        }
        this.endOfLine = cr > lf && cr > crlf ? "\r" : (lf > crlf ? "\n" : "\r\n");
        this.lines.add(new String(this.file, last, len - last));
    }

    private String getLine(int line) {
        return (String)this.lines.get(line);
    }

    private void insertLine(int line, String s) {
        this.lines.add(line, s);
        this.changed = true;
    }

    private void removeLine(int line) {
        this.lines.remove(line);
        this.changed = true;
    }

    private boolean processFile(String name) {
        File f = new File(name);
        boolean switchoff = false;
        boolean working = false;
        int state = 0;
        try {
            long rawLen = f.length();
            if (rawLen > Integer.MAX_VALUE) {
                CodeSwitch.printError("Files bigger than Integer.MAX_VALUE are not supported");
                return false;
            }
            int len = (int)rawLen;
            this.file = new byte[len];
            RandomAccessFile read = new RandomAccessFile(f, "r");
            read.readFully(this.file);
            read.close();
            this.breakIntoLines();
            this.changed = false;
            for (int i = 0; i < this.lines.size(); ++i) {
                String line = this.getLine(i);
                String lineTrim = line.trim();
                if (working && (lineTrim.startsWith("/*") || lineTrim.startsWith("*/"))) {
                    this.removeLine(i);
                    --i;
                    continue;
                }
                if (!lineTrim.startsWith("//#")) continue;
                if (lineTrim.startsWith("//#ifdef ")) {
                    if (state != 0) {
                        CodeSwitch.printError("//#ifdef not allowed inside //#ifdef");
                        return false;
                    }
                    state = 1;
                    String s = lineTrim.substring(9);
                    boolean switchedOn = false;
                    boolean switchedOff = false;
                    if (this.switchOn.indexOf(s) != -1) {
                        switchedOn = true;
                    }
                    if (this.switchOff.indexOf(s) != -1) {
                        switchedOff = true;
                    }
                    if (s.indexOf("&&") != -1) {
                        int id;
                        switchedOn = true;
                        s = s + "&&";
                        while (s.length() > 0 && (id = s.indexOf("&&")) != -1) {
                            String s1 = s.substring(0, id).trim();
                            s = s.substring(id + 2).trim();
                            if (this.switches.indexOf(s1) == -1) {
                                this.switches.add(s1);
                                switchedOn = false;
                            }
                            if (this.switchOn.indexOf(s1) == -1) {
                                switchedOff = true;
                                switchedOn = false;
                            }
                            if (this.switchOff.indexOf(s1) == -1) continue;
                            switchedOff = true;
                            switchedOn = false;
                        }
                    }
                    if (switchedOn) {
                        working = true;
                        switchoff = false;
                    } else if (switchedOff) {
                        working = true;
                        this.insertLine(++i, "/*" + this.endOfLine);
                        switchoff = true;
                    }
                    if (this.switches.indexOf(s) != -1) continue;
                    this.switches.add(s);
                    continue;
                }
                if (lineTrim.startsWith("//#else")) {
                    if (state != 1) {
                        CodeSwitch.printError("//#else without //#ifdef");
                        return false;
                    }
                    state = 2;
                    if (!working) continue;
                    if (switchoff) {
                        this.insertLine(++i, "*/" + this.endOfLine);
                        switchoff = false;
                        continue;
                    }
                    this.insertLine(++i, "/*" + this.endOfLine);
                    switchoff = true;
                    continue;
                }
                if (!lineTrim.startsWith("//#endif")) continue;
                if (state == 0) {
                    CodeSwitch.printError("//#endif without //#ifdef");
                    return false;
                }
                state = 0;
                if (working && switchoff) {
                    this.insertLine(i++, "*/" + this.endOfLine);
                }
                working = false;
            }
            if (state != 0) {
                CodeSwitch.printError("//#endif missing");
                return false;
            }
            if (this.changed) {
                File fnew = new File(name + ".new");
                FileWriter write = new FileWriter(fnew);
                for (int i = 0; i < this.lines.size(); ++i) {
                    write.write(this.getLine(i));
                }
                write.close();
                File fbak = new File(name + ".bak");
                fbak.delete();
                f.renameTo(fbak);
                File fcopy = new File(name);
                fnew.renameTo(fcopy);
                fbak.delete();
                System.out.println(name);
            }
            return true;
        }
        catch (Exception e) {
            CodeSwitch.printError(e);
            return false;
        }
    }

    private static void printError(Exception e) {
        e.printStackTrace();
    }

    private static void printError(String s) {
        System.out.println("ERROR: " + s);
    }
}

