/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.tools.CreateCluster;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;

public class TestCluster
extends TestBase {
    public void test() throws Exception {
        if (this.config.memory || this.config.networked) {
            return;
        }
        DeleteDbFiles.main(new String[]{"-dir", BASE_DIR + "/node1", "-quiet"});
        DeleteDbFiles.main(new String[]{"-dir", BASE_DIR + "/node2", "-quiet"});
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:file:" + BASE_DIR + "/node1/test", "sa", "");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int len = this.getSize(10, 1000);
        for (int i = 0; i < len; ++i) {
            prep.setInt(1, i);
            prep.setString(2, "Data" + i);
            prep.executeUpdate();
        }
        conn.close();
        CreateCluster.main(new String[]{"-urlSource", "jdbc:h2:file:" + BASE_DIR + "/node1/test", "-urlTarget", "jdbc:h2:file:" + BASE_DIR + "/node2/test", "-user", "sa", "-serverlist", "localhost:9091,localhost:9092"});
        Server n1 = Server.startTcpServer(new String[]{"-tcpPort", "9091", "-baseDir", BASE_DIR + "/node1"});
        Server n2 = Server.startTcpServer(new String[]{"-tcpPort", "9092", "-baseDir", BASE_DIR + "/node2"});
        try {
            conn = DriverManager.getConnection("jdbc:h2:tcp://localhost:9091/test", "sa", "");
            this.error("should not be able to connect in standalone mode");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        try {
            conn = DriverManager.getConnection("jdbc:h2:tcp://localhost:9092/test", "sa", "");
            this.error("should not be able to connect in standalone mode");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn = DriverManager.getConnection("jdbc:h2:tcp://localhost:9091,localhost:9092/test", "sa", "");
        stat = conn.createStatement();
        this.check(conn, len);
        conn.close();
        conn = DriverManager.getConnection("jdbc:h2:tcp://localhost:9091/test;CLUSTER=''", "sa", "");
        this.check(conn, len);
        conn.close();
        n1.stop();
        conn = DriverManager.getConnection("jdbc:h2:tcp://localhost:9092/test;CLUSTER=''", "sa", "");
        this.check(conn, len);
        conn.close();
        n2.stop();
    }

    void check(Connection conn, int len) throws Exception {
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM TEST WHERE ID=?");
        for (int i = 0; i < len; ++i) {
            prep.setInt(1, i);
            ResultSet rs = prep.executeQuery();
            rs.next();
            this.check(rs.getString(2), "Data" + i);
            this.checkFalse(rs.next());
        }
    }
}

