/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Random;
import org.h2.test.synth.TestSynth;

public class RandomGen {
    private Random random = new Random();

    public RandomGen(TestSynth config) {
        this.random.setSeed(12L);
    }

    public int getInt(int max) {
        return max == 0 ? 0 : this.random.nextInt(max);
    }

    public double nextGaussian() {
        return this.random.nextGaussian();
    }

    public int getLog(int max) {
        int d;
        if (max == 0) {
            return 0;
        }
        while ((d = Math.abs((int)(this.random.nextGaussian() / 2.0 * (double)max))) >= max) {
        }
        return d;
    }

    public void getBytes(byte[] data) {
        this.random.nextBytes(data);
    }

    public boolean getBoolean(int percent) {
        return this.random.nextInt(100) <= percent;
    }

    public String randomString(int len) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            String from = i % 2 == 0 ? "bdfghklmnpqrst" : "aeiou";
            buff.append(from.charAt(this.getInt(from.length())));
        }
        return buff.toString();
    }

    public int getRandomInt() {
        switch (this.random.nextInt(10)) {
            case 0: {
                return Integer.MAX_VALUE;
            }
            case 1: {
                return Integer.MIN_VALUE;
            }
            case 2: {
                return this.random.nextInt();
            }
            case 3: 
            case 4: {
                return 0;
            }
            case 5: {
                return (int)(this.random.nextGaussian() * 2000.0) - 200;
            }
        }
        return (int)(this.random.nextGaussian() * 20.0) - 5;
    }

    public long getRandomLong() {
        switch (this.random.nextInt(10)) {
            case 0: {
                return Long.MAX_VALUE;
            }
            case 1: {
                return Long.MIN_VALUE;
            }
            case 2: {
                return this.random.nextLong();
            }
            case 3: 
            case 4: {
                return 0L;
            }
            case 5: {
                return (int)(this.random.nextGaussian() * 20000.0) - 2000;
            }
        }
        return (int)(this.random.nextGaussian() * 200.0) - 50;
    }

    public double getRandomDouble() {
        switch (this.random.nextInt(10)) {
            case 0: {
                return Double.MIN_VALUE;
            }
            case 1: {
                return Double.MAX_VALUE;
            }
            case 2: {
                return 1.4E-45f;
            }
            case 3: {
                return 3.4028234663852886E38;
            }
            case 4: {
                return this.random.nextDouble();
            }
            case 5: 
            case 6: {
                return 0.0;
            }
            case 7: {
                return this.random.nextGaussian() * 20000.0 - 2000.0;
            }
        }
        return this.random.nextGaussian() * 200.0 - 50.0;
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public int[] getIntArray() {
        switch (this.random.nextInt(10)) {
            case 0: {
                return null;
            }
        }
        int len = this.getInt(100);
        int[] list = new int[len];
        for (int i = 0; i < len; ++i) {
            list[i] = this.getRandomInt();
        }
        return list;
    }

    public Object getByteArray() {
        switch (this.random.nextInt(10)) {
            case 0: {
                return null;
            }
        }
        int len = this.getInt(100);
        byte[] list = new byte[len];
        this.random.nextBytes(list);
        return list;
    }

    public Time randomTime() {
        if (this.random.nextInt(10) == 0) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this.getInt(24));
        buff.append(':');
        buff.append(this.getInt(24));
        buff.append(':');
        buff.append(this.getInt(24));
        return Time.valueOf(buff.toString());
    }

    public Timestamp randomTimestamp() {
        if (this.random.nextInt(10) == 0) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this.getInt(10) + 2000);
        buff.append('-');
        buff.append(this.getInt(12) + 1);
        buff.append('-');
        buff.append(this.getInt(29) + 1);
        buff.append(' ');
        buff.append(this.getInt(24));
        buff.append(':');
        buff.append(this.getInt(60));
        buff.append(':');
        buff.append(this.getInt(60));
        return Timestamp.valueOf(buff.toString());
    }

    public Date randomDate() {
        if (this.random.nextInt(10) == 0) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this.getInt(10) + 2000);
        buff.append('-');
        buff.append(this.getInt(11) + 1);
        buff.append('-');
        buff.append(this.getInt(29) + 1);
        return Date.valueOf(buff.toString());
    }

    public String modify(String sql) {
        int len = this.getLog(10);
        for (int i = 0; i < len; ++i) {
            int pos = this.getInt(sql.length());
            if (this.getBoolean(50)) {
                String badChars = "abcABCDEF\u00ef\u00f6\u00fcC1230=<>+\"\\*%&/()=?$_-.:,;{}[]";
                char bad = badChars.charAt(this.getInt(badChars.length()));
                sql = sql.substring(0, pos) + bad + sql.substring(pos);
                continue;
            }
            sql = pos >= sql.length() ? sql.substring(0, pos) : sql.substring(0, pos) + sql.substring(pos + 1);
        }
        return sql;
    }

    public void setSeed(int seed) {
        this.random.setSeed(seed);
    }
}

