/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.util.Hashtable;

public class Encoding
implements org.icepdf.core.pobjects.fonts.Encoding {
    private char[] enc;
    private static Hashtable<String, Integer> h;
    private static char[] se;
    private static char[] mre;
    private static char[] wae;
    private static char[] pde;
    private static char[] sym;
    private static char[] zap;
    public static int[][] symbolAlaises;
    public static int[] registeredAlaises;

    private Encoding(char[] cArray) {
        this.enc = cArray;
    }

    public char get(char c) {
        if (c >= '\u0000' && c < '\u0100') {
            return this.enc[c];
        }
        return c;
    }

    static Encoding getStandard() {
        return new Encoding(se);
    }

    static Encoding getMacRoman() {
        return new Encoding(mre);
    }

    static Encoding getWinAnsi() {
        return new Encoding(wae);
    }

    public static Encoding getPDFDoc() {
        return new Encoding(pde);
    }

    static Encoding getSymbol() {
        return new Encoding(sym);
    }

    static Encoding getZapfDingBats() {
        return new Encoding(zap);
    }

    static int getUV(String string) {
        Integer n = h.get(string);
        if (n != null) {
            return n;
        }
        if (string.startsWith("G")) {
            try {
                String string2 = string.substring(1);
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    /*
     * Opcode count of 18538 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        symbolAlaises = new int[][]{{183, 61623, 8226}, {169, 61667, 61651, 63721, 63193}, {174, 61650, 61666, 61614}, {80, 8364}};
        registeredAlaises = new int[]{182};
        h = new Hashtable(1046);
        h.put("A", 65);
        h.put("AE", 198);
        h.put("AEacute", 508);
        h.put("AEsmall", 63462);
        h.put("Aacute", 193);
        h.put("Aacutesmall", 63457);
        h.put("Abreve", 258);
        h.put("Acircumflex", 194);
        h.put("Acircumflexsmall", 63458);
        h.put("Acute", 63177);
        h.put("Acutesmall", 63412);
        h.put("Adieresis", 196);
        h.put("Adieresissmall", 63460);
        h.put("Agrave", 192);
        h.put("Agravesmall", 63456);
        h.put("Alpha", 913);
        h.put("Alphatonos", 902);
        h.put("Amacron", 256);
        h.put("Aogonek", 260);
        h.put("Aring", 197);
        h.put("Aringacute", 506);
        h.put("Aringsmall", 63461);
        h.put("Asmall", 63329);
        h.put("Atilde", 195);
        h.put("Atildesmall", 63459);
        h.put("B", 66);
        h.put("Beta", 914);
        h.put("Brevesmall", 63220);
        h.put("Bsmall", 63330);
        h.put("C", 67);
        h.put("Cacute", 262);
        h.put("Caron", 63178);
        h.put("Caronsmall", 63221);
        h.put("Ccaron", 268);
        h.put("Ccedilla", 199);
        h.put("Ccedillasmall", 63463);
        h.put("Ccircumflex", 264);
        h.put("Cdotaccent", 266);
        h.put("Cedillasmall", 63416);
        h.put("Chi", 935);
        h.put("Circumflexsmall", 63222);
        h.put("Csmall", 63331);
        h.put("D", 68);
        h.put("Dcaron", 270);
        h.put("Dcroat", 272);
        h.put("Delta", 8710);
        h.put("Delta", 916);
        h.put("Dieresis", 63179);
        h.put("DieresisAcute", 63180);
        h.put("DieresisGrave", 63181);
        h.put("Dieresissmall", 63400);
        h.put("Dotaccentsmall", 63223);
        h.put("Dsmall", 63332);
        h.put("E", 69);
        h.put("Eacute", 201);
        h.put("Eacutesmall", 63465);
        h.put("Ebreve", 276);
        h.put("Ecaron", 282);
        h.put("Ecircumflex", 202);
        h.put("Ecircumflexsmall", 63466);
        h.put("Edieresis", 203);
        h.put("Edieresissmall", 63467);
        h.put("Edotaccent", 278);
        h.put("Egrave", 200);
        h.put("Egravesmall", 63464);
        h.put("Emacron", 274);
        h.put("Eng", 330);
        h.put("Eogonek", 280);
        h.put("Epsilon", 917);
        h.put("Epsilontonos", 904);
        h.put("Esmall", 63333);
        h.put("Eta", 919);
        h.put("Etatonos", 905);
        h.put("Eth", 208);
        h.put("Ethsmall", 63472);
        h.put("Euro", 8364);
        h.put("F", 70);
        h.put("Fsmall", 63334);
        h.put("G", 71);
        h.put("Gamma", 915);
        h.put("Gbreve", 286);
        h.put("Gcaron", 486);
        h.put("Gcircumflex", 284);
        h.put("Gcommaaccent", 290);
        h.put("Gdotaccent", 288);
        h.put("Grave", 63182);
        h.put("Gravesmall", 63328);
        h.put("Gsmall", 63335);
        h.put("H", 72);
        h.put("H18533", 9679);
        h.put("H18543", 9642);
        h.put("H18551", 9643);
        h.put("H22073", 9633);
        h.put("Hbar", 294);
        h.put("Hcircumflex", 292);
        h.put("Hsmall", 63336);
        h.put("Hungarumlaut", 63183);
        h.put("Hungarumlautsmall", 63224);
        h.put("I", 73);
        h.put("IJ", 306);
        h.put("Iacute", 205);
        h.put("Iacutesmall", 63469);
        h.put("Ibreve", 300);
        h.put("Icircumflex", 206);
        h.put("Icircumflexsmall", 63470);
        h.put("Idieresis", 207);
        h.put("Idieresissmall", 63471);
        h.put("Idotaccent", 304);
        h.put("Ifraktur", 8465);
        h.put("Igrave", 204);
        h.put("Igravesmall", 63468);
        h.put("Imacron", 298);
        h.put("Iogonek", 302);
        h.put("Iota", 921);
        h.put("Iotadieresis", 938);
        h.put("Iotatonos", 906);
        h.put("Ismall", 63337);
        h.put("Itilde", 296);
        h.put("J", 74);
        h.put("Jcircumflex", 308);
        h.put("Jsmall", 63338);
        h.put("K", 75);
        h.put("Kappa", 922);
        h.put("Kcommaaccent", 310);
        h.put("Ksmall", 63339);
        h.put("L", 76);
        h.put("LL", 63167);
        h.put("Lacute", 313);
        h.put("Lambda", 923);
        h.put("Lcaron", 317);
        h.put("Lcommaaccent", 315);
        h.put("Ldot", 319);
        h.put("Lslash", 321);
        h.put("Lslashsmall", 63225);
        h.put("Lsmall", 63340);
        h.put("M", 77);
        h.put("Macron", 63184);
        h.put("Macronsmall", 63407);
        h.put("Msmall", 63341);
        h.put("Mu", 924);
        h.put("N", 78);
        h.put("Nacute", 323);
        h.put("Ncaron", 327);
        h.put("Ncommaaccent", 325);
        h.put("Nsmall", 63342);
        h.put("Ntilde", 209);
        h.put("Ntildesmall", 63473);
        h.put("Nu", 925);
        h.put("O", 79);
        h.put("OE", 338);
        h.put("OEsmall", 63226);
        h.put("Oacute", 211);
        h.put("Oacutesmall", 63475);
        h.put("Obreve", 334);
        h.put("Ocircumflex", 212);
        h.put("Ocircumflexsmall", 63476);
        h.put("Odieresis", 214);
        h.put("Odieresissmall", 63478);
        h.put("Ogoneksmall", 63227);
        h.put("Ograve", 210);
        h.put("Ogravesmall", 63474);
        h.put("Ohorn", 416);
        h.put("Ohungarumlaut", 336);
        h.put("Omacron", 332);
        h.put("Omega", 8486);
        h.put("Omega", 937);
        h.put("Omegatonos", 911);
        h.put("Omicron", 927);
        h.put("Omicrontonos", 908);
        h.put("Oslash", 216);
        h.put("Oslashacute", 510);
        h.put("Oslashsmall", 63480);
        h.put("Osmall", 63343);
        h.put("Otilde", 213);
        h.put("Otildesmall", 63477);
        h.put("P", 80);
        h.put("Phi", 934);
        h.put("Pi", 928);
        h.put("Psi", 936);
        h.put("Psmall", 63344);
        h.put("Q", 81);
        h.put("Qsmall", 63345);
        h.put("R", 82);
        h.put("Racute", 340);
        h.put("Rcaron", 344);
        h.put("Rcommaaccent", 342);
        h.put("Rfraktur", 8476);
        h.put("Rho", 929);
        h.put("Ringsmall", 63228);
        h.put("Rsmall", 63346);
        h.put("S", 83);
        h.put("SF010000", 9484);
        h.put("SF020000", 9492);
        h.put("SF030000", 9488);
        h.put("SF040000", 9496);
        h.put("SF050000", 9532);
        h.put("SF060000", 9516);
        h.put("SF070000", 9524);
        h.put("SF080000", 9500);
        h.put("SF090000", 9508);
        h.put("SF100000", 9472);
        h.put("SF110000", 9474);
        h.put("SF190000", 9569);
        h.put("SF200000", 9570);
        h.put("SF210000", 9558);
        h.put("SF220000", 9557);
        h.put("SF230000", 9571);
        h.put("SF240000", 9553);
        h.put("SF250000", 9559);
        h.put("SF260000", 9565);
        h.put("SF270000", 9564);
        h.put("SF280000", 9563);
        h.put("SF360000", 9566);
        h.put("SF370000", 9567);
        h.put("SF380000", 9562);
        h.put("SF390000", 9556);
        h.put("SF400000", 9577);
        h.put("SF410000", 9574);
        h.put("SF420000", 9568);
        h.put("SF430000", 9552);
        h.put("SF440000", 9580);
        h.put("SF450000", 9575);
        h.put("SF460000", 9576);
        h.put("SF470000", 9572);
        h.put("SF480000", 9573);
        h.put("SF490000", 9561);
        h.put("SF500000", 9560);
        h.put("SF510000", 9554);
        h.put("SF520000", 9555);
        h.put("SF530000", 9579);
        h.put("SF540000", 9578);
        h.put("Sacute", 346);
        h.put("Scaron", 352);
        h.put("Scaronsmall", 63229);
        h.put("Scedilla", 350);
        h.put("Scedilla", 63169);
        h.put("Scircumflex", 348);
        h.put("Scommaaccent", 536);
        h.put("Sigma", 931);
        h.put("Ssmall", 63347);
        h.put("T", 84);
        h.put("Tau", 932);
        h.put("Tbar", 358);
        h.put("Tcaron", 356);
        h.put("Tcommaaccent", 354);
        h.put("Tcommaaccent", 538);
        h.put("Theta", 920);
        h.put("Thorn", 222);
        h.put("Thornsmall", 63486);
        h.put("Tildesmall", 63230);
        h.put("Tsmall", 63348);
        h.put("U", 85);
        h.put("Uacute", 218);
        h.put("Uacutesmall", 63482);
        h.put("Ubreve", 364);
        h.put("Ucircumflex", 219);
        h.put("Ucircumflexsmall", 63483);
        h.put("Udieresis", 220);
        h.put("Udieresissmall", 63484);
        h.put("Ugrave", 217);
        h.put("Ugravesmall", 63481);
        h.put("Uhorn", 431);
        h.put("Uhungarumlaut", 368);
        h.put("Umacron", 362);
        h.put("Uogonek", 370);
        h.put("Upsilon", 933);
        h.put("Upsilon1", 978);
        h.put("Upsilondieresis", 939);
        h.put("Upsilontonos", 910);
        h.put("Uring", 366);
        h.put("Usmall", 63349);
        h.put("Utilde", 360);
        h.put("V", 86);
        h.put("Vsmall", 63350);
        h.put("W", 87);
        h.put("Wacute", 7810);
        h.put("Wcircumflex", 372);
        h.put("Wdieresis", 7812);
        h.put("Wgrave", 7808);
        h.put("Wsmall", 63351);
        h.put("X", 88);
        h.put("Xi", 926);
        h.put("Xsmall", 63352);
        h.put("Y", 89);
        h.put("Yacute", 221);
        h.put("Yacutesmall", 63485);
        h.put("Ycircumflex", 374);
        h.put("Ydieresis", 376);
        h.put("Ydieresissmall", 63487);
        h.put("Ygrave", 7922);
        h.put("Ysmall", 63353);
        h.put("Z", 90);
        h.put("Zacute", 377);
        h.put("Zcaron", 381);
        h.put("Zcaronsmall", 63231);
        h.put("Zdotaccent", 379);
        h.put("Zeta", 918);
        h.put("Zsmall", 63354);
        h.put("a", 97);
        h.put("aacute", 225);
        h.put("abreve", 259);
        h.put("acircumflex", 226);
        h.put("acute", 180);
        h.put("acutecomb", 769);
        h.put("adieresis", 228);
        h.put("ae", 230);
        h.put("aeacute", 509);
        h.put("afii00208", 8213);
        h.put("afii10017", 1040);
        h.put("afii10018", 1041);
        h.put("afii10019", 1042);
        h.put("afii10020", 1043);
        h.put("afii10021", 1044);
        h.put("afii10022", 1045);
        h.put("afii10023", 1025);
        h.put("afii10024", 1046);
        h.put("afii10025", 1047);
        h.put("afii10026", 1048);
        h.put("afii10027", 1049);
        h.put("afii10028", 1050);
        h.put("afii10029", 1051);
        h.put("afii10030", 1052);
        h.put("afii10031", 1053);
        h.put("afii10032", 1054);
        h.put("afii10033", 1055);
        h.put("afii10034", 1056);
        h.put("afii10035", 1057);
        h.put("afii10036", 1058);
        h.put("afii10037", 1059);
        h.put("afii10038", 1060);
        h.put("afii10039", 1061);
        h.put("afii10040", 1062);
        h.put("afii10041", 1063);
        h.put("afii10042", 1064);
        h.put("afii10043", 1065);
        h.put("afii10044", 1066);
        h.put("afii10045", 1067);
        h.put("afii10046", 1068);
        h.put("afii10047", 1069);
        h.put("afii10048", 1070);
        h.put("afii10049", 1071);
        h.put("afii10050", 1168);
        h.put("afii10051", 1026);
        h.put("afii10052", 1027);
        h.put("afii10053", 1028);
        h.put("afii10054", 1029);
        h.put("afii10055", 1030);
        h.put("afii10056", 1031);
        h.put("afii10057", 1032);
        h.put("afii10058", 1033);
        h.put("afii10059", 1034);
        h.put("afii10060", 1035);
        h.put("afii10061", 1036);
        h.put("afii10062", 1038);
        h.put("afii10063", 63172);
        h.put("afii10064", 63173);
        h.put("afii10065", 1072);
        h.put("afii10066", 1073);
        h.put("afii10067", 1074);
        h.put("afii10068", 1075);
        h.put("afii10069", 1076);
        h.put("afii10070", 1077);
        h.put("afii10071", 1105);
        h.put("afii10072", 1078);
        h.put("afii10073", 1079);
        h.put("afii10074", 1080);
        h.put("afii10075", 1081);
        h.put("afii10076", 1082);
        h.put("afii10077", 1083);
        h.put("afii10078", 1084);
        h.put("afii10079", 1085);
        h.put("afii10080", 1086);
        h.put("afii10081", 1087);
        h.put("afii10082", 1088);
        h.put("afii10083", 1089);
        h.put("afii10084", 1090);
        h.put("afii10085", 1091);
        h.put("afii10086", 1092);
        h.put("afii10087", 1093);
        h.put("afii10088", 1094);
        h.put("afii10089", 1095);
        h.put("afii10090", 1096);
        h.put("afii10091", 1097);
        h.put("afii10092", 1098);
        h.put("afii10093", 1099);
        h.put("afii10094", 1100);
        h.put("afii10095", 1101);
        h.put("afii10096", 1102);
        h.put("afii10097", 1103);
        h.put("afii10098", 1169);
        h.put("afii10099", 1106);
        h.put("afii10100", 1107);
        h.put("afii10101", 1108);
        h.put("afii10102", 1109);
        h.put("afii10103", 1110);
        h.put("afii10104", 1111);
        h.put("afii10105", 1112);
        h.put("afii10106", 1113);
        h.put("afii10107", 1114);
        h.put("afii10108", 1115);
        h.put("afii10109", 1116);
        h.put("afii10110", 1118);
        h.put("afii10145", 1039);
        h.put("afii10146", 1122);
        h.put("afii10147", 1138);
        h.put("afii10148", 1140);
        h.put("afii10192", 63174);
        h.put("afii10193", 1119);
        h.put("afii10194", 1123);
        h.put("afii10195", 1139);
        h.put("afii10196", 1141);
        h.put("afii10831", 63175);
        h.put("afii10832", 63176);
        h.put("afii10846", 1241);
        h.put("afii299", 8206);
        h.put("afii300", 8207);
        h.put("afii301", 8205);
        h.put("afii57381", 1642);
        h.put("afii57388", 1548);
        h.put("afii57392", 1632);
        h.put("afii57393", 1633);
        h.put("afii57394", 1634);
        h.put("afii57395", 1635);
        h.put("afii57396", 1636);
        h.put("afii57397", 1637);
        h.put("afii57398", 1638);
        h.put("afii57399", 1639);
        h.put("afii57400", 1640);
        h.put("afii57401", 1641);
        h.put("afii57403", 1563);
        h.put("afii57407", 1567);
        h.put("afii57409", 1569);
        h.put("afii57410", 1570);
        h.put("afii57411", 1571);
        h.put("afii57412", 1572);
        h.put("afii57413", 1573);
        h.put("afii57414", 1574);
        h.put("afii57415", 1575);
        h.put("afii57416", 1576);
        h.put("afii57417", 1577);
        h.put("afii57418", 1578);
        h.put("afii57419", 1579);
        h.put("afii57420", 1580);
        h.put("afii57421", 1581);
        h.put("afii57422", 1582);
        h.put("afii57423", 1583);
        h.put("afii57424", 1584);
        h.put("afii57425", 1585);
        h.put("afii57426", 1586);
        h.put("afii57427", 1587);
        h.put("afii57428", 1588);
        h.put("afii57429", 1589);
        h.put("afii57430", 1590);
        h.put("afii57431", 1591);
        h.put("afii57432", 1592);
        h.put("afii57433", 1593);
        h.put("afii57434", 1594);
        h.put("afii57440", 1600);
        h.put("afii57441", 1601);
        h.put("afii57442", 1602);
        h.put("afii57443", 1603);
        h.put("afii57444", 1604);
        h.put("afii57445", 1605);
        h.put("afii57446", 1606);
        h.put("afii57448", 1608);
        h.put("afii57449", 1609);
        h.put("afii57450", 1610);
        h.put("afii57451", 1611);
        h.put("afii57452", 1612);
        h.put("afii57453", 1613);
        h.put("afii57454", 1614);
        h.put("afii57455", 1615);
        h.put("afii57456", 1616);
        h.put("afii57457", 1617);
        h.put("afii57458", 1618);
        h.put("afii57470", 1607);
        h.put("afii57505", 1700);
        h.put("afii57506", 1662);
        h.put("afii57507", 1670);
        h.put("afii57508", 1688);
        h.put("afii57509", 1711);
        h.put("afii57511", 1657);
        h.put("afii57512", 1672);
        h.put("afii57513", 1681);
        h.put("afii57514", 1722);
        h.put("afii57519", 1746);
        h.put("afii57534", 1749);
        h.put("afii57636", 8362);
        h.put("afii57645", 1470);
        h.put("afii57658", 1475);
        h.put("afii57664", 1488);
        h.put("afii57665", 1489);
        h.put("afii57666", 1490);
        h.put("afii57667", 1491);
        h.put("afii57668", 1492);
        h.put("afii57669", 1493);
        h.put("afii57670", 1494);
        h.put("afii57671", 1495);
        h.put("afii57672", 1496);
        h.put("afii57673", 1497);
        h.put("afii57674", 1498);
        h.put("afii57675", 1499);
        h.put("afii57676", 1500);
        h.put("afii57677", 1501);
        h.put("afii57678", 1502);
        h.put("afii57679", 1503);
        h.put("afii57680", 1504);
        h.put("afii57681", 1505);
        h.put("afii57682", 1506);
        h.put("afii57683", 1507);
        h.put("afii57684", 1508);
        h.put("afii57685", 1509);
        h.put("afii57686", 1510);
        h.put("afii57687", 1511);
        h.put("afii57688", 1512);
        h.put("afii57689", 1513);
        h.put("afii57690", 1514);
        h.put("afii57694", 64298);
        h.put("afii57695", 64299);
        h.put("afii57700", 64331);
        h.put("afii57705", 64287);
        h.put("afii57716", 1520);
        h.put("afii57717", 1521);
        h.put("afii57718", 1522);
        h.put("afii57723", 64309);
        h.put("afii57793", 1460);
        h.put("afii57794", 1461);
        h.put("afii57795", 1462);
        h.put("afii57796", 1467);
        h.put("afii57797", 1464);
        h.put("afii57798", 1463);
        h.put("afii57799", 1456);
        h.put("afii57800", 1458);
        h.put("afii57801", 1457);
        h.put("afii57802", 1459);
        h.put("afii57803", 1474);
        h.put("afii57804", 1473);
        h.put("afii57806", 1465);
        h.put("afii57807", 1468);
        h.put("afii57839", 1469);
        h.put("afii57841", 1471);
        h.put("afii57842", 1472);
        h.put("afii57929", 700);
        h.put("afii61248", 8453);
        h.put("afii61289", 8467);
        h.put("afii61352", 8470);
        h.put("afii61573", 8236);
        h.put("afii61574", 8237);
        h.put("afii61575", 8238);
        h.put("afii61664", 8204);
        h.put("afii63167", 1645);
        h.put("afii64937", 701);
        h.put("agrave", 224);
        h.put("aleph", 8501);
        h.put("alpha", 945);
        h.put("alphatonos", 940);
        h.put("amacron", 257);
        h.put("ampersand", 38);
        h.put("ampersandsmall", 63270);
        h.put("angle", 8736);
        h.put("angleleft", 9001);
        h.put("angleright", 9002);
        h.put("anoteleia", 903);
        h.put("aogonek", 261);
        h.put("approxequal", 8776);
        h.put("aring", 229);
        h.put("aringacute", 507);
        h.put("arrowboth", 8596);
        h.put("arrowdblboth", 8660);
        h.put("arrowdbldown", 8659);
        h.put("arrowdblleft", 8656);
        h.put("arrowdblright", 8658);
        h.put("arrowdblup", 8657);
        h.put("arrowdown", 8595);
        h.put("arrowhorizex", 63719);
        h.put("arrowleft", 8592);
        h.put("arrowright", 8594);
        h.put("arrowup", 8593);
        h.put("arrowupdn", 8597);
        h.put("arrowupdnbse", 8616);
        h.put("arrowvertex", 63718);
        h.put("asciicircum", 94);
        h.put("asciitilde", 126);
        h.put("asterisk", 42);
        h.put("asteriskmath", 8727);
        h.put("asuperior", 63209);
        h.put("at", 64);
        h.put("atilde", 227);
        h.put("b", 98);
        h.put("backslash", 92);
        h.put("bar", 124);
        h.put("beta", 946);
        h.put("block", 9608);
        h.put("braceex", 63732);
        h.put("braceleft", 123);
        h.put("braceleftbt", 63731);
        h.put("braceleftmid", 63730);
        h.put("bracelefttp", 63729);
        h.put("braceright", 125);
        h.put("bracerightbt", 63742);
        h.put("bracerightmid", 63741);
        h.put("bracerighttp", 63740);
        h.put("bracketleft", 91);
        h.put("bracketleftbt", 63728);
        h.put("bracketleftex", 63727);
        h.put("bracketlefttp", 63726);
        h.put("bracketright", 93);
        h.put("bracketrightbt", 63739);
        h.put("bracketrightex", 63738);
        h.put("bracketrighttp", 63737);
        h.put("breve", 728);
        h.put("brokenbar", 166);
        h.put("bsuperior", 63210);
        h.put("bullet", 8226);
        h.put("c", 99);
        h.put("cacute", 263);
        h.put("caron", 711);
        h.put("carriagereturn", 8629);
        h.put("ccaron", 269);
        h.put("ccedilla", 231);
        h.put("ccircumflex", 265);
        h.put("cdotaccent", 267);
        h.put("cedilla", 184);
        h.put("cent", 162);
        h.put("centinferior", 63199);
        h.put("centoldstyle", 63394);
        h.put("centsuperior", 63200);
        h.put("chi", 967);
        h.put("circle", 9675);
        h.put("circlemultiply", 8855);
        h.put("circleplus", 8853);
        h.put("circumflex", 710);
        h.put("club", 9827);
        h.put("colon", 58);
        h.put("colonmonetary", 8353);
        h.put("comma", 44);
        h.put("commaaccent", 63171);
        h.put("commainferior", 63201);
        h.put("commasuperior", 63202);
        h.put("congruent", 8773);
        h.put("copyright", 169);
        h.put("copyrightsans", 63721);
        h.put("copyrightserif", 63193);
        h.put("currency", 164);
        h.put("cyrBreve", 63185);
        h.put("cyrFlex", 63186);
        h.put("cyrbreve", 63188);
        h.put("cyrflex", 63189);
        h.put("d", 100);
        h.put("dagger", 8224);
        h.put("daggerdbl", 8225);
        h.put("dblGrave", 63187);
        h.put("dblgrave", 63190);
        h.put("dcaron", 271);
        h.put("dcroat", 273);
        h.put("degree", 176);
        h.put("delta", 948);
        h.put("diamond", 9830);
        h.put("dieresis", 168);
        h.put("dieresisacute", 63191);
        h.put("dieresisgrave", 63192);
        h.put("dieresistonos", 901);
        h.put("divide", 247);
        h.put("dkshade", 9619);
        h.put("dnblock", 9604);
        h.put("dollar", 36);
        h.put("dollarinferior", 63203);
        h.put("dollaroldstyle", 63268);
        h.put("dollarsuperior", 63204);
        h.put("dong", 8363);
        h.put("dotaccent", 729);
        h.put("dotbelowcomb", 803);
        h.put("dotlessi", 305);
        h.put("dotlessj", 63166);
        h.put("dotmath", 8901);
        h.put("dsuperior", 63211);
        h.put("e", 101);
        h.put("eacute", 233);
        h.put("ebreve", 277);
        h.put("ecaron", 283);
        h.put("ecircumflex", 234);
        h.put("edieresis", 235);
        h.put("edotaccent", 279);
        h.put("egrave", 232);
        h.put("eight", 56);
        h.put("eightinferior", 8328);
        h.put("eightoldstyle", 63288);
        h.put("eightsuperior", 8312);
        h.put("element", 8712);
        h.put("ellipsis", 8230);
        h.put("emacron", 275);
        h.put("emdash", 8212);
        h.put("emptyset", 8709);
        h.put("endash", 8211);
        h.put("eng", 331);
        h.put("eogonek", 281);
        h.put("epsilon", 949);
        h.put("epsilontonos", 941);
        h.put("equal", 61);
        h.put("equivalence", 8801);
        h.put("estimated", 8494);
        h.put("esuperior", 63212);
        h.put("eta", 951);
        h.put("etatonos", 942);
        h.put("eth", 240);
        h.put("exclam", 33);
        h.put("exclamdbl", 8252);
        h.put("exclamdown", 161);
        h.put("exclamdownsmall", 63393);
        h.put("exclamsmall", 63265);
        h.put("existential", 8707);
        h.put("f", 102);
        h.put("female", 9792);
        h.put("ff", 64256);
        h.put("ffi", 64259);
        h.put("ffl", 64260);
        h.put("fi", 64257);
        h.put("figuredash", 8210);
        h.put("filledbox", 9632);
        h.put("filledrect", 9644);
        h.put("five", 53);
        h.put("fiveeighths", 8541);
        h.put("fiveinferior", 8325);
        h.put("fiveoldstyle", 63285);
        h.put("fivesuperior", 8309);
        h.put("fl", 64258);
        h.put("florin", 402);
        h.put("four", 52);
        h.put("fourinferior", 8324);
        h.put("fouroldstyle", 63284);
        h.put("foursuperior", 8308);
        h.put("fraction", 8260);
        h.put("fraction", 8725);
        h.put("franc", 8355);
        h.put("g", 103);
        h.put("gamma", 947);
        h.put("gbreve", 287);
        h.put("gcaron", 487);
        h.put("gcircumflex", 285);
        h.put("gcommaaccent", 291);
        h.put("gdotaccent", 289);
        h.put("germandbls", 223);
        h.put("gradient", 8711);
        h.put("grave", 96);
        h.put("gravecomb", 768);
        h.put("greater", 62);
        h.put("greaterequal", 8805);
        h.put("guillemotleft", 171);
        h.put("guillemotright", 187);
        h.put("guilsinglleft", 8249);
        h.put("guilsinglright", 8250);
        h.put("h", 104);
        h.put("hbar", 295);
        h.put("hcircumflex", 293);
        h.put("heart", 9829);
        h.put("hookabovecomb", 777);
        h.put("house", 8962);
        h.put("hungarumlaut", 733);
        h.put("hyphen", 45);
        h.put("hypheninferior", 63205);
        h.put("hyphensuperior", 63206);
        h.put("i", 105);
        h.put("iacute", 237);
        h.put("ibreve", 301);
        h.put("icircumflex", 238);
        h.put("idieresis", 239);
        h.put("igrave", 236);
        h.put("ij", 307);
        h.put("imacron", 299);
        h.put("infinity", 8734);
        h.put("integral", 8747);
        h.put("integralbt", 8993);
        h.put("integralex", 63733);
        h.put("integraltp", 8992);
        h.put("intersection", 8745);
        h.put("invbullet", 9688);
        h.put("invcircle", 9689);
        h.put("invsmileface", 9787);
        h.put("iogonek", 303);
        h.put("iota", 953);
        h.put("iotadieresis", 970);
        h.put("iotadieresistonos", 912);
        h.put("iotatonos", 943);
        h.put("isuperior", 63213);
        h.put("itilde", 297);
        h.put("j", 106);
        h.put("jcircumflex", 309);
        h.put("k", 107);
        h.put("kappa", 954);
        h.put("kcommaaccent", 311);
        h.put("kgreenlandic", 312);
        h.put("l", 108);
        h.put("lacute", 314);
        h.put("lambda", 955);
        h.put("lcaron", 318);
        h.put("lcommaaccent", 316);
        h.put("ldot", 320);
        h.put("less", 60);
        h.put("lessequal", 8804);
        h.put("lfblock", 9612);
        h.put("lira", 8356);
        h.put("ll", 63168);
        h.put("logicaland", 8743);
        h.put("logicalnot", 172);
        h.put("logicalor", 8744);
        h.put("longs", 383);
        h.put("lozenge", 9674);
        h.put("lslash", 322);
        h.put("lsuperior", 63214);
        h.put("ltshade", 9617);
        h.put("m", 109);
        h.put("macron", 175);
        h.put("male", 9794);
        h.put("minus", 8722);
        h.put("minute", 8242);
        h.put("msuperior", 63215);
        h.put("mu", 181);
        h.put("multiply", 215);
        h.put("musicalnote", 9834);
        h.put("musicalnotedbl", 9835);
        h.put("n", 110);
        h.put("nacute", 324);
        h.put("napostrophe", 329);
        h.put("ncaron", 328);
        h.put("ncommaaccent", 326);
        h.put("nine", 57);
        h.put("nineinferior", 8329);
        h.put("nineoldstyle", 63289);
        h.put("ninesuperior", 8313);
        h.put("notelement", 8713);
        h.put("notequal", 8800);
        h.put("notsubset", 8836);
        h.put("nsuperior", 8319);
        h.put("ntilde", 241);
        h.put("nu", 957);
        h.put("numbersign", 35);
        h.put("o", 111);
        h.put("oacute", 243);
        h.put("obreve", 335);
        h.put("ocircumflex", 244);
        h.put("odieresis", 246);
        h.put("oe", 339);
        h.put("ogonek", 731);
        h.put("ograve", 242);
        h.put("ohorn", 417);
        h.put("ohungarumlaut", 337);
        h.put("omacron", 333);
        h.put("omega", 969);
        h.put("omega1", 982);
        h.put("omegatonos", 974);
        h.put("omicron", 959);
        h.put("omicrontonos", 972);
        h.put("one", 49);
        h.put("onedotenleader", 8228);
        h.put("oneeighth", 8539);
        h.put("onefitted", 63196);
        h.put("onehalf", 189);
        h.put("oneinferior", 8321);
        h.put("oneoldstyle", 63281);
        h.put("onequarter", 188);
        h.put("onesuperior", 185);
        h.put("onethird", 8531);
        h.put("openbullet", 9702);
        h.put("ordfeminine", 170);
        h.put("ordmasculine", 186);
        h.put("orthogonal", 8735);
        h.put("oslash", 248);
        h.put("oslashacute", 511);
        h.put("osuperior", 63216);
        h.put("otilde", 245);
        h.put("p", 112);
        h.put("paragraph", 182);
        h.put("parenleft", 40);
        h.put("parenleftbt", 63725);
        h.put("parenleftex", 63724);
        h.put("parenleftinferior", 8333);
        h.put("parenleftsuperior", 8317);
        h.put("parenlefttp", 63723);
        h.put("parenright", 41);
        h.put("parenrightbt", 63736);
        h.put("parenrightex", 63735);
        h.put("parenrightinferior", 8334);
        h.put("parenrightsuperior", 8318);
        h.put("parenrighttp", 63734);
        h.put("partialdiff", 8706);
        h.put("percent", 37);
        h.put("period", 46);
        h.put("periodcentered", 183);
        h.put("periodcentered", 8729);
        h.put("periodinferior", 63207);
        h.put("periodsuperior", 63208);
        h.put("perpendicular", 8869);
        h.put("perthousand", 8240);
        h.put("peseta", 8359);
        h.put("phi", 966);
        h.put("phi1", 981);
        h.put("pi", 960);
        h.put("plus", 43);
        h.put("plusminus", 177);
        h.put("prescription", 8478);
        h.put("product", 8719);
        h.put("propersubset", 8834);
        h.put("propersuperset", 8835);
        h.put("proportional", 8733);
        h.put("psi", 968);
        h.put("q", 113);
        h.put("question", 63);
        h.put("questiondown", 191);
        h.put("questiondownsmall", 63423);
        h.put("questionsmall", 63295);
        h.put("quotedbl", 34);
        h.put("quotedblbase", 8222);
        h.put("quotedblleft", 8220);
        h.put("quotedblright", 8221);
        h.put("quoteleft", 8216);
        h.put("quotereversed", 8219);
        h.put("quoteright", 8217);
        h.put("quotesinglbase", 8218);
        h.put("quotesingle", 39);
        h.put("r", 114);
        h.put("racute", 341);
        h.put("radical", 8730);
        h.put("radicalex", 63717);
        h.put("rcaron", 345);
        h.put("rcommaaccent", 343);
        h.put("reflexsubset", 8838);
        h.put("reflexsuperset", 8839);
        h.put("registered", 174);
        h.put("registersans", 63720);
        h.put("registerserif", 63194);
        h.put("revlogicalnot", 8976);
        h.put("rho", 961);
        h.put("ring", 730);
        h.put("rsuperior", 63217);
        h.put("rtblock", 9616);
        h.put("rupiah", 63197);
        h.put("s", 115);
        h.put("sacute", 347);
        h.put("scaron", 353);
        h.put("scedilla", 351);
        h.put("scedilla", 63170);
        h.put("scircumflex", 349);
        h.put("scommaaccent", 537);
        h.put("second", 8243);
        h.put("section", 167);
        h.put("semicolon", 59);
        h.put("seven", 55);
        h.put("seveneighths", 8542);
        h.put("seveninferior", 8327);
        h.put("sevenoldstyle", 63287);
        h.put("sevensuperior", 8311);
        h.put("shade", 9618);
        h.put("sigma", 963);
        h.put("sigma1", 962);
        h.put("similar", 8764);
        h.put("six", 54);
        h.put("sixinferior", 8326);
        h.put("sixoldstyle", 63286);
        h.put("sixsuperior", 8310);
        h.put("slash", 47);
        h.put("smileface", 9786);
        h.put("space", 32);
        h.put("spade", 9824);
        h.put("ssuperior", 63218);
        h.put("sterling", 163);
        h.put("suchthat", 8715);
        h.put("summation", 8721);
        h.put("sun", 9788);
        h.put("t", 116);
        h.put("tau", 964);
        h.put("tbar", 359);
        h.put("tcaron", 357);
        h.put("tcommaaccent", 355);
        h.put("tcommaaccent", 539);
        h.put("therefore", 8756);
        h.put("theta", 952);
        h.put("theta1", 977);
        h.put("thorn", 254);
        h.put("three", 51);
        h.put("threeeighths", 8540);
        h.put("threeinferior", 8323);
        h.put("threeoldstyle", 63283);
        h.put("threequarters", 190);
        h.put("threequartersemdash", 63198);
        h.put("threesuperior", 179);
        h.put("tilde", 732);
        h.put("tildecomb", 771);
        h.put("tonos", 900);
        h.put("trademark", 8482);
        h.put("trademarksans", 63722);
        h.put("trademarkserif", 63195);
        h.put("triagdn", 9660);
        h.put("triaglf", 9668);
        h.put("triagrt", 9658);
        h.put("triagup", 9650);
        h.put("tsuperior", 63219);
        h.put("two", 50);
        h.put("twodotenleader", 8229);
        h.put("twoinferior", 8322);
        h.put("twooldstyle", 63282);
        h.put("twosuperior", 178);
        h.put("twothirds", 8532);
        h.put("u", 117);
        h.put("uacute", 250);
        h.put("ubreve", 365);
        h.put("ucircumflex", 251);
        h.put("udieresis", 252);
        h.put("ugrave", 249);
        h.put("uhorn", 432);
        h.put("uhungarumlaut", 369);
        h.put("umacron", 363);
        h.put("underscore", 95);
        h.put("underscoredbl", 8215);
        h.put("union", 8746);
        h.put("universal", 8704);
        h.put("uogonek", 371);
        h.put("upblock", 9600);
        h.put("upsilon", 965);
        h.put("upsilondieresis", 971);
        h.put("upsilondieresistonos", 944);
        h.put("upsilontonos", 973);
        h.put("uring", 367);
        h.put("utilde", 361);
        h.put("v", 118);
        h.put("w", 119);
        h.put("wacute", 7811);
        h.put("wcircumflex", 373);
        h.put("wdieresis", 7813);
        h.put("weierstrass", 8472);
        h.put("wgrave", 7809);
        h.put("x", 120);
        h.put("xi", 958);
        h.put("y", 121);
        h.put("yacute", 253);
        h.put("ycircumflex", 375);
        h.put("ydieresis", 255);
        h.put("yen", 165);
        h.put("ygrave", 7923);
        h.put("z", 122);
        h.put("zacute", 378);
        h.put("zcaron", 382);
        h.put("zdotaccent", 380);
        h.put("zero", 48);
        h.put("zeroinferior", 8320);
        h.put("zerooldstyle", 63280);
        h.put("zerosuperior", 8304);
        h.put("zeta", 950);
        h.put("a1", 9985);
        h.put("a2", 9986);
        h.put("a202", 9987);
        h.put("a3", 9988);
        h.put("a4", 9742);
        h.put("a5", 9990);
        h.put("a119", 9991);
        h.put("a118", 9992);
        h.put("a117", 9993);
        h.put("a11", 9755);
        h.put("a12", 9758);
        h.put("a13", 9996);
        h.put("a14", 9997);
        h.put("a15", 9998);
        h.put("a16", 9999);
        h.put("a105", 10000);
        h.put("a17", 10001);
        h.put("a18", 10002);
        h.put("a19", 10003);
        h.put("a20", 10004);
        h.put("a21", 10005);
        h.put("a22", 10006);
        h.put("a23", 10007);
        h.put("a24", 10008);
        h.put("a25", 10009);
        h.put("a26", 10010);
        h.put("a27", 10011);
        h.put("a28", 10012);
        h.put("a6", 10013);
        h.put("a7", 10014);
        h.put("a8", 10015);
        h.put("a9", 10016);
        h.put("a10", 10017);
        h.put("a29", 10018);
        h.put("a30", 10019);
        h.put("a31", 10020);
        h.put("a32", 10021);
        h.put("a33", 10022);
        h.put("a34", 10023);
        h.put("a35", 9733);
        h.put("a36", 10025);
        h.put("a37", 10026);
        h.put("a38", 10027);
        h.put("a39", 10028);
        h.put("a40", 10029);
        h.put("a41", 10030);
        h.put("a42", 10031);
        h.put("a43", 10032);
        h.put("a44", 10033);
        h.put("a45", 10034);
        h.put("a46", 10035);
        h.put("a47", 10036);
        h.put("a48", 10037);
        h.put("a49", 10038);
        h.put("a50", 10039);
        h.put("a51", 10040);
        h.put("a52", 10041);
        h.put("a53", 10042);
        h.put("a54", 10043);
        h.put("a55", 10044);
        h.put("a56", 10045);
        h.put("a57", 10046);
        h.put("a58", 10047);
        h.put("a59", 10048);
        h.put("a60", 10049);
        h.put("a61", 10050);
        h.put("a62", 10051);
        h.put("a63", 10052);
        h.put("a64", 10053);
        h.put("a65", 10054);
        h.put("a66", 10055);
        h.put("a67", 10056);
        h.put("a68", 10057);
        h.put("a69", 10058);
        h.put("a70", 10059);
        h.put("a71", 9679);
        h.put("a72", 10061);
        h.put("a73", 9632);
        h.put("a74", 10063);
        h.put("a203", 10064);
        h.put("a75", 10065);
        h.put("a204", 10066);
        h.put("a76", 9650);
        h.put("a77", 9660);
        h.put("a78", 9670);
        h.put("a79", 10070);
        h.put("a81", 9687);
        h.put("a82", 10072);
        h.put("a83", 10073);
        h.put("a84", 10074);
        h.put("a97", 10075);
        h.put("a98", 10076);
        h.put("a99", 10077);
        h.put("a100", 10078);
        h.put("a89", 63703);
        h.put("a90", 63704);
        h.put("a93", 63705);
        h.put("a94", 63706);
        h.put("a91", 63707);
        h.put("a92", 63708);
        h.put("a205", 63709);
        h.put("a85", 63710);
        h.put("a206", 63711);
        h.put("a86", 63712);
        h.put("a87", 63713);
        h.put("a88", 63714);
        h.put("a95", 63715);
        h.put("a96", 63716);
        h.put("a101", 10081);
        h.put("a102", 10082);
        h.put("a103", 10083);
        h.put("a104", 10084);
        h.put("a106", 10085);
        h.put("a107", 10086);
        h.put("a108", 10087);
        h.put("a112", 9827);
        h.put("a111", 9830);
        h.put("a110", 9829);
        h.put("a109", 9824);
        h.put("a120", 9312);
        h.put("a121", 9313);
        h.put("a122", 9314);
        h.put("a123", 9315);
        h.put("a124", 9316);
        h.put("a125", 9317);
        h.put("a126", 9318);
        h.put("a127", 9319);
        h.put("a128", 9320);
        h.put("a129", 9321);
        h.put("a130", 10102);
        h.put("a131", 10103);
        h.put("a132", 10104);
        h.put("a133", 10105);
        h.put("a134", 10106);
        h.put("a135", 10107);
        h.put("a136", 10108);
        h.put("a137", 10109);
        h.put("a138", 10110);
        h.put("a139", 10111);
        h.put("a140", 10112);
        h.put("a141", 10113);
        h.put("a142", 10114);
        h.put("a143", 10115);
        h.put("a144", 10116);
        h.put("a145", 10117);
        h.put("a146", 10118);
        h.put("a147", 10119);
        h.put("a148", 10120);
        h.put("a149", 10121);
        h.put("a150", 10122);
        h.put("a151", 10123);
        h.put("a152", 10124);
        h.put("a153", 10125);
        h.put("a154", 10126);
        h.put("a155", 10127);
        h.put("a156", 10128);
        h.put("a157", 10129);
        h.put("a158", 10130);
        h.put("a159", 10131);
        h.put("a160", 10132);
        h.put("a161", 8594);
        h.put("a163", 8596);
        h.put("a164", 8597);
        h.put("a196", 10136);
        h.put("a165", 10137);
        h.put("a192", 10138);
        h.put("a166", 10139);
        h.put("a167", 10140);
        h.put("a168", 10141);
        h.put("a169", 10142);
        h.put("a170", 10143);
        h.put("a171", 10144);
        h.put("a172", 10145);
        h.put("a173", 10146);
        h.put("a162", 10147);
        h.put("a174", 10148);
        h.put("a175", 10149);
        h.put("a176", 10150);
        h.put("a177", 10151);
        h.put("a178", 10152);
        h.put("a179", 10153);
        h.put("a193", 10154);
        h.put("a180", 10155);
        h.put("a199", 10156);
        h.put("a181", 10157);
        h.put("a200", 10158);
        h.put("a182", 10159);
        h.put("a201", 10161);
        h.put("a183", 10162);
        h.put("a184", 10163);
        h.put("a197", 10164);
        h.put("a185", 10165);
        h.put("a194", 10166);
        h.put("a198", 10167);
        h.put("a186", 10168);
        h.put("a195", 10169);
        h.put("a187", 10170);
        h.put("a188", 10171);
        h.put("a189", 10172);
        h.put("a190", 10173);
        h.put("a191", 10174);
        h.put("apple", 32);
        se = new char[256];
        mre = new char[256];
        wae = new char[256];
        pde = new char[256];
        sym = new char[256];
        zap = new char[256];
        for (int i = 0; i < 256; ++i) {
            Encoding.se[i] = 63;
            Encoding.mre[i] = 63;
            Encoding.wae[i] = 63;
            if (i > 32) {
                Encoding.wae[i] = (char)h.get("bullet").intValue();
            }
            Encoding.pde[i] = 63;
            Encoding.sym[i] = 63;
            Encoding.zap[i] = 63;
        }
        Encoding.pde[24] = (char)h.get("breve").intValue();
        Encoding.pde[25] = (char)h.get("caron").intValue();
        Encoding.pde[26] = (char)h.get("circumflex").intValue();
        Encoding.pde[27] = (char)h.get("dotaccent").intValue();
        Encoding.pde[28] = (char)h.get("hungarumlaut").intValue();
        Encoding.pde[29] = (char)h.get("ogonek").intValue();
        Encoding.pde[30] = (char)h.get("ring").intValue();
        Encoding.pde[31] = (char)h.get("tilde").intValue();
        Encoding.se[32] = (char)h.get("space").intValue();
        Encoding.mre[32] = (char)h.get("space").intValue();
        Encoding.wae[32] = (char)h.get("space").intValue();
        Encoding.pde[32] = (char)h.get("space").intValue();
        Encoding.se[33] = (char)h.get("exclam").intValue();
        Encoding.mre[33] = (char)h.get("exclam").intValue();
        Encoding.wae[33] = (char)h.get("exclam").intValue();
        Encoding.pde[33] = (char)h.get("exclam").intValue();
        Encoding.se[34] = (char)h.get("quotedbl").intValue();
        Encoding.mre[34] = (char)h.get("quotedbl").intValue();
        Encoding.wae[34] = (char)h.get("quotedbl").intValue();
        Encoding.pde[34] = (char)h.get("quotedbl").intValue();
        Encoding.se[35] = (char)h.get("numbersign").intValue();
        Encoding.mre[35] = (char)h.get("numbersign").intValue();
        Encoding.wae[35] = (char)h.get("numbersign").intValue();
        Encoding.pde[35] = (char)h.get("numbersign").intValue();
        Encoding.se[36] = (char)h.get("dollar").intValue();
        Encoding.mre[36] = (char)h.get("dollar").intValue();
        Encoding.wae[36] = (char)h.get("dollar").intValue();
        Encoding.pde[36] = (char)h.get("dollar").intValue();
        Encoding.se[37] = (char)h.get("percent").intValue();
        Encoding.mre[37] = (char)h.get("percent").intValue();
        Encoding.wae[37] = (char)h.get("percent").intValue();
        Encoding.pde[37] = (char)h.get("percent").intValue();
        Encoding.se[38] = (char)h.get("ampersand").intValue();
        Encoding.mre[38] = (char)h.get("ampersand").intValue();
        Encoding.wae[38] = (char)h.get("ampersand").intValue();
        Encoding.pde[38] = (char)h.get("ampersand").intValue();
        Encoding.se[39] = (char)h.get("quoteright").intValue();
        Encoding.mre[39] = (char)h.get("quotesingle").intValue();
        Encoding.wae[39] = (char)h.get("quotesingle").intValue();
        Encoding.pde[39] = (char)h.get("quotesingle").intValue();
        Encoding.se[40] = (char)h.get("parenleft").intValue();
        Encoding.mre[40] = (char)h.get("parenleft").intValue();
        Encoding.wae[40] = (char)h.get("parenleft").intValue();
        Encoding.pde[40] = (char)h.get("parenleft").intValue();
        Encoding.se[41] = (char)h.get("parenright").intValue();
        Encoding.mre[41] = (char)h.get("parenright").intValue();
        Encoding.wae[41] = (char)h.get("parenright").intValue();
        Encoding.pde[41] = (char)h.get("parenright").intValue();
        Encoding.se[42] = (char)h.get("asterisk").intValue();
        Encoding.mre[42] = (char)h.get("asterisk").intValue();
        Encoding.wae[42] = (char)h.get("asterisk").intValue();
        Encoding.pde[42] = (char)h.get("asterisk").intValue();
        Encoding.se[43] = (char)h.get("plus").intValue();
        Encoding.mre[43] = (char)h.get("plus").intValue();
        Encoding.wae[43] = (char)h.get("plus").intValue();
        Encoding.pde[43] = (char)h.get("plus").intValue();
        Encoding.se[44] = (char)h.get("comma").intValue();
        Encoding.mre[44] = (char)h.get("comma").intValue();
        Encoding.wae[44] = (char)h.get("comma").intValue();
        Encoding.pde[44] = (char)h.get("comma").intValue();
        Encoding.se[45] = (char)h.get("hyphen").intValue();
        Encoding.mre[45] = (char)h.get("hyphen").intValue();
        Encoding.wae[45] = (char)h.get("hyphen").intValue();
        Encoding.pde[45] = (char)h.get("hyphen").intValue();
        Encoding.se[46] = (char)h.get("period").intValue();
        Encoding.mre[46] = (char)h.get("period").intValue();
        Encoding.wae[46] = (char)h.get("period").intValue();
        Encoding.pde[46] = (char)h.get("period").intValue();
        Encoding.se[47] = (char)h.get("slash").intValue();
        Encoding.mre[47] = (char)h.get("slash").intValue();
        Encoding.wae[47] = (char)h.get("slash").intValue();
        Encoding.pde[47] = (char)h.get("slash").intValue();
        Encoding.se[48] = (char)h.get("zero").intValue();
        Encoding.mre[48] = (char)h.get("zero").intValue();
        Encoding.wae[48] = (char)h.get("zero").intValue();
        Encoding.pde[48] = (char)h.get("zero").intValue();
        Encoding.se[49] = (char)h.get("one").intValue();
        Encoding.mre[49] = (char)h.get("one").intValue();
        Encoding.wae[49] = (char)h.get("one").intValue();
        Encoding.pde[49] = (char)h.get("one").intValue();
        Encoding.se[50] = (char)h.get("two").intValue();
        Encoding.mre[50] = (char)h.get("two").intValue();
        Encoding.wae[50] = (char)h.get("two").intValue();
        Encoding.pde[50] = (char)h.get("two").intValue();
        Encoding.se[51] = (char)h.get("three").intValue();
        Encoding.mre[51] = (char)h.get("three").intValue();
        Encoding.wae[51] = (char)h.get("three").intValue();
        Encoding.pde[51] = (char)h.get("three").intValue();
        Encoding.se[52] = (char)h.get("four").intValue();
        Encoding.mre[52] = (char)h.get("four").intValue();
        Encoding.wae[52] = (char)h.get("four").intValue();
        Encoding.pde[52] = (char)h.get("four").intValue();
        Encoding.se[53] = (char)h.get("five").intValue();
        Encoding.mre[53] = (char)h.get("five").intValue();
        Encoding.wae[53] = (char)h.get("five").intValue();
        Encoding.pde[53] = (char)h.get("five").intValue();
        Encoding.se[54] = (char)h.get("six").intValue();
        Encoding.mre[54] = (char)h.get("six").intValue();
        Encoding.wae[54] = (char)h.get("six").intValue();
        Encoding.pde[54] = (char)h.get("six").intValue();
        Encoding.se[55] = (char)h.get("seven").intValue();
        Encoding.mre[55] = (char)h.get("seven").intValue();
        Encoding.wae[55] = (char)h.get("seven").intValue();
        Encoding.pde[55] = (char)h.get("seven").intValue();
        Encoding.se[56] = (char)h.get("eight").intValue();
        Encoding.mre[56] = (char)h.get("eight").intValue();
        Encoding.wae[56] = (char)h.get("eight").intValue();
        Encoding.pde[56] = (char)h.get("eight").intValue();
        Encoding.se[57] = (char)h.get("nine").intValue();
        Encoding.mre[57] = (char)h.get("nine").intValue();
        Encoding.wae[57] = (char)h.get("nine").intValue();
        Encoding.pde[57] = (char)h.get("nine").intValue();
        Encoding.se[58] = (char)h.get("colon").intValue();
        Encoding.mre[58] = (char)h.get("colon").intValue();
        Encoding.wae[58] = (char)h.get("colon").intValue();
        Encoding.pde[58] = (char)h.get("colon").intValue();
        Encoding.se[59] = (char)h.get("semicolon").intValue();
        Encoding.mre[59] = (char)h.get("semicolon").intValue();
        Encoding.wae[59] = (char)h.get("semicolon").intValue();
        Encoding.pde[59] = (char)h.get("semicolon").intValue();
        Encoding.se[60] = (char)h.get("less").intValue();
        Encoding.mre[60] = (char)h.get("less").intValue();
        Encoding.wae[60] = (char)h.get("less").intValue();
        Encoding.pde[60] = (char)h.get("less").intValue();
        Encoding.se[61] = (char)h.get("equal").intValue();
        Encoding.mre[61] = (char)h.get("equal").intValue();
        Encoding.wae[61] = (char)h.get("equal").intValue();
        Encoding.pde[61] = (char)h.get("equal").intValue();
        Encoding.se[62] = (char)h.get("greater").intValue();
        Encoding.mre[62] = (char)h.get("greater").intValue();
        Encoding.wae[62] = (char)h.get("greater").intValue();
        Encoding.pde[62] = (char)h.get("greater").intValue();
        Encoding.se[63] = (char)h.get("question").intValue();
        Encoding.mre[63] = (char)h.get("question").intValue();
        Encoding.wae[63] = (char)h.get("question").intValue();
        Encoding.pde[63] = (char)h.get("question").intValue();
        Encoding.se[64] = (char)h.get("at").intValue();
        Encoding.mre[64] = (char)h.get("at").intValue();
        Encoding.wae[64] = (char)h.get("at").intValue();
        Encoding.pde[64] = (char)h.get("at").intValue();
        Encoding.se[65] = (char)h.get("A").intValue();
        Encoding.mre[65] = (char)h.get("A").intValue();
        Encoding.wae[65] = (char)h.get("A").intValue();
        Encoding.pde[65] = (char)h.get("A").intValue();
        Encoding.se[66] = (char)h.get("B").intValue();
        Encoding.mre[66] = (char)h.get("B").intValue();
        Encoding.wae[66] = (char)h.get("B").intValue();
        Encoding.pde[66] = (char)h.get("B").intValue();
        Encoding.se[67] = (char)h.get("C").intValue();
        Encoding.mre[67] = (char)h.get("C").intValue();
        Encoding.wae[67] = (char)h.get("C").intValue();
        Encoding.pde[67] = (char)h.get("C").intValue();
        Encoding.se[68] = (char)h.get("D").intValue();
        Encoding.mre[68] = (char)h.get("D").intValue();
        Encoding.wae[68] = (char)h.get("D").intValue();
        Encoding.pde[68] = (char)h.get("D").intValue();
        Encoding.se[69] = (char)h.get("E").intValue();
        Encoding.mre[69] = (char)h.get("E").intValue();
        Encoding.wae[69] = (char)h.get("E").intValue();
        Encoding.pde[69] = (char)h.get("E").intValue();
        Encoding.se[70] = (char)h.get("F").intValue();
        Encoding.mre[70] = (char)h.get("F").intValue();
        Encoding.wae[70] = (char)h.get("F").intValue();
        Encoding.pde[70] = (char)h.get("F").intValue();
        Encoding.se[71] = (char)h.get("G").intValue();
        Encoding.mre[71] = (char)h.get("G").intValue();
        Encoding.wae[71] = (char)h.get("G").intValue();
        Encoding.pde[71] = (char)h.get("G").intValue();
        Encoding.se[72] = (char)h.get("H").intValue();
        Encoding.mre[72] = (char)h.get("H").intValue();
        Encoding.wae[72] = (char)h.get("H").intValue();
        Encoding.pde[72] = (char)h.get("H").intValue();
        Encoding.se[73] = (char)h.get("I").intValue();
        Encoding.mre[73] = (char)h.get("I").intValue();
        Encoding.wae[73] = (char)h.get("I").intValue();
        Encoding.pde[73] = (char)h.get("I").intValue();
        Encoding.se[74] = (char)h.get("J").intValue();
        Encoding.mre[74] = (char)h.get("J").intValue();
        Encoding.wae[74] = (char)h.get("J").intValue();
        Encoding.pde[74] = (char)h.get("J").intValue();
        Encoding.se[75] = (char)h.get("K").intValue();
        Encoding.mre[75] = (char)h.get("K").intValue();
        Encoding.wae[75] = (char)h.get("K").intValue();
        Encoding.pde[75] = (char)h.get("K").intValue();
        Encoding.se[76] = (char)h.get("L").intValue();
        Encoding.mre[76] = (char)h.get("L").intValue();
        Encoding.wae[76] = (char)h.get("L").intValue();
        Encoding.pde[76] = (char)h.get("L").intValue();
        Encoding.se[77] = (char)h.get("M").intValue();
        Encoding.mre[77] = (char)h.get("M").intValue();
        Encoding.wae[77] = (char)h.get("M").intValue();
        Encoding.pde[77] = (char)h.get("M").intValue();
        Encoding.se[78] = (char)h.get("N").intValue();
        Encoding.mre[78] = (char)h.get("N").intValue();
        Encoding.wae[78] = (char)h.get("N").intValue();
        Encoding.pde[78] = (char)h.get("N").intValue();
        Encoding.se[79] = (char)h.get("O").intValue();
        Encoding.mre[79] = (char)h.get("O").intValue();
        Encoding.wae[79] = (char)h.get("O").intValue();
        Encoding.pde[79] = (char)h.get("O").intValue();
        Encoding.se[80] = (char)h.get("P").intValue();
        Encoding.mre[80] = (char)h.get("P").intValue();
        Encoding.wae[80] = (char)h.get("P").intValue();
        Encoding.pde[80] = (char)h.get("P").intValue();
        Encoding.se[81] = (char)h.get("Q").intValue();
        Encoding.mre[81] = (char)h.get("Q").intValue();
        Encoding.wae[81] = (char)h.get("Q").intValue();
        Encoding.pde[81] = (char)h.get("Q").intValue();
        Encoding.se[82] = (char)h.get("R").intValue();
        Encoding.mre[82] = (char)h.get("R").intValue();
        Encoding.wae[82] = (char)h.get("R").intValue();
        Encoding.pde[82] = (char)h.get("R").intValue();
        Encoding.se[83] = (char)h.get("S").intValue();
        Encoding.mre[83] = (char)h.get("S").intValue();
        Encoding.wae[83] = (char)h.get("S").intValue();
        Encoding.pde[83] = (char)h.get("S").intValue();
        Encoding.se[84] = (char)h.get("T").intValue();
        Encoding.mre[84] = (char)h.get("T").intValue();
        Encoding.wae[84] = (char)h.get("T").intValue();
        Encoding.pde[84] = (char)h.get("T").intValue();
        Encoding.se[85] = (char)h.get("U").intValue();
        Encoding.mre[85] = (char)h.get("U").intValue();
        Encoding.wae[85] = (char)h.get("U").intValue();
        Encoding.pde[85] = (char)h.get("U").intValue();
        Encoding.se[86] = (char)h.get("V").intValue();
        Encoding.mre[86] = (char)h.get("V").intValue();
        Encoding.wae[86] = (char)h.get("V").intValue();
        Encoding.pde[86] = (char)h.get("V").intValue();
        Encoding.se[87] = (char)h.get("W").intValue();
        Encoding.mre[87] = (char)h.get("W").intValue();
        Encoding.wae[87] = (char)h.get("W").intValue();
        Encoding.pde[87] = (char)h.get("W").intValue();
        Encoding.se[88] = (char)h.get("X").intValue();
        Encoding.mre[88] = (char)h.get("X").intValue();
        Encoding.wae[88] = (char)h.get("X").intValue();
        Encoding.pde[88] = (char)h.get("X").intValue();
        Encoding.se[89] = (char)h.get("Y").intValue();
        Encoding.mre[89] = (char)h.get("Y").intValue();
        Encoding.wae[89] = (char)h.get("Y").intValue();
        Encoding.pde[89] = (char)h.get("Y").intValue();
        Encoding.se[90] = (char)h.get("Z").intValue();
        Encoding.mre[90] = (char)h.get("Z").intValue();
        Encoding.wae[90] = (char)h.get("Z").intValue();
        Encoding.pde[90] = (char)h.get("Z").intValue();
        Encoding.se[91] = (char)h.get("bracketleft").intValue();
        Encoding.mre[91] = (char)h.get("bracketleft").intValue();
        Encoding.wae[91] = (char)h.get("bracketleft").intValue();
        Encoding.pde[91] = (char)h.get("bracketleft").intValue();
        Encoding.se[92] = (char)h.get("backslash").intValue();
        Encoding.mre[92] = (char)h.get("backslash").intValue();
        Encoding.wae[92] = (char)h.get("backslash").intValue();
        Encoding.pde[92] = (char)h.get("backslash").intValue();
        Encoding.se[93] = (char)h.get("bracketright").intValue();
        Encoding.mre[93] = (char)h.get("bracketright").intValue();
        Encoding.wae[93] = (char)h.get("bracketright").intValue();
        Encoding.pde[93] = (char)h.get("bracketright").intValue();
        Encoding.se[94] = (char)h.get("asciicircum").intValue();
        Encoding.mre[94] = (char)h.get("asciicircum").intValue();
        Encoding.wae[94] = (char)h.get("asciicircum").intValue();
        Encoding.pde[94] = (char)h.get("asciicircum").intValue();
        Encoding.se[95] = (char)h.get("underscore").intValue();
        Encoding.mre[95] = (char)h.get("underscore").intValue();
        Encoding.wae[95] = (char)h.get("underscore").intValue();
        Encoding.pde[95] = (char)h.get("underscore").intValue();
        Encoding.se[96] = (char)h.get("quoteleft").intValue();
        Encoding.mre[96] = (char)h.get("grave").intValue();
        Encoding.wae[96] = (char)h.get("grave").intValue();
        Encoding.pde[96] = (char)h.get("grave").intValue();
        Encoding.se[97] = (char)h.get("a").intValue();
        Encoding.mre[97] = (char)h.get("a").intValue();
        Encoding.wae[97] = (char)h.get("a").intValue();
        Encoding.pde[97] = (char)h.get("a").intValue();
        Encoding.se[98] = (char)h.get("b").intValue();
        Encoding.mre[98] = (char)h.get("b").intValue();
        Encoding.wae[98] = (char)h.get("b").intValue();
        Encoding.pde[98] = (char)h.get("b").intValue();
        Encoding.se[99] = (char)h.get("c").intValue();
        Encoding.mre[99] = (char)h.get("c").intValue();
        Encoding.wae[99] = (char)h.get("c").intValue();
        Encoding.pde[99] = (char)h.get("c").intValue();
        Encoding.se[100] = (char)h.get("d").intValue();
        Encoding.mre[100] = (char)h.get("d").intValue();
        Encoding.wae[100] = (char)h.get("d").intValue();
        Encoding.pde[100] = (char)h.get("d").intValue();
        Encoding.se[101] = (char)h.get("e").intValue();
        Encoding.mre[101] = (char)h.get("e").intValue();
        Encoding.wae[101] = (char)h.get("e").intValue();
        Encoding.pde[101] = (char)h.get("e").intValue();
        Encoding.se[102] = (char)h.get("f").intValue();
        Encoding.mre[102] = (char)h.get("f").intValue();
        Encoding.wae[102] = (char)h.get("f").intValue();
        Encoding.pde[102] = (char)h.get("f").intValue();
        Encoding.se[103] = (char)h.get("g").intValue();
        Encoding.mre[103] = (char)h.get("g").intValue();
        Encoding.wae[103] = (char)h.get("g").intValue();
        Encoding.pde[103] = (char)h.get("g").intValue();
        Encoding.se[104] = (char)h.get("h").intValue();
        Encoding.mre[104] = (char)h.get("h").intValue();
        Encoding.wae[104] = (char)h.get("h").intValue();
        Encoding.pde[104] = (char)h.get("h").intValue();
        Encoding.se[105] = (char)h.get("i").intValue();
        Encoding.mre[105] = (char)h.get("i").intValue();
        Encoding.wae[105] = (char)h.get("i").intValue();
        Encoding.pde[105] = (char)h.get("i").intValue();
        Encoding.se[106] = (char)h.get("j").intValue();
        Encoding.mre[106] = (char)h.get("j").intValue();
        Encoding.wae[106] = (char)h.get("j").intValue();
        Encoding.pde[106] = (char)h.get("j").intValue();
        Encoding.se[107] = (char)h.get("k").intValue();
        Encoding.mre[107] = (char)h.get("k").intValue();
        Encoding.wae[107] = (char)h.get("k").intValue();
        Encoding.pde[107] = (char)h.get("k").intValue();
        Encoding.se[108] = (char)h.get("l").intValue();
        Encoding.mre[108] = (char)h.get("l").intValue();
        Encoding.wae[108] = (char)h.get("l").intValue();
        Encoding.pde[108] = (char)h.get("l").intValue();
        Encoding.se[109] = (char)h.get("m").intValue();
        Encoding.mre[109] = (char)h.get("m").intValue();
        Encoding.wae[109] = (char)h.get("m").intValue();
        Encoding.pde[109] = (char)h.get("m").intValue();
        Encoding.se[110] = (char)h.get("n").intValue();
        Encoding.mre[110] = (char)h.get("n").intValue();
        Encoding.wae[110] = (char)h.get("n").intValue();
        Encoding.pde[110] = (char)h.get("n").intValue();
        Encoding.se[111] = (char)h.get("o").intValue();
        Encoding.mre[111] = (char)h.get("o").intValue();
        Encoding.wae[111] = (char)h.get("o").intValue();
        Encoding.pde[111] = (char)h.get("o").intValue();
        Encoding.se[112] = (char)h.get("p").intValue();
        Encoding.mre[112] = (char)h.get("p").intValue();
        Encoding.wae[112] = (char)h.get("p").intValue();
        Encoding.pde[112] = (char)h.get("p").intValue();
        Encoding.se[113] = (char)h.get("q").intValue();
        Encoding.mre[113] = (char)h.get("q").intValue();
        Encoding.wae[113] = (char)h.get("q").intValue();
        Encoding.pde[113] = (char)h.get("q").intValue();
        Encoding.se[114] = (char)h.get("r").intValue();
        Encoding.mre[114] = (char)h.get("r").intValue();
        Encoding.wae[114] = (char)h.get("r").intValue();
        Encoding.pde[114] = (char)h.get("r").intValue();
        Encoding.se[115] = (char)h.get("s").intValue();
        Encoding.mre[115] = (char)h.get("s").intValue();
        Encoding.wae[115] = (char)h.get("s").intValue();
        Encoding.pde[115] = (char)h.get("s").intValue();
        Encoding.se[116] = (char)h.get("t").intValue();
        Encoding.mre[116] = (char)h.get("t").intValue();
        Encoding.wae[116] = (char)h.get("t").intValue();
        Encoding.pde[116] = (char)h.get("t").intValue();
        Encoding.se[117] = (char)h.get("u").intValue();
        Encoding.mre[117] = (char)h.get("u").intValue();
        Encoding.wae[117] = (char)h.get("u").intValue();
        Encoding.pde[117] = (char)h.get("u").intValue();
        Encoding.se[118] = (char)h.get("v").intValue();
        Encoding.mre[118] = (char)h.get("v").intValue();
        Encoding.wae[118] = (char)h.get("v").intValue();
        Encoding.pde[118] = (char)h.get("v").intValue();
        Encoding.se[119] = (char)h.get("w").intValue();
        Encoding.mre[119] = (char)h.get("w").intValue();
        Encoding.wae[119] = (char)h.get("w").intValue();
        Encoding.pde[119] = (char)h.get("w").intValue();
        Encoding.se[120] = (char)h.get("x").intValue();
        Encoding.mre[120] = (char)h.get("x").intValue();
        Encoding.wae[120] = (char)h.get("x").intValue();
        Encoding.pde[120] = (char)h.get("x").intValue();
        Encoding.se[121] = (char)h.get("y").intValue();
        Encoding.mre[121] = (char)h.get("y").intValue();
        Encoding.wae[121] = (char)h.get("y").intValue();
        Encoding.pde[121] = (char)h.get("y").intValue();
        Encoding.se[122] = (char)h.get("z").intValue();
        Encoding.mre[122] = (char)h.get("z").intValue();
        Encoding.wae[122] = (char)h.get("z").intValue();
        Encoding.pde[122] = (char)h.get("z").intValue();
        Encoding.se[123] = (char)h.get("braceleft").intValue();
        Encoding.mre[123] = (char)h.get("braceleft").intValue();
        Encoding.wae[123] = (char)h.get("braceleft").intValue();
        Encoding.pde[123] = (char)h.get("braceleft").intValue();
        Encoding.se[124] = (char)h.get("bar").intValue();
        Encoding.mre[124] = (char)h.get("bar").intValue();
        Encoding.wae[124] = (char)h.get("bar").intValue();
        Encoding.pde[124] = (char)h.get("bar").intValue();
        Encoding.se[125] = (char)h.get("braceright").intValue();
        Encoding.mre[125] = (char)h.get("braceright").intValue();
        Encoding.wae[125] = (char)h.get("braceright").intValue();
        Encoding.pde[125] = (char)h.get("braceright").intValue();
        Encoding.se[126] = (char)h.get("asciitilde").intValue();
        Encoding.mre[126] = (char)h.get("asciitilde").intValue();
        Encoding.wae[126] = (char)h.get("asciitilde").intValue();
        Encoding.pde[126] = (char)h.get("asciitilde").intValue();
        Encoding.wae[127] = (char)h.get("bullet").intValue();
        Encoding.mre[128] = (char)h.get("Adieresis").intValue();
        Encoding.wae[128] = (char)h.get("Euro").intValue();
        Encoding.pde[128] = (char)h.get("bullet").intValue();
        Encoding.mre[129] = (char)h.get("Aring").intValue();
        Encoding.wae[129] = (char)h.get("bullet").intValue();
        Encoding.pde[129] = (char)h.get("dagger").intValue();
        Encoding.mre[130] = (char)h.get("Ccedilla").intValue();
        Encoding.wae[130] = (char)h.get("quotesinglbase").intValue();
        Encoding.pde[130] = (char)h.get("daggerdbl").intValue();
        Encoding.mre[131] = (char)h.get("Eacute").intValue();
        Encoding.wae[131] = (char)h.get("florin").intValue();
        Encoding.pde[131] = (char)h.get("ellipsis").intValue();
        Encoding.mre[132] = (char)h.get("Ntilde").intValue();
        Encoding.wae[132] = (char)h.get("quotedblbase").intValue();
        Encoding.pde[132] = (char)h.get("emdash").intValue();
        Encoding.mre[133] = (char)h.get("Odieresis").intValue();
        Encoding.wae[133] = (char)h.get("ellipsis").intValue();
        Encoding.pde[133] = (char)h.get("endash").intValue();
        Encoding.mre[134] = (char)h.get("Udieresis").intValue();
        Encoding.wae[134] = (char)h.get("dagger").intValue();
        Encoding.pde[134] = (char)h.get("florin").intValue();
        Encoding.mre[135] = (char)h.get("aacute").intValue();
        Encoding.wae[135] = (char)h.get("daggerdbl").intValue();
        Encoding.pde[135] = (char)h.get("fraction").intValue();
        Encoding.mre[136] = (char)h.get("agrave").intValue();
        Encoding.wae[136] = (char)h.get("circumflex").intValue();
        Encoding.pde[136] = (char)h.get("guilsinglleft").intValue();
        Encoding.mre[137] = (char)h.get("acircumflex").intValue();
        Encoding.wae[137] = (char)h.get("perthousand").intValue();
        Encoding.pde[137] = (char)h.get("guilsinglright").intValue();
        Encoding.mre[138] = (char)h.get("adieresis").intValue();
        Encoding.wae[138] = (char)h.get("Scaron").intValue();
        Encoding.pde[138] = (char)h.get("minus").intValue();
        Encoding.mre[139] = (char)h.get("atilde").intValue();
        Encoding.wae[139] = (char)h.get("guilsinglleft").intValue();
        Encoding.pde[139] = (char)h.get("perthousand").intValue();
        Encoding.mre[140] = (char)h.get("aring").intValue();
        Encoding.wae[140] = (char)h.get("OE").intValue();
        Encoding.pde[140] = (char)h.get("quotedblbase").intValue();
        Encoding.mre[141] = (char)h.get("ccedilla").intValue();
        Encoding.wae[141] = (char)h.get("bullet").intValue();
        Encoding.pde[141] = (char)h.get("quotedblleft").intValue();
        Encoding.mre[142] = (char)h.get("eacute").intValue();
        Encoding.wae[142] = (char)h.get("Zcaron").intValue();
        Encoding.pde[142] = (char)h.get("quotedblright").intValue();
        Encoding.mre[143] = (char)h.get("egrave").intValue();
        Encoding.wae[143] = (char)h.get("bullet").intValue();
        Encoding.pde[143] = (char)h.get("quoteleft").intValue();
        Encoding.mre[144] = (char)h.get("ecircumflex").intValue();
        Encoding.wae[144] = (char)h.get("bullet").intValue();
        Encoding.pde[144] = (char)h.get("quoteright").intValue();
        Encoding.mre[145] = (char)h.get("edieresis").intValue();
        Encoding.wae[145] = (char)h.get("quoteleft").intValue();
        Encoding.pde[145] = (char)h.get("quotesinglbase").intValue();
        Encoding.mre[146] = (char)h.get("iacute").intValue();
        Encoding.wae[146] = (char)h.get("quoteright").intValue();
        Encoding.pde[146] = (char)h.get("trademark").intValue();
        Encoding.mre[147] = (char)h.get("igrave").intValue();
        Encoding.wae[147] = (char)h.get("quotedblleft").intValue();
        Encoding.pde[147] = (char)h.get("fi").intValue();
        Encoding.mre[148] = (char)h.get("icircumflex").intValue();
        Encoding.wae[148] = (char)h.get("quotedblright").intValue();
        Encoding.pde[148] = (char)h.get("fl").intValue();
        Encoding.mre[149] = (char)h.get("idieresis").intValue();
        Encoding.wae[149] = (char)h.get("bullet").intValue();
        Encoding.pde[149] = (char)h.get("Lslash").intValue();
        Encoding.mre[150] = (char)h.get("ntilde").intValue();
        Encoding.wae[150] = (char)h.get("endash").intValue();
        Encoding.pde[150] = (char)h.get("OE").intValue();
        Encoding.mre[151] = (char)h.get("oacute").intValue();
        Encoding.wae[151] = (char)h.get("emdash").intValue();
        Encoding.pde[151] = (char)h.get("Scaron").intValue();
        Encoding.mre[152] = (char)h.get("ograve").intValue();
        Encoding.wae[152] = (char)h.get("tilde").intValue();
        Encoding.pde[152] = (char)h.get("Ydieresis").intValue();
        Encoding.mre[153] = (char)h.get("ocircumflex").intValue();
        Encoding.wae[153] = (char)h.get("trademark").intValue();
        Encoding.pde[153] = (char)h.get("Zcaron").intValue();
        Encoding.mre[154] = (char)h.get("odieresis").intValue();
        Encoding.wae[154] = (char)h.get("scaron").intValue();
        Encoding.pde[154] = (char)h.get("dotlessi").intValue();
        Encoding.mre[155] = (char)h.get("otilde").intValue();
        Encoding.wae[155] = (char)h.get("guilsinglright").intValue();
        Encoding.pde[155] = (char)h.get("lslash").intValue();
        Encoding.mre[156] = (char)h.get("uacute").intValue();
        Encoding.wae[156] = (char)h.get("oe").intValue();
        Encoding.pde[156] = (char)h.get("oe").intValue();
        Encoding.mre[157] = (char)h.get("ugrave").intValue();
        Encoding.wae[157] = (char)h.get("bullet").intValue();
        Encoding.pde[157] = (char)h.get("scaron").intValue();
        Encoding.mre[158] = (char)h.get("ucircumflex").intValue();
        Encoding.wae[158] = (char)h.get("zcaron").intValue();
        Encoding.pde[158] = (char)h.get("zcaron").intValue();
        Encoding.mre[159] = (char)h.get("udieresis").intValue();
        Encoding.wae[159] = (char)h.get("Ydieresis").intValue();
        Encoding.mre[160] = (char)h.get("dagger").intValue();
        Encoding.wae[160] = (char)h.get("space").intValue();
        Encoding.pde[160] = (char)h.get("Euro").intValue();
        Encoding.se[161] = (char)h.get("exclamdown").intValue();
        Encoding.mre[161] = (char)h.get("degree").intValue();
        Encoding.wae[161] = (char)h.get("exclamdown").intValue();
        Encoding.pde[161] = (char)h.get("exclamdown").intValue();
        Encoding.se[162] = (char)h.get("cent").intValue();
        Encoding.mre[162] = (char)h.get("cent").intValue();
        Encoding.wae[162] = (char)h.get("cent").intValue();
        Encoding.pde[162] = (char)h.get("cent").intValue();
        Encoding.se[163] = (char)h.get("sterling").intValue();
        Encoding.mre[163] = (char)h.get("sterling").intValue();
        Encoding.wae[163] = (char)h.get("sterling").intValue();
        Encoding.pde[163] = (char)h.get("sterling").intValue();
        Encoding.se[164] = (char)h.get("fraction").intValue();
        Encoding.mre[164] = (char)h.get("section").intValue();
        Encoding.wae[164] = (char)h.get("currency").intValue();
        Encoding.pde[164] = (char)h.get("currency").intValue();
        Encoding.se[165] = (char)h.get("yen").intValue();
        Encoding.mre[165] = (char)h.get("bullet").intValue();
        Encoding.wae[165] = (char)h.get("yen").intValue();
        Encoding.pde[165] = (char)h.get("yen").intValue();
        Encoding.se[166] = (char)h.get("florin").intValue();
        Encoding.mre[166] = (char)h.get("paragraph").intValue();
        Encoding.wae[166] = (char)h.get("brokenbar").intValue();
        Encoding.pde[166] = (char)h.get("brokenbar").intValue();
        Encoding.se[167] = (char)h.get("section").intValue();
        Encoding.mre[167] = (char)h.get("germandbls").intValue();
        Encoding.wae[167] = (char)h.get("section").intValue();
        Encoding.pde[167] = (char)h.get("section").intValue();
        Encoding.se[168] = (char)h.get("currency").intValue();
        Encoding.mre[168] = (char)h.get("registered").intValue();
        Encoding.wae[168] = (char)h.get("dieresis").intValue();
        Encoding.pde[168] = (char)h.get("dieresis").intValue();
        Encoding.se[169] = (char)h.get("quotesingle").intValue();
        Encoding.mre[169] = (char)h.get("copyright").intValue();
        Encoding.wae[169] = (char)h.get("copyright").intValue();
        Encoding.pde[169] = (char)h.get("copyright").intValue();
        Encoding.se[170] = (char)h.get("quotedblleft").intValue();
        Encoding.mre[170] = (char)h.get("trademark").intValue();
        Encoding.wae[170] = (char)h.get("ordfeminine").intValue();
        Encoding.pde[170] = (char)h.get("ordfeminine").intValue();
        Encoding.se[171] = (char)h.get("guillemotleft").intValue();
        Encoding.mre[171] = (char)h.get("acute").intValue();
        Encoding.wae[171] = (char)h.get("guillemotleft").intValue();
        Encoding.pde[171] = (char)h.get("guillemotleft").intValue();
        Encoding.se[172] = (char)h.get("guilsinglleft").intValue();
        Encoding.mre[172] = (char)h.get("dieresis").intValue();
        Encoding.wae[172] = (char)h.get("logicalnot").intValue();
        Encoding.pde[172] = (char)h.get("logicalnot").intValue();
        Encoding.se[173] = (char)h.get("guilsinglright").intValue();
        Encoding.wae[173] = (char)h.get("hyphen").intValue();
        Encoding.se[174] = (char)h.get("fi").intValue();
        Encoding.mre[174] = (char)h.get("AE").intValue();
        Encoding.wae[174] = (char)h.get("registered").intValue();
        Encoding.pde[174] = (char)h.get("registered").intValue();
        Encoding.se[175] = (char)h.get("fl").intValue();
        Encoding.mre[175] = (char)h.get("Oslash").intValue();
        Encoding.wae[175] = (char)h.get("macron").intValue();
        Encoding.pde[175] = (char)h.get("macron").intValue();
        Encoding.wae[176] = (char)h.get("degree").intValue();
        Encoding.pde[176] = (char)h.get("degree").intValue();
        Encoding.se[177] = (char)h.get("endash").intValue();
        Encoding.mre[177] = (char)h.get("plusminus").intValue();
        Encoding.wae[177] = (char)h.get("plusminus").intValue();
        Encoding.pde[177] = (char)h.get("plusminus").intValue();
        Encoding.se[178] = (char)h.get("dagger").intValue();
        Encoding.wae[178] = (char)h.get("twosuperior").intValue();
        Encoding.pde[178] = (char)h.get("twosuperior").intValue();
        Encoding.se[179] = (char)h.get("daggerdbl").intValue();
        Encoding.wae[179] = (char)h.get("threesuperior").intValue();
        Encoding.pde[179] = (char)h.get("threesuperior").intValue();
        Encoding.se[180] = (char)h.get("periodcentered").intValue();
        Encoding.mre[180] = (char)h.get("yen").intValue();
        Encoding.wae[180] = (char)h.get("acute").intValue();
        Encoding.pde[180] = (char)h.get("acute").intValue();
        Encoding.mre[181] = (char)h.get("mu").intValue();
        Encoding.wae[181] = (char)h.get("mu").intValue();
        Encoding.pde[181] = (char)h.get("mu").intValue();
        Encoding.se[182] = (char)h.get("paragraph").intValue();
        Encoding.wae[182] = (char)h.get("paragraph").intValue();
        Encoding.pde[182] = (char)h.get("paragraph").intValue();
        Encoding.se[183] = (char)h.get("bullet").intValue();
        Encoding.wae[183] = (char)h.get("periodcentered").intValue();
        Encoding.pde[183] = (char)h.get("periodcentered").intValue();
        Encoding.se[184] = (char)h.get("quotesinglbase").intValue();
        Encoding.wae[184] = (char)h.get("cedilla").intValue();
        Encoding.pde[184] = (char)h.get("cedilla").intValue();
        Encoding.se[185] = (char)h.get("quotedblbase").intValue();
        Encoding.wae[185] = (char)h.get("onesuperior").intValue();
        Encoding.pde[185] = (char)h.get("onesuperior").intValue();
        Encoding.se[186] = (char)h.get("quotedblright").intValue();
        Encoding.wae[186] = (char)h.get("ordmasculine").intValue();
        Encoding.pde[186] = (char)h.get("ordmasculine").intValue();
        Encoding.se[187] = (char)h.get("guillemotright").intValue();
        Encoding.mre[187] = (char)h.get("ordfeminine").intValue();
        Encoding.wae[187] = (char)h.get("guillemotright").intValue();
        Encoding.pde[187] = (char)h.get("guillemotright").intValue();
        Encoding.se[188] = (char)h.get("ellipsis").intValue();
        Encoding.mre[188] = (char)h.get("ordmasculine").intValue();
        Encoding.wae[188] = (char)h.get("onequarter").intValue();
        Encoding.pde[188] = (char)h.get("onequarter").intValue();
        Encoding.se[189] = (char)h.get("perthousand").intValue();
        Encoding.wae[189] = (char)h.get("onehalf").intValue();
        Encoding.pde[189] = (char)h.get("onehalf").intValue();
        Encoding.mre[190] = (char)h.get("ae").intValue();
        Encoding.wae[190] = (char)h.get("threequarters").intValue();
        Encoding.pde[190] = (char)h.get("threequarters").intValue();
        Encoding.se[191] = (char)h.get("questiondown").intValue();
        Encoding.mre[191] = (char)h.get("oslash").intValue();
        Encoding.wae[191] = (char)h.get("questiondown").intValue();
        Encoding.pde[191] = (char)h.get("questiondown").intValue();
        Encoding.mre[192] = (char)h.get("questiondown").intValue();
        Encoding.wae[192] = (char)h.get("Agrave").intValue();
        Encoding.pde[192] = (char)h.get("Agrave").intValue();
        Encoding.se[193] = (char)h.get("grave").intValue();
        Encoding.mre[193] = (char)h.get("exclamdown").intValue();
        Encoding.wae[193] = (char)h.get("Aacute").intValue();
        Encoding.pde[193] = (char)h.get("Aacute").intValue();
        Encoding.se[194] = (char)h.get("acute").intValue();
        Encoding.mre[194] = (char)h.get("logicalnot").intValue();
        Encoding.wae[194] = (char)h.get("Acircumflex").intValue();
        Encoding.pde[194] = (char)h.get("Acircumflex").intValue();
        Encoding.se[195] = (char)h.get("circumflex").intValue();
        Encoding.wae[195] = (char)h.get("Atilde").intValue();
        Encoding.pde[195] = (char)h.get("Atilde").intValue();
        Encoding.se[196] = (char)h.get("tilde").intValue();
        Encoding.mre[196] = (char)h.get("florin").intValue();
        Encoding.wae[196] = (char)h.get("Adieresis").intValue();
        Encoding.pde[196] = (char)h.get("Adieresis").intValue();
        Encoding.se[197] = (char)h.get("macron").intValue();
        Encoding.wae[197] = (char)h.get("Aring").intValue();
        Encoding.pde[197] = (char)h.get("Aring").intValue();
        Encoding.se[198] = (char)h.get("breve").intValue();
        Encoding.wae[198] = (char)h.get("AE").intValue();
        Encoding.pde[198] = (char)h.get("AE").intValue();
        Encoding.se[199] = (char)h.get("dotaccent").intValue();
        Encoding.mre[199] = (char)h.get("guillemotleft").intValue();
        Encoding.wae[199] = (char)h.get("Ccedilla").intValue();
        Encoding.pde[199] = (char)h.get("Ccedilla").intValue();
        Encoding.se[200] = (char)h.get("dieresis").intValue();
        Encoding.mre[200] = (char)h.get("guillemotright").intValue();
        Encoding.wae[200] = (char)h.get("Egrave").intValue();
        Encoding.pde[200] = (char)h.get("Egrave").intValue();
        Encoding.mre[201] = (char)h.get("ellipsis").intValue();
        Encoding.wae[201] = (char)h.get("Eacute").intValue();
        Encoding.pde[201] = (char)h.get("Eacute").intValue();
        Encoding.se[202] = (char)h.get("ring").intValue();
        Encoding.mre[202] = (char)h.get("space").intValue();
        Encoding.wae[202] = (char)h.get("Ecircumflex").intValue();
        Encoding.pde[202] = (char)h.get("Ecircumflex").intValue();
        Encoding.se[203] = (char)h.get("cedilla").intValue();
        Encoding.mre[203] = (char)h.get("Agrave").intValue();
        Encoding.wae[203] = (char)h.get("Edieresis").intValue();
        Encoding.pde[203] = (char)h.get("Edieresis").intValue();
        Encoding.mre[204] = (char)h.get("Atilde").intValue();
        Encoding.wae[204] = (char)h.get("Igrave").intValue();
        Encoding.pde[204] = (char)h.get("Igrave").intValue();
        Encoding.se[205] = (char)h.get("hungarumlaut").intValue();
        Encoding.mre[205] = (char)h.get("Otilde").intValue();
        Encoding.wae[205] = (char)h.get("Iacute").intValue();
        Encoding.pde[205] = (char)h.get("Iacute").intValue();
        Encoding.se[206] = (char)h.get("ogonek").intValue();
        Encoding.mre[206] = (char)h.get("OE").intValue();
        Encoding.wae[206] = (char)h.get("Icircumflex").intValue();
        Encoding.pde[206] = (char)h.get("Icircumflex").intValue();
        Encoding.se[207] = (char)h.get("caron").intValue();
        Encoding.mre[207] = (char)h.get("oe").intValue();
        Encoding.wae[207] = (char)h.get("Idieresis").intValue();
        Encoding.pde[207] = (char)h.get("Idieresis").intValue();
        Encoding.se[208] = (char)h.get("emdash").intValue();
        Encoding.mre[208] = (char)h.get("endash").intValue();
        Encoding.wae[208] = (char)h.get("Eth").intValue();
        Encoding.pde[208] = (char)h.get("Eth").intValue();
        Encoding.mre[209] = (char)h.get("emdash").intValue();
        Encoding.wae[209] = (char)h.get("Ntilde").intValue();
        Encoding.pde[209] = (char)h.get("Ntilde").intValue();
        Encoding.mre[210] = (char)h.get("quotedblleft").intValue();
        Encoding.wae[210] = (char)h.get("Ograve").intValue();
        Encoding.pde[210] = (char)h.get("Ograve").intValue();
        Encoding.mre[211] = (char)h.get("quotedblright").intValue();
        Encoding.wae[211] = (char)h.get("Oacute").intValue();
        Encoding.pde[211] = (char)h.get("Oacute").intValue();
        Encoding.mre[212] = (char)h.get("quoteleft").intValue();
        Encoding.wae[212] = (char)h.get("Ocircumflex").intValue();
        Encoding.pde[212] = (char)h.get("Ocircumflex").intValue();
        Encoding.mre[213] = (char)h.get("quoteright").intValue();
        Encoding.wae[213] = (char)h.get("Otilde").intValue();
        Encoding.pde[213] = (char)h.get("Otilde").intValue();
        Encoding.mre[214] = (char)h.get("divide").intValue();
        Encoding.wae[214] = (char)h.get("Odieresis").intValue();
        Encoding.pde[214] = (char)h.get("Odieresis").intValue();
        Encoding.wae[215] = (char)h.get("multiply").intValue();
        Encoding.pde[215] = (char)h.get("multiply").intValue();
        Encoding.mre[216] = (char)h.get("ydieresis").intValue();
        Encoding.wae[216] = (char)h.get("Oslash").intValue();
        Encoding.pde[216] = (char)h.get("Oslash").intValue();
        Encoding.mre[217] = (char)h.get("Ydieresis").intValue();
        Encoding.wae[217] = (char)h.get("Ugrave").intValue();
        Encoding.pde[217] = (char)h.get("Ugrave").intValue();
        Encoding.mre[218] = (char)h.get("fraction").intValue();
        Encoding.wae[218] = (char)h.get("Uacute").intValue();
        Encoding.pde[218] = (char)h.get("Uacute").intValue();
        Encoding.mre[219] = (char)h.get("currency").intValue();
        Encoding.wae[219] = (char)h.get("Ucircumflex").intValue();
        Encoding.pde[219] = (char)h.get("Ucircumflex").intValue();
        Encoding.mre[220] = (char)h.get("guilsinglleft").intValue();
        Encoding.wae[220] = (char)h.get("Udieresis").intValue();
        Encoding.pde[220] = (char)h.get("Udieresis").intValue();
        Encoding.mre[221] = (char)h.get("guilsinglright").intValue();
        Encoding.wae[221] = (char)h.get("Yacute").intValue();
        Encoding.pde[221] = (char)h.get("Yacute").intValue();
        Encoding.mre[222] = (char)h.get("fi").intValue();
        Encoding.wae[222] = (char)h.get("Thorn").intValue();
        Encoding.pde[222] = (char)h.get("Thorn").intValue();
        Encoding.mre[223] = (char)h.get("fl").intValue();
        Encoding.wae[223] = (char)h.get("germandbls").intValue();
        Encoding.pde[223] = (char)h.get("germandbls").intValue();
        Encoding.mre[224] = (char)h.get("daggerdbl").intValue();
        Encoding.wae[224] = (char)h.get("agrave").intValue();
        Encoding.pde[224] = (char)h.get("agrave").intValue();
        Encoding.se[225] = (char)h.get("AE").intValue();
        Encoding.mre[225] = (char)h.get("periodcentered").intValue();
        Encoding.wae[225] = (char)h.get("aacute").intValue();
        Encoding.pde[225] = (char)h.get("aacute").intValue();
        Encoding.mre[226] = (char)h.get("quotesinglbase").intValue();
        Encoding.wae[226] = (char)h.get("acircumflex").intValue();
        Encoding.pde[226] = (char)h.get("acircumflex").intValue();
        Encoding.se[227] = (char)h.get("ordfeminine").intValue();
        Encoding.mre[227] = (char)h.get("quotedblbase").intValue();
        Encoding.wae[227] = (char)h.get("atilde").intValue();
        Encoding.pde[227] = (char)h.get("atilde").intValue();
        Encoding.mre[228] = (char)h.get("perthousand").intValue();
        Encoding.wae[228] = (char)h.get("adieresis").intValue();
        Encoding.pde[228] = (char)h.get("adieresis").intValue();
        Encoding.mre[229] = (char)h.get("Acircumflex").intValue();
        Encoding.wae[229] = (char)h.get("aring").intValue();
        Encoding.pde[229] = (char)h.get("aring").intValue();
        Encoding.mre[230] = (char)h.get("Ecircumflex").intValue();
        Encoding.wae[230] = (char)h.get("ae").intValue();
        Encoding.pde[230] = (char)h.get("ae").intValue();
        Encoding.mre[231] = (char)h.get("Aacute").intValue();
        Encoding.wae[231] = (char)h.get("ccedilla").intValue();
        Encoding.pde[231] = (char)h.get("ccedilla").intValue();
        Encoding.se[232] = (char)h.get("Lslash").intValue();
        Encoding.mre[232] = (char)h.get("Edieresis").intValue();
        Encoding.wae[232] = (char)h.get("egrave").intValue();
        Encoding.pde[232] = (char)h.get("egrave").intValue();
        Encoding.se[233] = (char)h.get("Oslash").intValue();
        Encoding.mre[233] = (char)h.get("Egrave").intValue();
        Encoding.wae[233] = (char)h.get("eacute").intValue();
        Encoding.pde[233] = (char)h.get("eacute").intValue();
        Encoding.se[234] = (char)h.get("OE").intValue();
        Encoding.mre[234] = (char)h.get("Iacute").intValue();
        Encoding.wae[234] = (char)h.get("ecircumflex").intValue();
        Encoding.pde[234] = (char)h.get("ecircumflex").intValue();
        Encoding.se[235] = (char)h.get("ordmasculine").intValue();
        Encoding.mre[235] = (char)h.get("Icircumflex").intValue();
        Encoding.wae[235] = (char)h.get("edieresis").intValue();
        Encoding.pde[235] = (char)h.get("edieresis").intValue();
        Encoding.mre[236] = (char)h.get("Idieresis").intValue();
        Encoding.wae[236] = (char)h.get("igrave").intValue();
        Encoding.pde[236] = (char)h.get("igrave").intValue();
        Encoding.mre[237] = (char)h.get("Igrave").intValue();
        Encoding.wae[237] = (char)h.get("iacute").intValue();
        Encoding.pde[237] = (char)h.get("iacute").intValue();
        Encoding.mre[238] = (char)h.get("Oacute").intValue();
        Encoding.wae[238] = (char)h.get("icircumflex").intValue();
        Encoding.pde[238] = (char)h.get("icircumflex").intValue();
        Encoding.mre[239] = (char)h.get("Ocircumflex").intValue();
        Encoding.wae[239] = (char)h.get("idieresis").intValue();
        Encoding.pde[239] = (char)h.get("idieresis").intValue();
        Encoding.wae[240] = (char)h.get("eth").intValue();
        Encoding.pde[240] = (char)h.get("eth").intValue();
        Encoding.se[241] = (char)h.get("ae").intValue();
        Encoding.mre[241] = (char)h.get("Ograve").intValue();
        Encoding.wae[241] = (char)h.get("ntilde").intValue();
        Encoding.pde[241] = (char)h.get("ntilde").intValue();
        Encoding.mre[242] = (char)h.get("Uacute").intValue();
        Encoding.wae[242] = (char)h.get("ograve").intValue();
        Encoding.pde[242] = (char)h.get("ograve").intValue();
        Encoding.mre[243] = (char)h.get("Ucircumflex").intValue();
        Encoding.wae[243] = (char)h.get("oacute").intValue();
        Encoding.pde[243] = (char)h.get("oacute").intValue();
        Encoding.mre[244] = (char)h.get("Ugrave").intValue();
        Encoding.wae[244] = (char)h.get("ocircumflex").intValue();
        Encoding.pde[244] = (char)h.get("ocircumflex").intValue();
        Encoding.se[245] = (char)h.get("dotlessi").intValue();
        Encoding.mre[245] = (char)h.get("dotlessi").intValue();
        Encoding.wae[245] = (char)h.get("otilde").intValue();
        Encoding.pde[245] = (char)h.get("otilde").intValue();
        Encoding.mre[246] = (char)h.get("circumflex").intValue();
        Encoding.wae[246] = (char)h.get("odieresis").intValue();
        Encoding.pde[246] = (char)h.get("odieresis").intValue();
        Encoding.mre[247] = (char)h.get("tilde").intValue();
        Encoding.wae[247] = (char)h.get("divide").intValue();
        Encoding.pde[247] = (char)h.get("divide").intValue();
        Encoding.se[248] = (char)h.get("lslash").intValue();
        Encoding.mre[248] = (char)h.get("macron").intValue();
        Encoding.wae[248] = (char)h.get("oslash").intValue();
        Encoding.pde[248] = (char)h.get("oslash").intValue();
        Encoding.se[249] = (char)h.get("oslash").intValue();
        Encoding.mre[249] = (char)h.get("breve").intValue();
        Encoding.wae[249] = (char)h.get("ugrave").intValue();
        Encoding.pde[249] = (char)h.get("ugrave").intValue();
        Encoding.se[250] = (char)h.get("oe").intValue();
        Encoding.mre[250] = (char)h.get("dotaccent").intValue();
        Encoding.wae[250] = (char)h.get("uacute").intValue();
        Encoding.pde[250] = (char)h.get("uacute").intValue();
        Encoding.se[251] = (char)h.get("germandbls").intValue();
        Encoding.mre[251] = (char)h.get("ring").intValue();
        Encoding.wae[251] = (char)h.get("ucircumflex").intValue();
        Encoding.pde[251] = (char)h.get("ucircumflex").intValue();
        Encoding.mre[252] = (char)h.get("cedilla").intValue();
        Encoding.wae[252] = (char)h.get("udieresis").intValue();
        Encoding.pde[252] = (char)h.get("udieresis").intValue();
        Encoding.mre[253] = (char)h.get("hungarumlaut").intValue();
        Encoding.wae[253] = (char)h.get("yacute").intValue();
        Encoding.pde[253] = (char)h.get("yacute").intValue();
        Encoding.mre[254] = (char)h.get("ogonek").intValue();
        Encoding.wae[254] = (char)h.get("thorn").intValue();
        Encoding.pde[254] = (char)h.get("thorn").intValue();
        Encoding.mre[255] = (char)h.get("caron").intValue();
        Encoding.wae[255] = (char)h.get("ydieresis").intValue();
        Encoding.pde[255] = (char)h.get("ydieresis").intValue();
        Encoding.se[10] = (char)h.get("space").intValue();
        Encoding.mre[10] = (char)h.get("space").intValue();
        Encoding.wae[10] = (char)h.get("space").intValue();
        Encoding.se[13] = (char)h.get("space").intValue();
        Encoding.mre[13] = (char)h.get("space").intValue();
        Encoding.wae[13] = (char)h.get("space").intValue();
        Encoding.se[9] = (char)h.get("space").intValue();
        Encoding.mre[9] = (char)h.get("space").intValue();
        Encoding.wae[9] = (char)h.get("space").intValue();
        Encoding.sym[32] = (char)h.get("space").intValue();
        Encoding.sym[33] = (char)h.get("exclam").intValue();
        Encoding.sym[34] = (char)h.get("universal").intValue();
        Encoding.sym[35] = (char)h.get("numbersign").intValue();
        Encoding.sym[36] = (char)h.get("existential").intValue();
        Encoding.sym[37] = (char)h.get("percent").intValue();
        Encoding.sym[38] = (char)h.get("ampersand").intValue();
        Encoding.sym[39] = (char)h.get("suchthat").intValue();
        Encoding.sym[40] = (char)h.get("parenleft").intValue();
        Encoding.sym[41] = (char)h.get("parenright").intValue();
        Encoding.sym[42] = (char)h.get("asteriskmath").intValue();
        Encoding.sym[43] = (char)h.get("plus").intValue();
        Encoding.sym[44] = (char)h.get("comma").intValue();
        Encoding.sym[45] = (char)h.get("minus").intValue();
        Encoding.sym[46] = (char)h.get("period").intValue();
        Encoding.sym[47] = (char)h.get("slash").intValue();
        Encoding.sym[48] = (char)h.get("zero").intValue();
        Encoding.sym[49] = (char)h.get("one").intValue();
        Encoding.sym[50] = (char)h.get("two").intValue();
        Encoding.sym[51] = (char)h.get("three").intValue();
        Encoding.sym[52] = (char)h.get("four").intValue();
        Encoding.sym[53] = (char)h.get("five").intValue();
        Encoding.sym[54] = (char)h.get("six").intValue();
        Encoding.sym[55] = (char)h.get("seven").intValue();
        Encoding.sym[56] = (char)h.get("eight").intValue();
        Encoding.sym[57] = (char)h.get("nine").intValue();
        Encoding.sym[58] = (char)h.get("colon").intValue();
        Encoding.sym[59] = (char)h.get("semicolon").intValue();
        Encoding.sym[60] = (char)h.get("less").intValue();
        Encoding.sym[61] = (char)h.get("equal").intValue();
        Encoding.sym[62] = (char)h.get("greater").intValue();
        Encoding.sym[63] = (char)h.get("question").intValue();
        Encoding.sym[64] = (char)h.get("congruent").intValue();
        Encoding.sym[65] = (char)h.get("Alpha").intValue();
        Encoding.sym[66] = (char)h.get("Beta").intValue();
        Encoding.sym[67] = (char)h.get("Chi").intValue();
        Encoding.sym[68] = (char)h.get("Delta").intValue();
        Encoding.sym[69] = (char)h.get("Epsilon").intValue();
        Encoding.sym[70] = (char)h.get("Phi").intValue();
        Encoding.sym[71] = (char)h.get("Gamma").intValue();
        Encoding.sym[72] = (char)h.get("Eta").intValue();
        Encoding.sym[73] = (char)h.get("Iota").intValue();
        Encoding.sym[74] = (char)h.get("theta1").intValue();
        Encoding.sym[75] = (char)h.get("Kappa").intValue();
        Encoding.sym[76] = (char)h.get("Lambda").intValue();
        Encoding.sym[77] = (char)h.get("Mu").intValue();
        Encoding.sym[78] = (char)h.get("Nu").intValue();
        Encoding.sym[79] = (char)h.get("Omicron").intValue();
        Encoding.sym[80] = (char)h.get("Pi").intValue();
        Encoding.sym[81] = (char)h.get("Theta").intValue();
        Encoding.sym[82] = (char)h.get("Rho").intValue();
        Encoding.sym[83] = (char)h.get("Sigma").intValue();
        Encoding.sym[84] = (char)h.get("Tau").intValue();
        Encoding.sym[85] = (char)h.get("Upsilon").intValue();
        Encoding.sym[86] = (char)h.get("sigma1").intValue();
        Encoding.sym[87] = (char)h.get("Omega").intValue();
        Encoding.sym[88] = (char)h.get("Xi").intValue();
        Encoding.sym[89] = (char)h.get("Psi").intValue();
        Encoding.sym[90] = (char)h.get("Zeta").intValue();
        Encoding.sym[91] = (char)h.get("bracketleft").intValue();
        Encoding.sym[92] = (char)h.get("therefore").intValue();
        Encoding.sym[93] = (char)h.get("bracketright").intValue();
        Encoding.sym[94] = (char)h.get("perpendicular").intValue();
        Encoding.sym[95] = (char)h.get("underscore").intValue();
        Encoding.sym[96] = (char)h.get("radicalex").intValue();
        Encoding.sym[97] = (char)h.get("alpha").intValue();
        Encoding.sym[98] = (char)h.get("beta").intValue();
        Encoding.sym[99] = (char)h.get("chi").intValue();
        Encoding.sym[100] = (char)h.get("delta").intValue();
        Encoding.sym[101] = (char)h.get("epsilon").intValue();
        Encoding.sym[102] = (char)h.get("phi").intValue();
        Encoding.sym[103] = (char)h.get("gamma").intValue();
        Encoding.sym[104] = (char)h.get("eta").intValue();
        Encoding.sym[105] = (char)h.get("iota").intValue();
        Encoding.sym[106] = (char)h.get("phi1").intValue();
        Encoding.sym[107] = (char)h.get("kappa").intValue();
        Encoding.sym[108] = (char)h.get("lambda").intValue();
        Encoding.sym[109] = (char)h.get("mu").intValue();
        Encoding.sym[110] = (char)h.get("nu").intValue();
        Encoding.sym[111] = (char)h.get("omicron").intValue();
        Encoding.sym[112] = (char)h.get("pi").intValue();
        Encoding.sym[113] = (char)h.get("theta").intValue();
        Encoding.sym[114] = (char)h.get("rho").intValue();
        Encoding.sym[115] = (char)h.get("sigma").intValue();
        Encoding.sym[116] = (char)h.get("tau").intValue();
        Encoding.sym[117] = (char)h.get("upsilon").intValue();
        Encoding.sym[118] = (char)h.get("omega1").intValue();
        Encoding.sym[119] = (char)h.get("omega").intValue();
        Encoding.sym[120] = (char)h.get("xi").intValue();
        Encoding.sym[121] = (char)h.get("psi").intValue();
        Encoding.sym[122] = (char)h.get("zeta").intValue();
        Encoding.sym[123] = (char)h.get("braceleft").intValue();
        Encoding.sym[124] = (char)h.get("bar").intValue();
        Encoding.sym[125] = (char)h.get("braceright").intValue();
        Encoding.sym[126] = (char)h.get("similar").intValue();
        Encoding.sym[160] = (char)h.get("Euro").intValue();
        Encoding.sym[161] = (char)h.get("Upsilon1").intValue();
        Encoding.sym[162] = (char)h.get("minute").intValue();
        Encoding.sym[163] = (char)h.get("lessequal").intValue();
        Encoding.sym[164] = (char)h.get("fraction").intValue();
        Encoding.sym[165] = (char)h.get("infinity").intValue();
        Encoding.sym[166] = (char)h.get("florin").intValue();
        Encoding.sym[167] = (char)h.get("club").intValue();
        Encoding.sym[168] = (char)h.get("diamond").intValue();
        Encoding.sym[169] = (char)h.get("heart").intValue();
        Encoding.sym[170] = (char)h.get("spade").intValue();
        Encoding.sym[171] = (char)h.get("arrowboth").intValue();
        Encoding.sym[172] = (char)h.get("arrowleft").intValue();
        Encoding.sym[173] = (char)h.get("arrowup").intValue();
        Encoding.sym[174] = (char)h.get("arrowright").intValue();
        Encoding.sym[175] = (char)h.get("arrowdown").intValue();
        Encoding.sym[176] = (char)h.get("degree").intValue();
        Encoding.sym[177] = (char)h.get("plusminus").intValue();
        Encoding.sym[178] = (char)h.get("second").intValue();
        Encoding.sym[179] = (char)h.get("greaterequal").intValue();
        Encoding.sym[180] = (char)h.get("multiply").intValue();
        Encoding.sym[181] = (char)h.get("proportional").intValue();
        Encoding.sym[182] = (char)h.get("partialdiff").intValue();
        Encoding.sym[183] = (char)h.get("bullet").intValue();
        Encoding.sym[184] = (char)h.get("divide").intValue();
        Encoding.sym[185] = (char)h.get("notequal").intValue();
        Encoding.sym[186] = (char)h.get("equivalence").intValue();
        Encoding.sym[187] = (char)h.get("approxequal").intValue();
        Encoding.sym[188] = (char)h.get("ellipsis").intValue();
        Encoding.sym[189] = (char)h.get("arrowvertex").intValue();
        Encoding.sym[190] = (char)h.get("arrowhorizex").intValue();
        Encoding.sym[191] = (char)h.get("carriagereturn").intValue();
        Encoding.sym[192] = (char)h.get("aleph").intValue();
        Encoding.sym[193] = (char)h.get("Ifraktur").intValue();
        Encoding.sym[194] = (char)h.get("Rfraktur").intValue();
        Encoding.sym[195] = (char)h.get("weierstrass").intValue();
        Encoding.sym[196] = (char)h.get("circlemultiply").intValue();
        Encoding.sym[197] = (char)h.get("circleplus").intValue();
        Encoding.sym[198] = (char)h.get("emptyset").intValue();
        Encoding.sym[199] = (char)h.get("intersection").intValue();
        Encoding.sym[200] = (char)h.get("union").intValue();
        Encoding.sym[201] = (char)h.get("propersuperset").intValue();
        Encoding.sym[202] = (char)h.get("reflexsuperset").intValue();
        Encoding.sym[203] = (char)h.get("notsubset").intValue();
        Encoding.sym[204] = (char)h.get("propersubset").intValue();
        Encoding.sym[205] = (char)h.get("reflexsubset").intValue();
        Encoding.sym[206] = (char)h.get("element").intValue();
        Encoding.sym[207] = (char)h.get("notelement").intValue();
        Encoding.sym[208] = (char)h.get("angle").intValue();
        Encoding.sym[209] = (char)h.get("gradient").intValue();
        Encoding.sym[210] = (char)h.get("registerserif").intValue();
        Encoding.sym[211] = (char)h.get("copyrightserif").intValue();
        Encoding.sym[212] = (char)h.get("trademarkserif").intValue();
        Encoding.sym[213] = (char)h.get("product").intValue();
        Encoding.sym[214] = (char)h.get("radical").intValue();
        Encoding.sym[215] = (char)h.get("dotmath").intValue();
        Encoding.sym[216] = (char)h.get("logicalnot").intValue();
        Encoding.sym[217] = (char)h.get("logicaland").intValue();
        Encoding.sym[218] = (char)h.get("logicalor").intValue();
        Encoding.sym[219] = (char)h.get("arrowdblboth").intValue();
        Encoding.sym[220] = (char)h.get("arrowdblleft").intValue();
        Encoding.sym[221] = (char)h.get("arrowdblup").intValue();
        Encoding.sym[222] = (char)h.get("arrowdblright").intValue();
        Encoding.sym[223] = (char)h.get("arrowdbldown").intValue();
        Encoding.sym[224] = (char)h.get("lozenge").intValue();
        Encoding.sym[225] = (char)h.get("angleleft").intValue();
        Encoding.sym[226] = (char)h.get("registersans").intValue();
        Encoding.sym[227] = (char)h.get("copyrightsans").intValue();
        Encoding.sym[228] = (char)h.get("trademarksans").intValue();
        Encoding.sym[229] = (char)h.get("summation").intValue();
        Encoding.sym[230] = (char)h.get("parenlefttp").intValue();
        Encoding.sym[231] = (char)h.get("parenleftex").intValue();
        Encoding.sym[232] = (char)h.get("parenleftbt").intValue();
        Encoding.sym[233] = (char)h.get("bracketlefttp").intValue();
        Encoding.sym[234] = (char)h.get("bracketleftex").intValue();
        Encoding.sym[235] = (char)h.get("bracketleftbt").intValue();
        Encoding.sym[236] = (char)h.get("bracelefttp").intValue();
        Encoding.sym[237] = (char)h.get("braceleftmid").intValue();
        Encoding.sym[238] = (char)h.get("braceleftbt").intValue();
        Encoding.sym[239] = (char)h.get("braceex").intValue();
        Encoding.sym[241] = (char)h.get("angleright").intValue();
        Encoding.sym[242] = (char)h.get("integral").intValue();
        Encoding.sym[243] = (char)h.get("integraltp").intValue();
        Encoding.sym[244] = (char)h.get("integralex").intValue();
        Encoding.sym[245] = (char)h.get("integralbt").intValue();
        Encoding.sym[246] = (char)h.get("parenrighttp").intValue();
        Encoding.sym[247] = (char)h.get("parenrightex").intValue();
        Encoding.sym[248] = (char)h.get("parenrightbt").intValue();
        Encoding.sym[249] = (char)h.get("bracketrighttp").intValue();
        Encoding.sym[250] = (char)h.get("bracketrightex").intValue();
        Encoding.sym[251] = (char)h.get("bracketrightbt").intValue();
        Encoding.sym[252] = (char)h.get("bracerighttp").intValue();
        Encoding.sym[253] = (char)h.get("bracerightmid").intValue();
        Encoding.sym[254] = (char)h.get("bracerightbt").intValue();
        Encoding.zap[32] = (char)h.get("space").intValue();
        Encoding.zap[33] = (char)h.get("a1").intValue();
        Encoding.zap[34] = (char)h.get("a2").intValue();
        Encoding.zap[35] = (char)h.get("a202").intValue();
        Encoding.zap[36] = (char)h.get("a3").intValue();
        Encoding.zap[37] = (char)h.get("a4").intValue();
        Encoding.zap[38] = (char)h.get("a5").intValue();
        Encoding.zap[39] = (char)h.get("a119").intValue();
        Encoding.zap[40] = (char)h.get("a118").intValue();
        Encoding.zap[41] = (char)h.get("a117").intValue();
        Encoding.zap[42] = (char)h.get("a11").intValue();
        Encoding.zap[43] = (char)h.get("a12").intValue();
        Encoding.zap[44] = (char)h.get("a13").intValue();
        Encoding.zap[45] = (char)h.get("a14").intValue();
        Encoding.zap[46] = (char)h.get("a15").intValue();
        Encoding.zap[47] = (char)h.get("a16").intValue();
        Encoding.zap[48] = (char)h.get("a105").intValue();
        Encoding.zap[49] = (char)h.get("a17").intValue();
        Encoding.zap[50] = (char)h.get("a18").intValue();
        Encoding.zap[51] = (char)h.get("a19").intValue();
        Encoding.zap[52] = (char)h.get("a20").intValue();
        Encoding.zap[53] = (char)h.get("a21").intValue();
        Encoding.zap[54] = (char)h.get("a22").intValue();
        Encoding.zap[55] = (char)h.get("a23").intValue();
        Encoding.zap[56] = (char)h.get("a24").intValue();
        Encoding.zap[57] = (char)h.get("a25").intValue();
        Encoding.zap[58] = (char)h.get("a26").intValue();
        Encoding.zap[59] = (char)h.get("a27").intValue();
        Encoding.zap[60] = (char)h.get("a28").intValue();
        Encoding.zap[61] = (char)h.get("a6").intValue();
        Encoding.zap[62] = (char)h.get("a7").intValue();
        Encoding.zap[63] = (char)h.get("a8").intValue();
        Encoding.zap[64] = (char)h.get("a9").intValue();
        Encoding.zap[65] = (char)h.get("a10").intValue();
        Encoding.zap[66] = (char)h.get("a29").intValue();
        Encoding.zap[67] = (char)h.get("a30").intValue();
        Encoding.zap[68] = (char)h.get("a31").intValue();
        Encoding.zap[69] = (char)h.get("a32").intValue();
        Encoding.zap[70] = (char)h.get("a33").intValue();
        Encoding.zap[71] = (char)h.get("a34").intValue();
        Encoding.zap[72] = (char)h.get("a35").intValue();
        Encoding.zap[73] = (char)h.get("a36").intValue();
        Encoding.zap[74] = (char)h.get("a37").intValue();
        Encoding.zap[75] = (char)h.get("a38").intValue();
        Encoding.zap[76] = (char)h.get("a39").intValue();
        Encoding.zap[77] = (char)h.get("a40").intValue();
        Encoding.zap[78] = (char)h.get("a41").intValue();
        Encoding.zap[79] = (char)h.get("a42").intValue();
        Encoding.zap[80] = (char)h.get("a43").intValue();
        Encoding.zap[81] = (char)h.get("a44").intValue();
        Encoding.zap[82] = (char)h.get("a45").intValue();
        Encoding.zap[83] = (char)h.get("a46").intValue();
        Encoding.zap[84] = (char)h.get("a47").intValue();
        Encoding.zap[85] = (char)h.get("a48").intValue();
        Encoding.zap[86] = (char)h.get("a49").intValue();
        Encoding.zap[87] = (char)h.get("a50").intValue();
        Encoding.zap[88] = (char)h.get("a51").intValue();
        Encoding.zap[89] = (char)h.get("a52").intValue();
        Encoding.zap[90] = (char)h.get("a53").intValue();
        Encoding.zap[91] = (char)h.get("a54").intValue();
        Encoding.zap[92] = (char)h.get("a55").intValue();
        Encoding.zap[93] = (char)h.get("a56").intValue();
        Encoding.zap[94] = (char)h.get("a57").intValue();
        Encoding.zap[95] = (char)h.get("a58").intValue();
        Encoding.zap[96] = (char)h.get("a59").intValue();
        Encoding.zap[97] = (char)h.get("a60").intValue();
        Encoding.zap[98] = (char)h.get("a61").intValue();
        Encoding.zap[99] = (char)h.get("a62").intValue();
        Encoding.zap[100] = (char)h.get("a63").intValue();
        Encoding.zap[101] = (char)h.get("a64").intValue();
        Encoding.zap[102] = (char)h.get("a65").intValue();
        Encoding.zap[103] = (char)h.get("a66").intValue();
        Encoding.zap[104] = (char)h.get("a67").intValue();
        Encoding.zap[105] = (char)h.get("a68").intValue();
        Encoding.zap[106] = (char)h.get("a69").intValue();
        Encoding.zap[107] = (char)h.get("a70").intValue();
        Encoding.zap[108] = (char)h.get("a71").intValue();
        Encoding.zap[109] = (char)h.get("a72").intValue();
        Encoding.zap[110] = (char)h.get("a73").intValue();
        Encoding.zap[111] = (char)h.get("a74").intValue();
        Encoding.zap[112] = (char)h.get("a203").intValue();
        Encoding.zap[113] = (char)h.get("a75").intValue();
        Encoding.zap[114] = (char)h.get("a204").intValue();
        Encoding.zap[115] = (char)h.get("a76").intValue();
        Encoding.zap[116] = (char)h.get("a77").intValue();
        Encoding.zap[117] = (char)h.get("a78").intValue();
        Encoding.zap[118] = (char)h.get("a79").intValue();
        Encoding.zap[119] = (char)h.get("a81").intValue();
        Encoding.zap[120] = (char)h.get("a82").intValue();
        Encoding.zap[121] = (char)h.get("a83").intValue();
        Encoding.zap[122] = (char)h.get("a84").intValue();
        Encoding.zap[123] = (char)h.get("a97").intValue();
        Encoding.zap[124] = (char)h.get("a98").intValue();
        Encoding.zap[125] = (char)h.get("a99").intValue();
        Encoding.zap[126] = (char)h.get("a100").intValue();
        Encoding.zap[128] = (char)h.get("a89").intValue();
        Encoding.zap[129] = (char)h.get("a90").intValue();
        Encoding.zap[130] = (char)h.get("a93").intValue();
        Encoding.zap[131] = (char)h.get("a94").intValue();
        Encoding.zap[132] = (char)h.get("a91").intValue();
        Encoding.zap[133] = (char)h.get("a92").intValue();
        Encoding.zap[134] = (char)h.get("a205").intValue();
        Encoding.zap[135] = (char)h.get("a85").intValue();
        Encoding.zap[136] = (char)h.get("a206").intValue();
        Encoding.zap[137] = (char)h.get("a86").intValue();
        Encoding.zap[138] = (char)h.get("a87").intValue();
        Encoding.zap[139] = (char)h.get("a88").intValue();
        Encoding.zap[140] = (char)h.get("a95").intValue();
        Encoding.zap[141] = (char)h.get("a96").intValue();
        Encoding.zap[161] = (char)h.get("a101").intValue();
        Encoding.zap[162] = (char)h.get("a102").intValue();
        Encoding.zap[163] = (char)h.get("a103").intValue();
        Encoding.zap[164] = (char)h.get("a104").intValue();
        Encoding.zap[165] = (char)h.get("a106").intValue();
        Encoding.zap[166] = (char)h.get("a107").intValue();
        Encoding.zap[167] = (char)h.get("a108").intValue();
        Encoding.zap[168] = (char)h.get("a112").intValue();
        Encoding.zap[169] = (char)h.get("a111").intValue();
        Encoding.zap[170] = (char)h.get("a110").intValue();
        Encoding.zap[171] = (char)h.get("a109").intValue();
        Encoding.zap[172] = (char)h.get("a120").intValue();
        Encoding.zap[173] = (char)h.get("a121").intValue();
        Encoding.zap[174] = (char)h.get("a122").intValue();
        Encoding.zap[175] = (char)h.get("a123").intValue();
        Encoding.zap[176] = (char)h.get("a124").intValue();
        Encoding.zap[177] = (char)h.get("a125").intValue();
        Encoding.zap[178] = (char)h.get("a126").intValue();
        Encoding.zap[179] = (char)h.get("a127").intValue();
        Encoding.zap[180] = (char)h.get("a128").intValue();
        Encoding.zap[181] = (char)h.get("a129").intValue();
        Encoding.zap[182] = (char)h.get("a130").intValue();
        Encoding.zap[183] = (char)h.get("a131").intValue();
        Encoding.zap[184] = (char)h.get("a132").intValue();
        Encoding.zap[185] = (char)h.get("a133").intValue();
        Encoding.zap[186] = (char)h.get("a134").intValue();
        Encoding.zap[187] = (char)h.get("a135").intValue();
        Encoding.zap[188] = (char)h.get("a136").intValue();
        Encoding.zap[189] = (char)h.get("a137").intValue();
        Encoding.zap[190] = (char)h.get("a138").intValue();
        Encoding.zap[191] = (char)h.get("a139").intValue();
        Encoding.zap[192] = (char)h.get("a140").intValue();
        Encoding.zap[193] = (char)h.get("a141").intValue();
        Encoding.zap[194] = (char)h.get("a142").intValue();
        Encoding.zap[195] = (char)h.get("a143").intValue();
        Encoding.zap[196] = (char)h.get("a144").intValue();
        Encoding.zap[197] = (char)h.get("a145").intValue();
        Encoding.zap[198] = (char)h.get("a146").intValue();
        Encoding.zap[199] = (char)h.get("a147").intValue();
        Encoding.zap[200] = (char)h.get("a148").intValue();
        Encoding.zap[201] = (char)h.get("a149").intValue();
        Encoding.zap[202] = (char)h.get("a150").intValue();
        Encoding.zap[203] = (char)h.get("a151").intValue();
        Encoding.zap[204] = (char)h.get("a152").intValue();
        Encoding.zap[205] = (char)h.get("a153").intValue();
        Encoding.zap[206] = (char)h.get("a154").intValue();
        Encoding.zap[207] = (char)h.get("a155").intValue();
        Encoding.zap[208] = (char)h.get("a156").intValue();
        Encoding.zap[209] = (char)h.get("a157").intValue();
        Encoding.zap[210] = (char)h.get("a158").intValue();
        Encoding.zap[211] = (char)h.get("a159").intValue();
        Encoding.zap[212] = (char)h.get("a160").intValue();
        Encoding.zap[213] = (char)h.get("a161").intValue();
        Encoding.zap[214] = (char)h.get("a163").intValue();
        Encoding.zap[215] = (char)h.get("a164").intValue();
        Encoding.zap[216] = (char)h.get("a196").intValue();
        Encoding.zap[217] = (char)h.get("a165").intValue();
        Encoding.zap[218] = (char)h.get("a192").intValue();
        Encoding.zap[219] = (char)h.get("a166").intValue();
        Encoding.zap[220] = (char)h.get("a167").intValue();
        Encoding.zap[221] = (char)h.get("a168").intValue();
        Encoding.zap[222] = (char)h.get("a169").intValue();
        Encoding.zap[223] = (char)h.get("a170").intValue();
        Encoding.zap[224] = (char)h.get("a171").intValue();
        Encoding.zap[225] = (char)h.get("a172").intValue();
        Encoding.zap[226] = (char)h.get("a173").intValue();
        Encoding.zap[227] = (char)h.get("a162").intValue();
        Encoding.zap[228] = (char)h.get("a174").intValue();
        Encoding.zap[229] = (char)h.get("a175").intValue();
        Encoding.zap[230] = (char)h.get("a176").intValue();
        Encoding.zap[231] = (char)h.get("a177").intValue();
        Encoding.zap[232] = (char)h.get("a178").intValue();
        Encoding.zap[233] = (char)h.get("a179").intValue();
        Encoding.zap[234] = (char)h.get("a193").intValue();
        Encoding.zap[235] = (char)h.get("a180").intValue();
        Encoding.zap[236] = (char)h.get("a199").intValue();
        Encoding.zap[237] = (char)h.get("a181").intValue();
        Encoding.zap[238] = (char)h.get("a200").intValue();
        Encoding.zap[239] = (char)h.get("a182").intValue();
        Encoding.zap[241] = (char)h.get("a201").intValue();
        Encoding.zap[242] = (char)h.get("a183").intValue();
        Encoding.zap[243] = (char)h.get("a184").intValue();
        Encoding.zap[244] = (char)h.get("a197").intValue();
        Encoding.zap[245] = (char)h.get("a185").intValue();
        Encoding.zap[246] = (char)h.get("a194").intValue();
        Encoding.zap[247] = (char)h.get("a198").intValue();
        Encoding.zap[248] = (char)h.get("a186").intValue();
        Encoding.zap[249] = (char)h.get("a195").intValue();
        Encoding.zap[250] = (char)h.get("a187").intValue();
        Encoding.zap[251] = (char)h.get("a188").intValue();
        Encoding.zap[252] = (char)h.get("a189").intValue();
        Encoding.zap[253] = (char)h.get("a190").intValue();
        Encoding.zap[254] = (char)h.get("a191").intValue();
    }
}

