/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Defs {
    private static final Logger logger = Logger.getLogger(Defs.class.toString());

    public static String property(String string) {
        return Defs.property(string, null);
    }

    public static String property(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            Defs.property(string, string2);
            return string2;
        }
    }

    public static int intProperty(String string, int n) {
        String string2 = Defs.property(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.FINE, "Failed to parse property.", numberFormatException);
            }
        }
        return n;
    }

    public static boolean booleanProperty(String string) {
        return Defs.booleanProperty(string, false);
    }

    public static boolean booleanProperty(String string, boolean bl) {
        String string2 = Defs.property(string);
        if (string2 != null) {
            switch (string2.length()) {
                case 2: {
                    if (!"no".equals(string2.toLowerCase())) break;
                    return false;
                }
                case 3: {
                    if (!"yes".equals(string2.toLowerCase())) break;
                    return true;
                }
                case 4: {
                    if (!"true".equals(string2.toLowerCase())) break;
                    return true;
                }
                case 5: {
                    if (!"false".equals(string2.toLowerCase())) break;
                    return false;
                }
            }
        }
        return bl;
    }

    public static String sysProperty(String string) {
        return Defs.property(string);
    }

    public static String sysProperty(String string, String string2) {
        return Defs.property(string, string2);
    }

    public static int sysPropertyInt(String string, int n) {
        return Defs.intProperty(string, n);
    }

    public static boolean sysPropertyBoolean(String string) {
        return Defs.booleanProperty(string);
    }

    public static boolean sysPropertyBoolean(String string, boolean bl) {
        return Defs.booleanProperty(string, bl);
    }

    public static void setProperty(String string, Object object) {
        try {
            Properties properties = System.getProperties();
            if (object != null) {
                properties.put(string, object);
            }
        }
        catch (SecurityException securityException) {
            Defs.setProperty(string, object);
        }
    }

    public static void setSystemProperty(String string, String string2) {
        Defs.setProperty(string, string2);
    }
}

