/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.ttf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.pdfbox.ttf.CMAPTable;
import org.pdfbox.ttf.DigitalSignatureTable;
import org.pdfbox.ttf.GlyphTable;
import org.pdfbox.ttf.HeaderTable;
import org.pdfbox.ttf.HorizontalHeaderTable;
import org.pdfbox.ttf.HorizontalMetricsTable;
import org.pdfbox.ttf.IndexToLocationTable;
import org.pdfbox.ttf.MaximumProfileTable;
import org.pdfbox.ttf.NamingTable;
import org.pdfbox.ttf.OS2WindowsMetricsTable;
import org.pdfbox.ttf.PostScriptTable;
import org.pdfbox.ttf.RAFDataStream;
import org.pdfbox.ttf.TTFDataStream;
import org.pdfbox.ttf.TTFTable;
import org.pdfbox.ttf.TrueTypeFont;

public class TTFParser {
    public TrueTypeFont parseTTF(String ttfFile) throws IOException {
        RAFDataStream raf = new RAFDataStream(ttfFile, "r");
        return this.parseTTF(raf);
    }

    public TrueTypeFont parseTTF(File ttfFile) throws IOException {
        RAFDataStream raf = new RAFDataStream(ttfFile, "r");
        return this.parseTTF(raf);
    }

    public TrueTypeFont parseTTF(TTFDataStream raf) throws IOException {
        TrueTypeFont font = new TrueTypeFont(raf);
        font.setVersion(raf.read32Fixed());
        int numberOfTables = raf.readUnsignedShort();
        int searchRange = raf.readUnsignedShort();
        int entrySelector = raf.readUnsignedShort();
        int rangeShift = raf.readUnsignedShort();
        for (int i = 0; i < numberOfTables; ++i) {
            TTFTable table = this.readTableDirectory(raf);
            font.addTable(table);
        }
        ArrayList<TTFTable> initialized = new ArrayList<TTFTable>();
        HeaderTable head = font.getHeader();
        raf.seek(head.getOffset());
        head.initData(font, raf);
        initialized.add(head);
        HorizontalHeaderTable hh = font.getHorizontalHeader();
        raf.seek(hh.getOffset());
        hh.initData(font, raf);
        initialized.add(hh);
        MaximumProfileTable maxp = font.getMaximumProfile();
        raf.seek(maxp.getOffset());
        maxp.initData(font, raf);
        initialized.add(maxp);
        PostScriptTable post = font.getPostScript();
        raf.seek(post.getOffset());
        post.initData(font, raf);
        initialized.add(post);
        IndexToLocationTable loc = font.getIndexToLocation();
        raf.seek(loc.getOffset());
        loc.initData(font, raf);
        initialized.add(loc);
        Iterator iter = font.getTables().iterator();
        while (iter.hasNext()) {
            TTFTable table = (TTFTable)iter.next();
            if (initialized.contains(table)) continue;
            raf.seek(table.getOffset());
            table.initData(font, raf);
        }
        return font;
    }

    private TTFTable readTableDirectory(TTFDataStream raf) throws IOException {
        TTFTable retval = null;
        String tag = raf.readString(4);
        retval = tag.equals("cmap") ? new CMAPTable() : (tag.equals("glyf") ? new GlyphTable() : (tag.equals("head") ? new HeaderTable() : (tag.equals("hhea") ? new HorizontalHeaderTable() : (tag.equals("hmtx") ? new HorizontalMetricsTable() : (tag.equals("loca") ? new IndexToLocationTable() : (tag.equals("maxp") ? new MaximumProfileTable() : (tag.equals("name") ? new NamingTable() : (tag.equals("OS/2") ? new OS2WindowsMetricsTable() : (tag.equals("post") ? new PostScriptTable() : (tag.equals("glyf") ? new GlyphTable() : (tag.equals("glyf") ? new GlyphTable() : (tag.equals("DSIG") ? new DigitalSignatureTable() : new TTFTable()))))))))))));
        retval.setTag(tag);
        retval.setCheckSum(raf.readUnsignedInt());
        retval.setOffset(raf.readUnsignedInt());
        retval.setLength(raf.readUnsignedInt());
        return retval;
    }
}

