<?php
	/**
	 * Contact Module
	 */
	class ContactListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function ContactListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getContactProperties();

			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));

			$this->start = 0;
		}

		/**
		 * Executes all the actions in the $data variable.
		 * @return boolean true on success of false on fialure.
		 */
		function execute()
		{
			foreach($this->data as $actionType => $action)
			{
				if(isset($actionType)) {
					try {
						$store = $this->getActionStore($action);
						$parententryid = $this->getActionParentEntryID($action);
						$entryid = $this->getActionEntryID($action);

						switch($actionType)
						{
							case "list":
								$this->getDelegateFolderInfo($store);
								$this->messageList($store, $entryid, $action, $actionType);
								break;
							case "search":
								// @FIXME add handling for private items
								$this->search($store, $entryid, $action, $actionType);
								break;
							case "updatesearch":
								$this->updatesearch($store, $entryid, $action);
								break;
							case "stopsearch":
								$this->stopSearch($store, $entryid, $action);
								break;
							default:
								$this->handleUnknownActionType($actionType);
						}
					} catch (MAPIException $e) {
						$this->processException($e, $actionType);
					}
				}
			}
		}

		/**
		 * Function is used to filter out properties which aren't usefull in the listview and we should
		 * remove it when getting listview data, this function gives us performance benefit of sending less data
		 * in listview because sending properties like body, message_transport_headers in list view can increase
		 * the response data a lot.
		 * We don't want to store filtered properties in the module object because module object should always
		 * have list of all properties.
		 * @return {Object} filtered properties that will be used to get data for list view.
		 */
		function filterOutExtraProperties()
		{
			$properties = $this->properties;

			unset($properties['members']);
			unset($properties['oneoff_members']);

			unset($properties['email_address_entryid_1']);
			unset($properties['email_address_display_name_1']);
			unset($properties['email_address_display_name_email_1']);
			unset($properties['email_address_type_1']);
			unset($properties['email_address_entryid_2']);
			unset($properties['email_address_display_name_2']);
			unset($properties['email_address_display_name_email_2']);
			unset($properties['email_address_type_2']);
			unset($properties['email_address_entryid_3']);
			unset($properties['email_address_display_name_3']);
			unset($properties['email_address_display_name_email_3']);
			unset($properties['email_address_type_3']);

			unset($properties['fax_1_address_type']);
			unset($properties['fax_1_email_address']);
			unset($properties['fax_1_original_display_name']);
			unset($properties['fax_1_original_entryid']);
			unset($properties['fax_2_address_type']);
			unset($properties['fax_2_email_address']);
			unset($properties['fax_2_original_display_name']);
			unset($properties['fax_2_original_entryid']);
			unset($properties['fax_3_address_type']);
			unset($properties['fax_3_email_address']);
			unset($properties['fax_3_original_display_name']);
			unset($properties['fax_3_original_entryid']);

			unset($properties['home_address_street']);
			unset($properties['home_address_city']);
			unset($properties['home_address_state']);
			unset($properties['home_address_postal_code']);
			unset($properties['home_address_country']);
			unset($properties['other_address_street']);
			unset($properties['other_address_city']);
			unset($properties['other_address_state']);
			unset($properties['other_address_postal_code']);
			unset($properties['other_address_country']);
			unset($properties['business_address_street']);
			unset($properties['business_address_city']);
			unset($properties['business_address_state']);
			unset($properties['business_address_postal_code']);
			unset($properties['business_address_country']);

			unset($properties['birthday_eventid']);
			unset($properties['anniversary_eventid']);

			return $properties;
		}
	}
?>
