<?php
	include_once('mapi/class.taskrecurrence.php');

	/**
	 * Task Module
	 */
	class TaskListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function TaskListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getTaskProperties();

			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));

			$this->start = 0;
		}

		/**
		 * Executes all the actions in the $data variable.
		 * @return boolean true on success of false on fialure.
		 */
		function execute()
		{
			foreach($this->data as $actionType => $action)
			{
				if(isset($actionType)) {
					try {
						$store = $this->getActionStore($action);
						$parententryid = $this->getActionParentEntryID($action);
						$entryid = $this->getActionEntryID($action);

						switch($actionType)
						{
							case "list":
								$this->getDelegateFolderInfo($store);
								$this->messageList($store, $entryid, $action, $actionType);
								break;
							case "search":
								// @FIXME add handling of private items
								$this->search($store, $entryid, $action, $actionType);
								break;
							case "updatesearch":
								$this->updatesearch($store, $entryid, $action);
								break;
							case "stopsearch":
								$this->stopSearch($store, $entryid, $action);
								break;
							default:
								$this->handleUnknownActionType($actionType);
						}
					} catch (MAPIException $e) {
						$this->processException($e, $actionType);
					}
				}
			}
		}

		/**
		 * Function is used to filter out properties which aren't usefull in the listview and we should
		 * remove it when getting listview data, this function gives us performance benefit of sending less data
		 * in listview because sending properties like body, message_transport_headers in list view can increase
		 * the response data a lot.
		 * We don't want to store filtered properties in the module object because module object should always
		 * have list of all properties.
		 * @return {Object} filtered properties that will be used to get data for list view.
		 */
		function filterOutExtraProperties()
		{
			$properties = $this->properties;

			unset($properties['sent_representing_entryid']);
			unset($properties['sent_representing_name']);
			unset($properties['sent_representing_address_type']);
			unset($properties['sent_representing_email_address']);
			unset($properties['sent_representing_search_key']);
			unset($properties['sender_email_address']);
			unset($properties['sender_name']);
			unset($properties['sender_address_type']);
			unset($properties['sender_entryid']);
			unset($properties['sender_search_key']);

			return $properties;
		}
	}
?>
