/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sourceforge.jffmpeg.CodecManager;
import net.sourceforge.jffmpeg.JMFCodec;
import net.sourceforge.jffmpeg.JffmpegVideoFormat;

public class VideoDecoder
implements Codec {
    private CodecManager codecManager = new CodecManager();
    private JMFCodec peer = null;

    public Format[] getSupportedInputFormats() {
        return this.codecManager.getSupportedVideoFormats();
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return new Format[0];
        }
        JffmpegVideoFormat jffmpegVideoFormat = this.codecManager.getVideoCodec(format.getEncoding());
        if (format instanceof VideoFormat && jffmpegVideoFormat.isNative()) {
            VideoFormat videoFormat = (VideoFormat)format;
            Dimension dimension = videoFormat.getSize();
            int n = dimension.width;
            int n2 = n / 2;
            int n3 = n * dimension.height;
            int n4 = n3 + n2 * dimension.height / 2;
            return new VideoFormat[]{new YUVFormat(dimension, (n + n2) * dimension.height, Format.byteArray, videoFormat.getFrameRate(), 2, n, n2, 0, n3, n4), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 15, -1, -1, -1, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 16, -1, -1, -1, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, videoFormat.getFrameRate(), 24, -1, -1, -1, 3, dimension.width * 3, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.intArray, videoFormat.getFrameRate(), 32, -1, -1, -1, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 16, 31744, 992, 31, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 16, 63488, 992, 31, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 3, 2, 1, 3, dimension.width * 3, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.intArray, videoFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, dimension.width, 0, -1)};
        }
        if (format instanceof VideoFormat && !jffmpegVideoFormat.isNative()) {
            return new Format[]{new RGBFormat()};
        }
        return new Format[0];
    }

    public Format setInputFormat(Format format) {
        JffmpegVideoFormat jffmpegVideoFormat = this.codecManager.getVideoCodec(format.getEncoding());
        if (jffmpegVideoFormat == null) {
            return null;
        }
        Dimension dimension = ((VideoFormat)format).getSize();
        if (dimension == null) {
            return null;
        }
        try {
            this.peer = (JMFCodec)Class.forName(jffmpegVideoFormat.getCodecClass()).newInstance();
            if (!this.peer.isCodecAvailable()) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        this.peer.setVideoSize(dimension);
        this.peer.setEncoding(jffmpegVideoFormat.getFFMpegCodecName());
        this.peer.setIsRtp(jffmpegVideoFormat.isRtp());
        this.peer.setIsTruncated(jffmpegVideoFormat.isTruncated());
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (this.peer == null) {
            throw new IllegalArgumentException("Must set Input Format first");
        }
        return this.peer.setOutputFormat(format);
    }

    public int process(Buffer buffer, Buffer buffer2) {
        return this.peer.process(buffer, buffer2);
    }

    public void open() throws ResourceUnavailableException {
        this.peer.open();
    }

    public void close() {
        this.peer.close();
    }

    public void reset() {
        this.peer.reset();
    }

    public String getName() {
        return "FFMPEG video decoder";
    }

    public Object[] getControls() {
        return null;
    }

    public Object getControl(String string) {
        return null;
    }
}

