/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.expression.Expression;
import org.h2.index.IndexCondition;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ValueExpression
extends Expression {
    private Value value;
    public static ValueExpression NULL = new ValueExpression(ValueNull.INSTANCE);

    public static ValueExpression get(Value v) {
        if (v == ValueNull.INSTANCE) {
            return NULL;
        }
        return new ValueExpression(v);
    }

    private ValueExpression(Value value) {
        this.value = value;
    }

    public Value getValue(SessionInterface session) {
        return this.value;
    }

    public int getType() {
        return this.value.getType();
    }

    public void createIndexConditions(TableFilter filter) {
        boolean v;
        if (this.value.getType() == 1 && !(v = ((ValueBoolean)this.value).getBoolean().booleanValue())) {
            filter.addIndexCondition(new IndexCondition(8, null, this));
        }
    }

    public void mapColumns(TableFilter tableFilter, int level) throws SQLException {
    }

    public Expression optimize(Session session) throws SQLException {
        return this;
    }

    public boolean isEvaluatable(int filterLevel) {
        return true;
    }

    public boolean isConstant() {
        return true;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
    }

    public int getScale() {
        return this.value.getScale();
    }

    public long getPrecision() {
        return this.value.getPrecision();
    }

    public String getSQL() {
        return this.value.getSQL();
    }

    public void updateAggregate(Session session) throws SQLException {
    }
}

