/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.test.TestBase;
import org.h2.test.bnf.Config;
import org.h2.test.bnf.RuleHead;
import org.h2.test.bnf.RuleParser;

public class TestRandomSQL
extends TestBase {
    private void processException(String sql, SQLException e) {
        if (e.getSQLState().equals("HY000")) {
            new Error(sql, e).printStackTrace();
            System.exit(0);
        }
    }

    private Connection connect() throws SQLException {
        return DriverManager.getConnection("jdbc:h2:test", "", "");
    }

    public void test() throws Exception {
        RuleParser ruleParser = new RuleParser();
        ruleParser.parse();
        Config config = ruleParser.getConfig();
        ArrayList statements = ruleParser.getStatements();
        HashMap ruleMap = config.getRuleMap();
        Iterator it = ruleMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            RuleHead r = (RuleHead)ruleMap.get(key);
            r.getRule().setLinks(ruleMap);
        }
        Class.forName("org.h2.Driver");
        int a = 0;
        while (true) {
            System.out.println("a=" + a);
            if (a % 5 == 0) {
                this.deleteDb("test");
            }
            Connection conn = null;
            try {
                conn = this.connect();
            }
            catch (SQLException e) {
                this.processException("connect", e);
                this.deleteDb("test");
                conn = this.connect();
            }
            Statement stat = conn.createStatement();
            for (int i = 0; i < statements.size(); ++i) {
                RuleHead r = (RuleHead)statements.get(i);
                String rand = r.getRule().random(config, 0);
                if (rand.length() <= 0) continue;
                try {
                    System.out.println(i + "  " + rand);
                    stat.execute(rand);
                    continue;
                }
                catch (SQLException e) {
                    this.processException(rand, e);
                }
            }
            conn.close();
            ++a;
        }
    }
}

