/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class MultiDimension {
    private static MultiDimension instance = new MultiDimension();

    private MultiDimension() {
    }

    public static MultiDimension getInstance() {
        return instance;
    }

    public long interleave(int[] values) {
        long xx;
        int dimensions = values.length;
        int bitsPerValue = 64 / dimensions;
        long max = 1L << bitsPerValue;
        long x = 0L;
        for (int i = 0; i < dimensions; ++i) {
            long k = values[i];
            if (k < 0L || k > max) {
                throw new Error("value out of range; value=" + values[i] + " min=0 max=" + max);
            }
            for (int b = 0; b < bitsPerValue; ++b) {
                x |= (k & 1L << b) << i + (dimensions - 1) * b;
            }
        }
        if (dimensions == 2 && (xx = this.getMorton2(values[0], values[1])) != x) {
            throw new Error("test");
        }
        return x;
    }

    public int deinterleave(long scalar, int dimensions, int dim) {
        int bitsPerValue = 64 / dimensions;
        int value = 0;
        for (int i = 0; i < bitsPerValue; ++i) {
            value = (int)((long)value | scalar >> dim + (dimensions - 1) * i & 1L << i);
        }
        return value;
    }

    public String getMultiDimensionalQuery(String table, String scalarColumn, String[] columns, int[] min, int[] max) {
        long[][] ranges = this.getMortonRanges(min, max);
        StringBuffer buff = new StringBuffer("SELECT * FROM (");
        for (int i = 0; i < ranges.length; ++i) {
            if (i > 0) {
                buff.append(" UNION ALL ");
            }
            long minScalar = ranges[i][0];
            long maxScalar = ranges[i][1];
            buff.append("SELECT * FROM ").append(table).append(" WHERE ");
            buff.append(scalarColumn).append(" BETWEEN ");
            buff.append(minScalar).append(" AND ").append(maxScalar);
        }
        buff.append(") WHERE ");
        for (int j = 0; j < columns.length; ++j) {
            if (j > 0) {
                buff.append(" AND ");
            }
            buff.append(columns[j]).append(" BETWEEN ");
            buff.append(min[j]).append(" AND ").append(max[j]);
        }
        return buff.toString();
    }

    public long[][] getMortonRanges(int[] min, int[] max) {
        int len = min.length;
        if (max.length != len) {
            throw new Error("dimensions mismatch");
        }
        for (int i = 0; i < len; ++i) {
            if (min[i] <= max[i]) continue;
            int temp = min[i];
            min[i] = max[i];
            max[i] = temp;
        }
        int total = this.getSize(min, max, len);
        ArrayList list = new ArrayList();
        this.addMortonRanges(list, min, max, len, 0);
        this.optimize(list, total);
        long[][] ranges = new long[list.size()][2];
        list.toArray((T[])ranges);
        return ranges;
    }

    private long getMorton2(int x, int y) {
        long z = 0L;
        for (int i = 0; i < 32; ++i) {
            z |= ((long)x & 1L << i) << i;
            z |= ((long)y & 1L << i) << i + 1;
        }
        return z;
    }

    private int getSize(int[] min, int[] max, int len) {
        int size = 1;
        for (int i = 0; i < len; ++i) {
            int diff = max[i] - min[i];
            size *= diff + 1;
        }
        return size;
    }

    private void optimize(ArrayList list, int total) {
        Collections.sort(list, new Comparator(){

            public int compare(Object a, Object b) {
                long[] la = (long[])a;
                long[] lb = (long[])b;
                return la[0] > lb[0] ? 1 : -1;
            }
        });
        int minGap = 10;
        while (true) {
            for (int i = 0; i < list.size() - 1; ++i) {
                long[] next;
                long[] current = (long[])list.get(i);
                if (current[1] + (long)minGap < (next = (long[])list.get(i + 1))[0]) continue;
                current[1] = next[1];
                list.remove(i + 1);
                --i;
            }
            int searched = 0;
            for (int j = 0; j < list.size(); ++j) {
                long[] range = (long[])list.get(j);
                searched = (int)((long)searched + (range[1] - range[0] + 1L));
            }
            if (searched > 2 * total || list.size() < 3) break;
            minGap += minGap / 2;
        }
    }

    private void addMortonRanges(ArrayList list, int[] min, int[] max, int len, int level) {
        if (level > 100) {
            throw new Error("Stop");
        }
        int largest = 0;
        int largestDiff = 0;
        long size = 1L;
        for (int i = 0; i < len; ++i) {
            int diff = max[i] - min[i];
            if (diff < 0) {
                throw new Error("Stop");
            }
            if ((size *= (long)(diff + 1)) < 0L) {
                throw new Error("Stop");
            }
            if (diff <= largestDiff) continue;
            largestDiff = diff;
            largest = i;
        }
        long low = this.interleave(min);
        long high = this.interleave(max);
        if (high < low) {
            throw new Error("Stop");
        }
        long range = high - low + 1L;
        if (range == size) {
            long[] item = new long[]{low, high};
            list.add(item);
        } else {
            int middle = this.findMiddle(min[largest], max[largest]);
            int temp = max[largest];
            max[largest] = middle;
            this.addMortonRanges(list, min, max, len, level + 1);
            max[largest] = temp;
            temp = min[largest];
            min[largest] = middle + 1;
            this.addMortonRanges(list, min, max, len, level + 1);
            min[largest] = temp;
        }
    }

    private int roundUp(int x, int blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1 & -blockSizePowerOf2;
    }

    private int findMiddle(int a, int b) {
        int m;
        int diff = b - a - 1;
        if (diff == 0) {
            return a;
        }
        if (diff == 1) {
            return a + 1;
        }
        int scale = 0;
        while (1 << scale < diff) {
            ++scale;
        }
        if ((m = this.roundUp(a + 2, 1 << --scale) - 1) <= a || m >= b) {
            throw new Error("stop");
        }
        return m;
    }
}

