/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public class MemoryFile {
    private String name;
    private int length;
    private byte[] data;
    private int pos;
    private byte[] magic;

    MemoryFile(String name) {
        this.name = name;
        this.data = new byte[16];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long length() {
        return this.length;
    }

    public void setLength(long l) {
        this.length = (int)l;
    }

    public void seek(long pos) {
        this.pos = (int)pos;
    }

    public void write(byte[] b, int off, int len) {
        if (this.pos + len > this.length) {
            this.length = this.pos + len;
        }
        if (this.pos + len > this.data.length) {
            byte[] n = new byte[this.length * 2];
            System.arraycopy(this.data, 0, n, 0, this.data.length);
            this.data = n;
        }
        System.arraycopy(b, off, this.data, this.pos, len);
        this.pos += len;
    }

    public void readFully(byte[] b, int off, int len) {
        if (this.pos + len > this.length) {
            this.length = this.pos + len;
        }
        if (this.pos + len > this.data.length) {
            byte[] n = new byte[this.length * 2];
            System.arraycopy(this.data, 0, n, 0, this.data.length);
            this.data = n;
        }
        System.arraycopy(this.data, this.pos, b, off, len);
        this.pos += len;
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void setMagic(byte[] magic) {
        this.magic = magic;
    }

    public byte[] getMagic() {
        return this.magic;
    }
}

